/*
 * Created on 2004/09/28
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;



/**
 * SNMP}l[WɂSNMP V2̐ݒsNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ManagerV2MP extends AbstractManagerV1V2MP {
    /* MO */
    private static Logger logger;

    /**
     * SNMP}l[WɂSNMP V2̐ݒsNXCX^X𐶐܂B
     *
     */
    public ManagerV2MP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMP}l[WɂSNMP V2̐ݒsNXCX^X𐶐܂B
     *
     * @param dSocket DatagramSocket
     * @param hostAddress AgnetAhX
     * @param community R~jeB
     * @throws SnmpConfigurationException SNMP\`񂪈ُȏꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\`񂪈ُȏꍇ
     */
    public ManagerV2MP(
        DatagramSocket dSocket, InetAddress hostAddress, String community)
        throws SnmpConfigurationException, SnmpV3ConfigurationException {
        logger = Logger.getLogger(this.getClass().getName());

        /* SNMP Ver.2Zbg */
        this.version = SnmpPreference.SNMPV2C;
        this.dSocket = dSocket;
        this.targetAddress = hostAddress;
        this.community = community;

        this.setConfig(dSocket, hostAddress);
    }

    /**
     * SNMP}l[WɂSNMP V2̐ݒsNXCX^X
     * vpeBZbg܂B
     *
     * @param dSocket DatagramSocket
     * @param hostAddress AgnetAhX
     * @param community R~jeB
     * @throws SnmpConfigurationException SNMP\`񂪈ُȏꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\`񂪈ُȏꍇ
     */
    public void setManagerMP(
        DatagramSocket dSocket, InetAddress hostAddress, String community)
        throws SnmpConfigurationException, SnmpV3ConfigurationException {
        /* SNMP Ver.2Zbg */
        this.version = SnmpPreference.SNMPV2C;
        this.dSocket = dSocket;
        this.targetAddress = hostAddress;
        this.community = community;

        this.setConfig(dSocket, hostAddress);
    }
}
