/*
 * Created on 2004/09/28
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;



/**
 * SNMP}l[WƂẴR}ĥASNMP V1yV2ł
 * Get/Get NextySet RequestR}hNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractManagerV1V2MP
    extends AbstractManagerMessageProcessingSubsystem {
    /* MO */
    private static Logger logger;

    /**
     * SNMP}l[WƂẴR}ĥASNMP V1yV2ł
     * Get/Get NextySet RequestR}hNX
     * CX^X𐶐܂B
     *
     */
    public AbstractManagerV1V2MP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
    * SNMP}l[WƂăvpeBZbg܂B
    *
    * @param dSocket DatagramSocket
    * @param hostAddress AhX
    * @param community R~jeB
    * @throws SnmpConfigurationException SNMP Agent\`ُȏꍇ
    * @throws SnmpV3ConfigurationException SNMP V3 Agent\`ُȏꍇ
    */
    public abstract void setManagerMP(
        DatagramSocket dSocket, InetAddress hostAddress, String community)
        throws SnmpConfigurationException, SnmpV3ConfigurationException;

    /**
     * Snmp V1}l[WłGet Request/Get Next RequestR[h
     * 肵AΉ鏈ĂяoEsf[^͂
     * Ԃ܂B
     *
     * @param code R}hR[h
     * @param requestOID NGXgOID
     * @return returnVarBindList SNMPVarBindList
     * @throws SnmpUnmuchRequestIDException NGXgʎqҒlƈقȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException SNMP V3ɂmsgIDҒlƈقȂꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpBadValueException SNMPf[^܂́A͂ňُoꍇ
     * @throws SnmpV3DecryptAbortException SNMP V3f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException SNMP V3F؂ňُ킪ꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     * @throws SnmpSetException Set RequestɎsꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\`񂪈ُȏꍇ
     * @throws NoRouteToHostException AhXsȏꍇ
     * @throws SocketTimeoutException Socket^CAEgꍇ
     * @throws IOException Mňُ킪ꍇ
     */
    public SnmpVarBindList getProcess(byte code, String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpErrorStatusException, 
            SnmpBadValueException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpMIBGetException, SnmpSetException, 
            SnmpV3ConfigurationException, NoRouteToHostException, 
            SocketTimeoutException, IOException {
        /* SNMPVarBindList */
        SnmpVarBindList returnVarBindList = null;

        switch (code) {
        case SnmpBERCodec.SNMPGETREQUEST:
            returnVarBindList = getMIBEntry(requestOID);

            break;

        case SnmpBERCodec.SNMPGETNEXTREQUEST:
            returnVarBindList = getNextMIBEntry(requestOID);

            break;

        default:
            logger.warning("Undefined SNMP Command code : " + code);
        }

        return returnVarBindList;
    }

    /**
     * SNMP V1}l[WłSet RequestĂяo܂B
     *
     * @param code R}hR[h
     * @param requestOID NGXgOID
     * @param newValue ZbgSNMPIuWFNg
     * @return returnVarBindList SNMPVarBindList
     * @throws SnmpUnmuchRequestIDException NGXgʎqҒlƈقȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException SNMP V3 msgIDҒlƈقȂꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException SNMP V3 f[^ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     * @throws SnmpV3AuthAbortException SNMP V3F؂ňُ킪ꍇ
     * @throws SnmpV3ConfigurationException SNMP V3Ӓ`ُȏꍇ
     * @throws SnmpBadValueException f[^ňُ킪ꍇ
     * @throws SnmpSetException Set requestɎsꍇ
     * @throws NoRouteToHostException AhXsȏꍇ
     * @throws SocketTimeoutException Socket^CAEgꍇ
     * @throws IOException f[^MɎsꍇ
     */
    public SnmpVarBindList setProcess(
        final byte code, final String requestOID,
        final AbstractSnmpObject newValue)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpV3DecryptAbortException, 
            SnmpErrorStatusException, SnmpMIBGetException, 
            SnmpV3AuthAbortException, SnmpSetException, 
            SnmpV3ConfigurationException, SnmpBadValueException, 
            NoRouteToHostException, SocketTimeoutException, IOException {
        /* SNMPVarBindList */
        SnmpVarBindList returnVarBindList = null;

        switch (code) {
        case SnmpBERCodec.SNMPSETREQUEST:
            returnVarBindList = setMIBEntry(requestOID, newValue);

            break;

        default:
            logger.warning("Illegal Command code " + code);
        }

        return returnVarBindList;
    }

    /**
     * GetRequestR}hs܂B
     *
     * @param requestOID NGXgOID
     * @return retrievedVars SNMPVarBindList
     * @throws SnmpBadValueException Mf[^̐Ɏsꍇ
     * @throws SnmpUnmuchRequestIDException Mf[^ʎqƎM
     * f[^̎ʎqA}b`̏ꍇ
     * @throws SnmpUnmuchRequestMsgIDException SNMP V3 msgIDҒlƃA}b`ȏꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpBadValueException f[^ňُ킪ꍇ
     * @throws SnmpMIBGetException SocketTimeout₻ȊOIOException
     * SNMPBadValueExceptiongC񐔂𒴂Ĕꍇ
     * @throws SnmpV3DecryptAbortException SNMP V3f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException SNMP V3F؂ňُ킪ꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂb
     * @throws NoRouteToHostException NoRouteToHostꍇ
     * @throws SocketTimeoutException Socket^CAEgꍇ
     * @throws IOException f[^̑MɎsꍇ
     */
    public SnmpVarBindList getMIBEntry(final String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpBadValueException, 
            SnmpMIBGetException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpV3ConfigurationException, 
            SnmpErrorStatusException, NoRouteToHostException, 
            SocketTimeoutException, IOException {
        int requestID =
            SnmpRequestIDManager.getInstance().getRequestID(
                Thread.currentThread().getName(), requestOID);

        /* SNMPMessage message =
            createSNMPMessage(
                requestID, requestOID, SNMPBERCodec.SNMPGETREQUEST,
                new SNMPNull()); */
        SnmpVarBindList retrievedVars = null;
        SnmpMessage message = null;

        try {
            // SnmpMessage messageInfo = new SnmpMessage();
            // ManagerReceive receive = new ManagerReceive();
            message =
                messageSendInstance.createSNMPMessage(
                    version, community, requestID, requestOID,
                    SnmpBERCodec.SNMPGETREQUEST);

            byte[] messageEncoding = message.getBEREncoding();
            dSocket.connect(targetAddress, snmpPort);
            retrievedVars =
                sendAndReceive(requestID, requestOID, messageEncoding, dSocket);
        } finally {
            dSocket.disconnect();
        }

        return retrievedVars;
    }

    /**
     * Get Next Requests܂B
     *
     *
     * @param requestOID NGXgOID
     * @throws SnmpUnmuchRequestIDException NGXgʎqҒlƈقȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException SNMP V3 msgIDҒlƈقȂꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException SNMP V3 f[^ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     * @throws SnmpBadValueException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException SNMP V3F؂ňُ킪ꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\񂪈ُȏꍇ
     * @throws NoRouteToHostException AhXsȏꍇ
     * @throws SocketTimeoutException Socket^CAEgꍇ
     * @throws IOException f[^MɎsꍇ
     * @return SnmpVarBindList Agent SNMP varBindList
     */
    public SnmpVarBindList getNextMIBEntry(final String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpErrorStatusException, 
            SnmpMIBGetException, SnmpBadValueException, 
            SnmpV3ConfigurationException, NoRouteToHostException, 
            SocketTimeoutException, IOException {
        /*  */
        SnmpVarBindList retrievedVars = null;

        int requestID =
            SnmpRequestIDManager.getInstance().getRequestID(
                Thread.currentThread().getName(), requestOID);

        try {
            SnmpMessage message =
                messageSendInstance.createSNMPMessage(
                    version, community, requestID, requestOID,
                    SnmpBERCodec.SNMPGETNEXTREQUEST);

            // logger.info("Send SNMPMessage.size() : " + message.size());
            // logger.info("Send TLV size() : " + message.getTLV().size());
            byte[] messageEncoding = message.getBEREncoding();
            dSocket.connect(targetAddress, snmpPort);

            retrievedVars =
                sendAndReceive(requestID, requestOID, messageEncoding, dSocket);
        } finally {
            dSocket.disconnect();
        }

        return retrievedVars;
    }

    /**
     * Set Requests܂B
     *
     * @param requestOID NGXgOID
     * @param newValue ZbgSNMPIuWFNg
     * @throws SnmpUnmuchRequestIDException NGXgʎqҒlƈقȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException SNMP V3 msgIDҒlƈقȂꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException SNMP V3 f[^ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     * @throws SnmpBadValueException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException SNMP V3F؂ňُ킪ꍇ
     * @throws SnmpSetException Set requestɎsꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\ňُ킪ꍇ
     * @throws NoRouteToHostException AhXsȏꍇ
     * @throws SocketTimeoutException Socket^CAEgꍇ
     * @throws IOException f[^MɎsꍇ
     * @return Agent SNMP varBind List
    */
    public SnmpVarBindList setMIBEntry(
        final String requestOID, final AbstractSnmpObject newValue)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpErrorStatusException, 
            SnmpBadValueException, SnmpSetException, SnmpMIBGetException, 
            SnmpV3DecryptAbortException, SnmpV3AuthAbortException, 
            SnmpV3ConfigurationException, NoRouteToHostException, 
            SocketTimeoutException, IOException {
        /* Set RequestMPDU쐬 */
        int requestID =
            SnmpRequestIDManager.getInstance().getRequestID(
                Thread.currentThread().getName(), requestOID);
        int errorStatus = 0;
        int errorIndex = 0;
        SnmpObjectIdentifier requestedObjectIdentifier =
            new SnmpObjectIdentifier(requestOID);
        SnmpVariablePair nextPair =
            new SnmpVariablePair(requestedObjectIdentifier, newValue);
        SnmpSequence varList = new SnmpSequence();
        varList.addSNMPObject(nextPair);

        SnmpPDU pdu =
            new SnmpPDU(
                SnmpBERCodec.SNMPSETREQUEST, requestID, errorStatus, errorIndex,
                varList);

        /* Set RequestSNMP VarBindListi[f[^ */
        SnmpVarBindList receiveVarBindList = null;

        /* Set RequestMbZ[WAgentɑM */
        SnmpMessage message = new SnmpMessage(version, community, pdu);
        dSocket.connect(targetAddress, snmpPort);

        byte[] messageEncoding = message.getBEREncoding();

        receiveVarBindList =
            sendAndReceive(requestID, requestOID, messageEncoding, dSocket);

        return receiveVarBindList;
    }
}
