/*
 * Created on 2006/12/27
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;


public class ThreadListReadQueuePushDatabaseWatchControl implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * IDatabseĎm[h̃XgIɓǂŃL[PushThread
     * NXCX^X𐶐܂B
     */
    public ThreadListReadQueuePushDatabaseWatchControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     *
     */
    public void run() {
        int count = 0;
        Iterator it = null;

        while (true) {
            // DatabseĎm[hXgǂݍ
            Map list = ListQueueDatabaseWatchControl.getInstance().getDatabaseHashMap();
            
            
            for (it = list.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                NodeWatchInfo info = (NodeWatchInfo) list.get(key);

                if (info == null) {
                    continue;
                }
                DatabaseWatcherInfo databaseWatchInfo = info.getDatabaseWatcherInfo();
               
                if (databaseWatchInfo == null) {
                    continue;
                }
                
                NodeWatchInfo nodeInfo =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        info.getIpaddress());

                
                if (nodeInfo == null) {
                    continue;
                }
      
                
                // Databseo
                count = Integer.parseInt(databaseWatchInfo.getCountWatcherPeriod());               
                if (count != 0) {
                    count--;
                    databaseWatchInfo.setCountWatcherPeriod(Integer.toString(count));

                    if (count == 0) {
                        // DatabsesL[Push
                        QueueForDatabseWatch.getInstance().pushQue(info);
                        // DatabseJE^Zbg
                        databaseWatchInfo.setCountWatcherPeriod(databaseWatchInfo.getWatcherPeriod());
                    }
                }
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
