/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import netjfwatcher.application.NetJFWatcherAdvisor;
import netjfwatcher.application.NetJFWatcherPlugin;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;



/**
 * Eclipse RCP Window̍\`vtFXy[WNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EngineWorkbenchPreference extends PreferencePage
    implements IWorkbenchPreferencePage {
    /* PreferenceStore */
    private IPreferenceStore prefStore;

    /* Prompt on Exitp`FbN{^ */
    private Button exitWithoutPromptCheckButton;

    /* Workbench@Configurer Setp`FbN{^ */
    private Button workbenchConfigurerCheckButton;

    /* Workbench@Configurer SettO */
    private boolean isWorkbechConfigSet;

    /* Prompt on ExittO */
    private boolean isPromptOnExit;

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
     */
    public void init(IWorkbench workbench) {
        // Initialize the preference store we wish to use
        setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
     */
    protected Control createContents(Composite parent) {
        prefStore = NetJFWatcherPlugin.getDefault().getPreferenceStore();

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridLayout gridLayout = new GridLayout(1, false);
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));

        /*
         * Workbech Configurer`FbNBoxZbg
         */
        workbenchConfigurerCheckButton = new Button(composite, SWT.CHECK);
        workbenchConfigurerCheckButton.setText(
            "Workbench Configurer Set SaveAndRestore");
        workbenchConfigurerCheckButton.setBounds(10, 10, 120, 24);

        boolean workBenchConfigSet =
            prefStore.getBoolean(NetJFWatcherAdvisor.WORKBENCH_CONFIGURER);
        workbenchConfigurerCheckButton.setSelection(workBenchConfigSet);
        isWorkbechConfigSet = workBenchConfigSet;

        /*
         * ExitPromt\`FbNBoxZbg
         */
        exitWithoutPromptCheckButton = new Button(composite, SWT.CHECK);
        exitWithoutPromptCheckButton.setText("Always exit without prompt");
        exitWithoutPromptCheckButton.setBounds(10, 10, 120, 24);

        boolean promptOnExit =
            prefStore.getBoolean(NetJFWatcherAdvisor.PROMPT_ON_EXIT_PREFERENCE);
        exitWithoutPromptCheckButton.setSelection(promptOnExit);
        isPromptOnExit = promptOnExit;

        //Cxg̐ݒ
        workbenchConfigurerCheckButton.addSelectionListener(
            new SelectionListener() {
                public void widgetDefaultSelected(SelectionEvent e) {
                }

                /*
                 * Workbech ConfigurerSet邩ۂFlagZbg
                 */
                public void widgetSelected(SelectionEvent e) {
                    Button bChk = (Button) e.widget;

                    if (bChk.getSelection()) {
                        isWorkbechConfigSet = true;
                    } else {
                        isWorkbechConfigSet = false;
                    }
                }
            });

        //Cxg̐ݒ
        exitWithoutPromptCheckButton.addSelectionListener(
            new SelectionListener() {
                public void widgetDefaultSelected(SelectionEvent event) {
                }

                /*
                 * ExitPromt\sۂFlagZbg
                 */
                public void widgetSelected(SelectionEvent event) {
                    Button bChk = (Button) event.widget;

                    if (bChk.getSelection()) {
                        isPromptOnExit = true;
                    } else {
                        isPromptOnExit = false;
                    }
                }
            });

        return composite;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        prefStore = NetJFWatcherPlugin.getDefault().getPreferenceStore();

        boolean workBenchConfigSet =
            prefStore.getBoolean(NetJFWatcherAdvisor.WORKBENCH_CONFIGURER);
        workbenchConfigurerCheckButton.setSelection(workBenchConfigSet);
        isWorkbechConfigSet = workBenchConfigSet;

        boolean promptOnExit =
            prefStore.getBoolean(NetJFWatcherAdvisor.PROMPT_ON_EXIT_PREFERENCE);
        exitWithoutPromptCheckButton.setSelection(promptOnExit);
        isPromptOnExit = promptOnExit;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performOk()
     */
    public boolean performOk() {
        /*
             * Workbech ConfigurerSet邩ۂvtFXFlagZbg
             */
        if (isWorkbechConfigSet) {
            prefStore.setValue(NetJFWatcherAdvisor.WORKBENCH_CONFIGURER, true);
            NetJFWatcherPlugin.getDefault().savePluginPreferences();
        } else {
            prefStore.setValue(NetJFWatcherAdvisor.WORKBENCH_CONFIGURER, false);
            NetJFWatcherPlugin.getDefault().savePluginPreferences();
        }

        /*
         * ExitPromt\sۂvtFXFlagZbg
         */
        if (isPromptOnExit) {
            prefStore.setValue(NetJFWatcherAdvisor.PROMPT_ON_EXIT_PREFERENCE, false);
            NetJFWatcherPlugin.getDefault().savePluginPreferences();
        } else {
            prefStore.setValue(NetJFWatcherAdvisor.PROMPT_ON_EXIT_PREFERENCE, true);
            NetJFWatcherPlugin.getDefault().savePluginPreferences();
        }

        return super.performOk();
    }
}
