/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger.list;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.common.view.TableListViewColor;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderNetworkCamera;
import netjfwatcher.engine.model.action.ActionBuilderNodeList;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderSnmp;
import netjfwatcher.engine.model.action.EngineStatus;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionExportAlarmInfo;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionOpenEditorPartPersonalNodeAlarm;
import netjfwatcher.engine.model.action.ActionBuilderNetworkCamera.ActionNetworkCamera;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionShowNodeView;
import netjfwatcher.engine.model.action.ActionBuilderSnmp.ActionShowNodeSnmpView;
import netjfwatcher.engine.model.action.ActionBuilderSnmp.ActionSnmpPrint;
import netjfwatcher.engine.model.action.ActionBuilderSnmp.ActionSnmpStatisticsSet;
import netjfwatcher.engine.nodecontrol.NodeKind;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.AlarmViewFilter;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;
import netjfwatcher.engine.view.editorpart.ping.NodePingMenu;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * m[hXge[u\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeListTableView extends AbstractTableView {
	/** m[ho^\Text */
	protected static final int COUNT_TEXT_WIDTH = 100;

	/** e[u\\[gɂJ0\[g */
	protected static boolean isCol0Direction = false;

	/** e[u\\[gɂJ1\[g */
	protected static boolean isCol1Direction = true;

	/** e[u\\[gɂJ2\[g */
	protected static boolean isCol2Direction = true;

	/** e[u\\[gɂJ3\[g */
	protected static boolean isCol3Direction = true;

	/** e[u\\[gɂJ4\[g */
	protected static boolean isCol4Direction = true;

	/** e[u\\[gɂJ5\[g */
	protected static boolean isCol5Direction = true;

	/** e[u\\[gɂJ6\[g */
	protected static boolean isCol6Direction = true;

	/* MO */
	private static Logger logger = null;

	/** e[uJImage܂ރJ */
	protected static int[] imageColumn = {
			NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME,
			NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS };

	/** o^m[h\Text */
	protected static Text nodeCountText;

	/** XV{^ */
	protected static Button refreshButton;

	/* m[hXge[uJ */
	private static final float COLUMN0NO = 0.03f;

	private static final float COLUMN1NAME = 0.1f;

	private static final float COLUMN2GROUP = 0.1f;

	private static final float COLUMN3ADDRESS = 0.1f;

	private static final float COLUMN4REGDATE = 0.1f;

	private static final float COLUMN5CHECKDATE = 0.1f;

	private static final float COLUMN6STATUS = 0.4f;

	/** Display */
	protected Display display;

	/** m[hListe[u */
	protected Table table;

	/** m[heLXg\BackGroundFi[ */
	protected Color textBackColor;

	/** TableViewer */
	protected TableViewer viewer;

	/** No. J */
	protected TableColumn col0;

	/** Node J */
	protected TableColumn col1;

	/** Group J */
	protected TableColumn col2;

	/** IP Address J */
	protected TableColumn col3;

	/** Nodeo^ J */
	protected TableColumn col4;

	/** Node`FbN J */
	protected TableColumn col5;

	/** NodeXe[^X J */
	protected TableColumn col6;

	/**
	 * o^m[h̊Ďm[hIP AddressKeyƂ ێMapŁAIm[h̊Ď擾E\Ɏgp
	 */
	protected HashMap<String, NodeInformation> nodeInfoIPAddressMap = new HashMap<String, NodeInformation>();

	/** 摜肷邽߂PluginResource bundle */
	protected final Bundle bundle = NetJFWatcherPlugin.getInstance()
			.getBundle();

	/** m[hSNMPv񃁃j[ */
	protected NodeSnmpStatisticsMenu nodeSnmpStatisticsMenu = new NodeSnmpStatisticsMenu();

	/** m[hPingĎj[ */
	protected NodePingMenu nodePingMenu = new NodePingMenu();

	/** m[hXgANV */
	protected NodeListAction nodeListAction = new NodeListAction();

	/** Alarm֘AANV */
	protected ActionBuilderAlarmList alarmAction = new ActionBuilderAlarmList();

	/** m[h̃Ot`֘AANV */
	protected ActionBuilderChart nodeChart = new ActionBuilderChart();

	/** m[hSNMP֘ÃANV */
	protected ActionBuilderSnmp snmpAction = new ActionBuilderSnmp();

	/** m[hANV */
	protected ActionBuilderNodeOperation actionBuilderNodeOperation = new ActionBuilderNodeOperation();

    /** Network Camera m[h֘ÃANV */
	protected ActionBuilderNetworkCamera networkCameraAction = new ActionBuilderNetworkCamera();
    
	/** EditorPartANV */
	protected ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();

	/** Xe[^XC}l[W */
	protected SubStatusLineManager statusLineManager;

	/** m[hXge[uőIꂽIP Address */
	protected String selectIPAddress;

	/** G[Image */
	protected Image errorImage;

	/** xImage */
	protected Image warningImage;

	/** Image */
	protected Image infoImage;

	/** G[Imaget@C */
	protected String errorImageFile = "icons/alarm_level_.gif";

	/** xImaget@C */
	protected String warningImageFile = "icons/alarm_level_warning.gif";

	/** Imaget@C */
	protected String infoImageFile = "icons/alarm_level_info.gif";

	/** zFColor` */
	protected static Color whiteColor = new Color(null, 255, 255, 255);

	/**
	 * m[hIcon ImageIcon image filekeyƂĕێ (Icon imageQdɐ邱Ɩh~ƂƂɁA
	 * finalize()ImagejꍇɎgp)
	 */
	protected HashMap<String, Image> nodeIconImageMap = new HashMap<String, Image>();

	/**
	 * m[hXge[u\ViewNXCX^X ܂B
	 */
	public NodeListTableView() {
		logger = Logger.getLogger(this.getClass().getName());

		/* TextwiFZbg */
		textBackColor = whiteColor;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void setFocus() {
		if (EngineStatus.getInstance().isEngine()) {
			setNodeListView(true);
        }
	}

	/**
	 * e[uViewi\`̌ځjԂ܂B
	 * 
	 * @return viewer TableViewer
	 */
	public TableViewer getViewer() {
		return viewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* Table */
		createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		/* ContentProviderZbg */
		viewer.setContentProvider(new NodeListTableViewContentProvider());

		/* xEtHgȂǂZbg */
		viewer.setLabelProvider(new NodeListTableViewLabelProvider());

		/* Image */
		createImage();

		/* ContextMenuZbg */
		createContextMenu();

		/* ToolBarZbg */
		setToolBarActions();

		/* m[hXg擾 */
		setNodeListView(false);

		/* Xe[^XCZbg */
		setStatusLine();

		/*
		 * TableōsNbNꂽꍇ̃Xi[Zbg
		 */
		table.addSelectionListener(new TableColumnControlTableListener(table,
				NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS));
	}

	/**
	 * m[hXgł̃bZ[W\JImage𐶐܂B
	 * 
	 */
	protected void createImage() {
		URL url = null;

		try {
			url = bundle.getEntry(errorImageFile);

			if (url == null) {
				/* Icon\[Xt@CȂꍇMO̎ */
				logger.severe("Not found icon file : " + errorImageFile);
			} else {
				errorImage = new Image(display, url.openStream());
			}

			url = bundle.getEntry(warningImageFile);

			if (url == null) {
				/* Icon\[Xt@CȂꍇMO̎ */
				logger.severe("Not found icon file : " + errorImageFile);
			} else {
				warningImage = new Image(display, url.openStream());
			}

			url = bundle.getEntry(infoImageFile);

			if (url == null) {
				/* Icon\[Xt@CȂꍇMO̎ */
				logger.severe("Not found icon file : " + errorImageFile);
			} else {
				/* m[hIconC[W */
				infoImage = new Image(display, url.openStream());
			}
		} catch (IOException e) {
			logger.warning("Abort create image " + e.getMessage() + " for "
					+ errorImageFile);
			e.printStackTrace();
		}
	}

	/**
	 * J0iNode No.j̕Ԃ܂B
	 * 
	 * @return J
	 */
	protected int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0NO);
	}

	/**
	 * J1iNode Namej̕Ԃ܂B
	 * 
	 * @return J
	 */
	protected int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1NAME);
	}

	/**
	 * J2iGroupj̕Ԃ܂B
	 * 
	 * @return J
	 */
	protected int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2GROUP);
	}

	/**
	 * J3iIP Addressj̕Ԃ܂B
	 * 
	 * @return J
	 */
	protected int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3ADDRESS);
	}

	/**
	 * J4iNodeo^j̕Ԃ܂B
	 * 
	 * @return J
	 */
	protected int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4REGDATE);
	}

	/**
	 * J5iNode`FbNj̕Ԃ܂B
	 * 
	 * @return J5iNode`FbNj̕
	 */
	protected int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN5CHECKDATE);
	}

	/**
	 * J6iNodeXe[^Xj̕Ԃ܂B
	 * 
	 * @return J6iNodeXe[^Xj̕
	 */
	protected int computeCol6Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN6STATUS);
	}

	/**
	 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	protected void createTable(Composite parent) {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);

		int snmpPort = SystemResourceConfig.getInstance()
				.getResourceFileParse().getResourceInfo().getSnmpPort();
		statusLineManager.setMessage("Snmp Port=" + snmpPort);

		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		parent.setLayout(gridLayout);

		Composite operationContainer = new Composite(parent, SWT.NONE);
		operationContainer.setLayout(new RowLayout(SWT.HORIZONTAL));

		GridData data = new GridData();
		data.horizontalAlignment = GridData.FILL;
		data.grabExcessHorizontalSpace = true;
		operationContainer.setLayoutData(data);

		Label nodeCountLabel = new Label(operationContainer, SWT.NONE);
		nodeCountLabel.setText("Node Count");

		nodeCountText = new Text(operationContainer, SWT.BORDER | SWT.RIGHT
				| SWT.READ_ONLY);
		nodeCountText.setLayoutData(new RowData(COUNT_TEXT_WIDTH, -1));
		nodeCountText.setEditable(false);
		nodeCountText.setEnabled(false);
		nodeCountText.setBackground(textBackColor);
		refreshButton = new Button(operationContainer, SWT.NONE);
		refreshButton.setText("Refresh");

		GridData data2 = new GridData();
		data2.horizontalAlignment = GridData.FILL;
		data2.verticalAlignment = GridData.FILL;

		data2.grabExcessHorizontalSpace = true;
		data2.grabExcessVerticalSpace = true;

		table = new Table(parent, SWT.MULTI | SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		table.setLayoutData(data2);

		/* Node No. */
		col0 = new TableColumn(table, SWT.CENTER);
		col0
				.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NO]);
		col0.setWidth(computeCol0Width());

		/* Node */
		col1 = new TableColumn(table, SWT.CENTER);
		col1
				.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME]);
		col1.setWidth(computeCol1Width());

		/* Group */
		col2 = new TableColumn(table, SWT.CENTER);
		col2
				.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_GROUP]);
		col2.setWidth(computeCol2Width());

		/* IP Address */
		col3 = new TableColumn(table, SWT.CENTER);
		col3
				.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_IPADDRESS]);
		col3.setWidth(computeCol3Width());

		/* Nodeo^ */
		col4 = new TableColumn(table, SWT.CENTER);
		col4
				.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODE_REGISTER_DATE]);
		col4.setWidth(computeCol4Width());

		/* Node`FbN */
		col5 = new TableColumn(table, SWT.CENTER);
		col5
				.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODE_LAST_CHECK_DATE]);
		col5.setWidth(computeCol5Width());

		/* NodeXe[^X */
		col6 = new TableColumn(table, SWT.CENTER);
		col6
				.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS]);
		col6.setWidth(computeCol6Width());

		/**
		 * e[uړꍇ͂TCYꍇ̃Xi[łB
		 * 
		 */
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
				.addControlListener(new ControlListener() {
					public void controlMoved(ControlEvent event) {
					}

					public void controlResized(ControlEvent event) {

						setResizedTableColumnWidth();
					}
				});

		col0.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol0Direction = sortIntegerTable(table, 0, isCol0Direction,
						imageColumn);
			}
		});

		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol1Direction = sortTable(table, 1, isCol1Direction,
						imageColumn);
			}
		});
		col2.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol2Direction = sortTable(table, 2, isCol2Direction,
						imageColumn);
			}
		});

		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol3Direction = sortTable(table, 3, isCol3Direction,
						imageColumn);
			}
		});

		col4.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol4Direction = sortTable(table, 4, isCol4Direction,
						imageColumn);
			}
		});

		col5.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol5Direction = sortTable(table, 5, isCol5Direction,
						imageColumn);
			}
		});
		col6.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[g6ێ */
				isCol6Direction = sortTable(table, 6, isCol6Direction,
						imageColumn);
			}
		});

		/*
		 * XV{^Xi[
		 */
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				refreshButton.setEnabled(false);
				setNodeListView(true);
				refreshButton.setEnabled(true);
				setStatusLine();
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	/*
	 * X[p[NX̃e[uColumn Clickɂ\[g\bh
	 * I[o[ChāAe[uRowForegroundABackground J[yImage\[gɂĂێ܂B
	 * 
	 * @see rctf.rssr.common.view.AbstractTableView#setTableItem
	 *      (org.eclipse.swt.widgets.Table, org.eclipse.swt.widgets. TableItem,
	 *      java.lang.String[])
	 */
	protected TableItem setTableItem(final Table paraTable, TableItem item,
			final String[] strs) {

		Object obj0 = item.getForeground();
		Object obj1 = item.getBackground();
		Object obj = item
				.getForeground(NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS);
		Image image1 = item
				.getImage(NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME);
		Image image2 = item
				.getImage(NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS);

		item.dispose();
		item = new TableItem(paraTable, SWT.NONE);

		item.setText(strs);
		item.setData(strs);

		item.setForeground((Color) obj0);
		item.setBackground((Color) obj1);
		item.setForeground(
				NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS,
				(Color) obj);
		item.setImage(NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME,
				image1);
		item.setImage(NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS,
				image2);

		return item;
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[W𐶐 */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/*
		 * ReLXgj[𐶐Zbg
		 */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * j[o[ preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* m[hList\j[ǉ */
		manager.add(nodeListAction.getActionShowNodeListTable());

		/* m[hImport(m[hꊇo^)j[ǉ */
		manager.add(nodeListAction.getActionImportNodeListFile());

		/* m[hExportj[ǉ */
		manager.add(nodeListAction.getActionExportNodeListFile());

		/* m[h상j[ǉ */
		// manager.add(nodeListAction.getActionNodeOperation());
		/* m[hǉEҏWE폜j[ǉ */
		manager.add(actionBuilderNodeOperation.getActionNodeOperation());

		// nodeListAction.setSelectIPAddress(null);

		/*
		 * m[hListe[uI񒊏o
		 */
		if ((table.getSelectionIndex() >= 0) && (table.getSelection() != null)) {
			TableItem[] item = table.getSelection();

			// for (int i = 0; i < item.length; i++) {
			String[] nodeInfo = (String[]) item[0].getData();
			selectIPAddress = nodeInfo[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_IPADDRESS];

			NodeInformation targetNodeInfo = (NodeInformation) nodeInfoIPAddressMap
					.get(selectIPAddress);

			((ActionNodeOperation) actionBuilderNodeOperation
					.getActionNodeOperation()).setNodeInfo(targetNodeInfo);

			/* m[h\\j[ǉ */
			((ActionShowNodeView) actionBuilderNodeOperation
					.getActionShowNodeView()).setNodeInfo(targetNodeInfo);
			manager.add(actionBuilderNodeOperation.getActionShowNodeView());

			/* m[hSNMP\j[ǉ */
			((ActionShowNodeSnmpView) snmpAction.getActionSnmpInfo())
					.setNodeInfo(targetNodeInfo);
			manager.add(snmpAction.getActionSnmpInfo());

			/* m[hAlarm\j[ǉ */
			((ActionOpenEditorPartPersonalNodeAlarm) alarmAction
					.getActionOpenEditorPartPersonalNodeAlarm())
					.setNodeInfo(targetNodeInfo);
			manager.add(alarmAction.getActionOpenEditorPartPersonalNodeAlarm());

			/* m[hAlarm ExportANV */
			((ActionExportAlarmInfo) alarmAction.getActionExportAlarm())
					.setIpAddress(selectIPAddress);
			manager.add(alarmAction.getActionExportAlarm());

			/* m[hPingj[ǉ */
			nodePingMenu.createPingMenu(manager, targetNodeInfo, false);

			/* m[hSnmpv\j[ǉ */
			nodeSnmpStatisticsMenu.createSnmpStatisticsMenu(manager,
					targetNodeInfo, false);

			/*
			 * m[hSnmpvZbgj[j[}l[W ɒǉ
			 */
			((ActionSnmpStatisticsSet) snmpAction.getActionSnmpStatisticsSet())
					.setNodeInfo(targetNodeInfo);
			manager.add(snmpAction.getActionSnmpStatisticsSet());

			if(targetNodeInfo.getNodeKind().equals(NodeKind.PRINTER)) {
            	/* Printerm[hSNMP\j[ǉ */
                ((ActionSnmpPrint) snmpAction.getActionPrintSnmp())
                .setNodeInfo(targetNodeInfo);
                manager.add(snmpAction.getActionPrintSnmp());
            }
            if(targetNodeInfo.getNodeKind().equals(NodeKind.CAMERA)) {
            	/* Network Cameraj[ǉ */
                ((ActionNetworkCamera) networkCameraAction.getActionNetworkCamera())
                .setNodeInfo(targetNodeInfo);
                manager.add(networkCameraAction.getActionNetworkCamera());
            }
		}

		/* Sm[hAlarm\ */
		manager.add(alarmAction.getActionShowAllNodeAlarmListTable());

		/* Snmpv\ */
		manager.add(snmpAction.getActionSnmpStatistics());
	}

	/**
	 * ToolBarANV̏s܂B
	 * 
	 */
	private void setToolBarActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();
		toolBarManager.add(nodeListAction.getActionShowNodeListTable());
		toolBarManager.add(nodeListAction.getActionImportNodeListFile());
		toolBarManager.add(nodeListAction.getActionExportNodeListFile());
		toolBarManager.add(alarmAction.getActionShowAllNodeAlarmListTable());

		/* Alarm ExportANV */
		((ActionExportAlarmInfo) alarmAction.getActionExportAlarm())
				.setIpAddress(DBTableAlarm.ALL_NODE);
		toolBarManager.add(alarmAction.getActionExportAlarm());

		/* Editor part closeANV */
		toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
	}

	/**
	 * Node liste[u\̍XVs܂B
	 * 
	 * @param isNodeList
	 *            m[hĎ擾邩ۂtO
	 */
	protected void setNodeListView(boolean isNodeList) {
		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		nodeInfoIPAddressMap.clear();

		ArrayList nodeList = null;

		if (isNodeList) {
			nodeList = getNodeList();
		}

		if (nodeList != null) {
			nodeCountText.setText(Integer.toString(nodeList.size()));
		} else {
			nodeCountText.setText("0");

			return;
		}

		/* m[hĎ񃊃Xge[uZbg */
		for (int i = 0; i < nodeList.size(); i++) {
			NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);
			nodeInfoIPAddressMap.put(nodeInfo.getIpaddress(), nodeInfo);

			String[] tableCellArray = new String[NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS.length];

			tableCellArray[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NO] = Integer
					.toString(i + 1);
			tableCellArray[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME] = nodeInfo
					.getNodename();
			tableCellArray[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_GROUP] = nodeInfo
					.getGroup();
			tableCellArray[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_IPADDRESS] = nodeInfo
					.getIpaddress();
			tableCellArray[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODE_REGISTER_DATE] = nodeInfo
					.getRegisterDate();
			if (nodeInfo.getLastCheck() == null
					|| nodeInfo.getLastCheck().equals("")) {
				tableCellArray[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODE_LAST_CHECK_DATE] = "";
			} else {
				tableCellArray[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODE_LAST_CHECK_DATE] = nodeInfo
						.getLastCheck();
			}
			if ((nodeInfo.getAlarmDate() != null)
					&& !nodeInfo.getAlarmDate().equals("")) {
				tableCellArray[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS] = nodeInfo
						.getAlarmDate()
						+ " : " + nodeInfo.getAlarmMessage();
			} else {
				tableCellArray[NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS] = "";
			}

			TableItem item = new TableItem(table, SWT.NONE);
			item.setText(tableCellArray);
			item.setData(tableCellArray);

			/* m[hIcon Imagem[hɕt */
			Image nodeIconImage = createNodeIconImage(nodeInfo.getNodeKind());
			item.setImage(
					NodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME,
					nodeIconImage);

			/* A[xImageXe[^Xɕt */
			if (nodeInfo.getAlarmLevel() != null) {
				if (nodeInfo.getAlarmLevel()
						.equals(AlarmViewFilter.ERROR_LEVEL)) {
					item.setForeground(TableListViewColor.getInstance()
							.getAlarmErrorLevelColor());
					item
							.setImage(
									NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS,
									errorImage);
				} else if (nodeInfo.getAlarmLevel().equals(
						AlarmViewFilter.WARNING_LEVEL)) {
					item
							.setImage(
									NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS,
									warningImage);
				} else if (nodeInfo.getAlarmLevel().equals(
						AlarmViewFilter.INFO_LEVEL)) {
					item
							.setImage(
									NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS,
									infoImage);
				}
			}

			/*
			 * m[hXgColor݂ɃZbg
			 */
			if ((i % 2) == 0) {
				item.setBackground(TableListViewColor.getInstance()
						.getNodeListOddBackgroundColor());
				item.setForeground(TableListViewColor.getInstance()
						.getNodeListOddForgroundColor());
			} else {
				item.setBackground(TableListViewColor.getInstance()
						.getNodeListEvenBackgroundColor());
				item.setForeground(TableListViewColor.getInstance()
						.getNodeListEvenForgroundColor());
			}

			/* Xe[^XColumnԐF\ */
			item.setForeground(
					NodeListTableViewLabelProvider.NODE_LIST_COLUMN_STATUS,
					TableListViewColor.getInstance()
							.getNodeListStatusForgroundColor());
		}
	}

	/*
	 * m[hʂm[hIcon image擾ĕԂ܂B
	 * 
	 * @param nodeKind m[h @return nodeIconImage m[hIcon image
	 */
	protected Image createNodeIconImage(String nodeKind) {
		/*
		 * m[hʂɑΉm[hIconC[Wt@C LqXMLt@CList𐶐Am[hIcon C[Wt@C擾
		 */
		String node16IconFileName = MediaResource.getInstance()
				.getNodeIcon16FileName(nodeKind);
		Image nodeIconImage = null;

		if (!nodeIconImageMap.containsKey(node16IconFileName)) {
			URL url = null;
			url = bundle.getEntry(node16IconFileName);

			if (url == null) {
				/* Icon\[Xt@CȂꍇMO̎ */
				logger.severe("Npt found icon file : " + node16IconFileName);
			} else {
				try {
					/* m[hIconC[W */
					nodeIconImage = new Image(display, url.openStream());

					/* m[hIconC[WMapɊi[ */
					nodeIconImageMap.put(node16IconFileName, nodeIconImage);
				} catch (IOException e) {
					logger.warning("Abort create image " + e.getMessage()
							+ " for " + node16IconFileName);
					e.printStackTrace();
				}
			}
		} else {
			nodeIconImage = (Image) nodeIconImageMap.get(node16IconFileName);
		}

		return nodeIconImage;
	}

	/**
	 * f[^x[XNode listǂݍŕԂ܂B
	 * 
	 * @return nodeList Node list
	 */
	public ArrayList getNodeList() {
		DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
				.getInstance();
		ArrayList nodeList = null;

		try {
			nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
		} catch (SQLException e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e1
					.getMessage());
			logger.warning("Node List import error " + e1.getMessage());
			shell.dispose();

			return nodeList;
		} catch (Exception e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e1
					.getMessage());
			logger.warning("Node List import error " + e1.getMessage());
			shell.dispose();

			return nodeList;
		} finally {
			nodeRegisterDBTable = null;
		}

		return nodeList;
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
		statusLineManager.setMessage("Node List View Node count="
				+ nodeInfoIPAddressMap.size());
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* A[xɑΉĐIcon imagej */
		if (errorImage != null && !errorImage.isDisposed()) {
			errorImage.dispose();
		}

		if (warningImage != null && !warningImage.isDisposed()) {
			warningImage.dispose();
		}

		if (infoImage != null && !infoImage.isDisposed()) {
			infoImage.dispose();
		}

		/* m[hIcon imagej */
		Map list = nodeIconImageMap;
		Iterator it = null;

		for (it = list.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			Image nodeIconImage = (Image) list.get(key);

			if (nodeIconImage != null) {
				nodeIconImage.dispose();
			}
		}

		if (table != null) {
			table.dispose();
		}
	}

	protected void setResizedTableColumnWidth() {
		/*
		 * e[u\Ԃł΃e[uJZbg
		 */
		if (getSite().getPage().isPartVisible(getSite().getPart())
				&& getSite().getShell() != null) {
			if (getSite().getShell().getSize() != null) {
				// col0.setWidth(computeCol0Width());
			}
		}
	}

	/**
	 * m[hListe[ũANV܂B
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected final class NodeListAction extends ActionBuilderNodeList {
		/**
		 * X[p[NX̃\bhI[o[ChāAm[hList e[u̕\XVLq܂B
		 */
		protected void refreshAlarmTable() {
			/* m[hListe[u\XV */
			setNodeListView(true);
		}
	}
}
