/*
 * Created on 2004/04/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.control;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.CommandInfo;


/**
 * [UC^tF[X̗viR}hANVjɑΉ
 * <A HREF="{@docRoot}/suncertify/command/concrete/package-summary.html">
 * R}hۃNX</A>̃CX^X擾ÃCX^X
 * \bhɂR}hϏNXłB<BR>
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ControllerCommand {
    /* MO */
    private static Logger logger;

    /*
     * R}hIDɑΉR}hsVOgNX
     * CX^X𐶐܂B
     *
     */
    private ControllerCommand() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * R}hIDɑΉR}hsVOgNX
     * CX^XԂ܂B
     *
     * @return VOgNXCX^X
     */
    public static ControllerCommand getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * R}hIDɑΉ鏈CX^X擾s܂B
     *
     * @param id R}hID
     * @param com R}h
     * @param ois ObjectInputStream
     * @param oos ObjectOutputStream
     * @throws CommandException R}hsɎsꍇ
     */
    public synchronized void execute(
        String id, CommandInfo com, ObjectInputStream ois,
        ObjectOutputStream oos) throws CommandException {
        logger.info(id + " Command execute");

        /* R}hCX^X擾āAsiϏj */
        ICommand commandInstance = this.getCommandInstance(id);
        commandInstance.execute(com, ois, oos);
    }

    /**
     * R}hIDɑΉR}hCX^XԂ܂B
     *
     * @param id R}hID
     * @return commandInstance R}hCX^X
     * @throws CommandException R}hIDɑΉCX^X
     * 擾łȂꍇ
     */
    private synchronized ICommand getCommandInstance(final String id)
        throws CommandException {
        CommandMappingTableController commandMappingTable =
            CommandMappingTableController.getInstance();
        ICommand commandInstance = commandMappingTable.getCommandInstance(id);

        if (commandInstance == null) {
            logger.warning("Abort Command@Instance : " + id);
            throw new CommandException("Abort Command@Instance : " + id);
        }

        // assert commandInstance != null : "Abort Command@Instance : " + id;
        return commandInstance;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ControllerCommand RESOURCE = new ControllerCommand();
    }
}
