/*
 * Created on 2003/08/23
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.server.protocol.ping.PingExcecEngine;
import netjfwatcher.engine.socket.info.ResourceInfo;

/**
 * A[bZ[W\[XǂݍŃA[L[Put \bhNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AlarmMessageMake {
	/*
	 * A[bZ[W\[XǂݍŃA[L[Put \bhVOgNXCX^X𐶐܂B
	 */
	private AlarmMessageMake() {
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static AlarmMessageMake getInstance() {
		return SingletonAlarmPut.ALARMPUT;
	}

	/**
	 * A[eXg̏ꍇ̃A[bZ[WA[L[Put ܂B
	 * 
	 * @param ipAddress
	 *            m[hIPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setEorrorTest(final String ipAddress,
			final String message) {
		AlarmCodeInformation alarmInfo = new AlarmCodeInformation();
		alarmInfo.setId("Test ID");
		alarmInfo.setLevel("ERROR");
		alarmInfo.setCode("Test Code");
		alarmInfo.setMessage(message);

		AlarmPut.getInstance().putAlarm(ipAddress, alarmInfo,
				alarmInfo.getMessage());
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipAddress,
				alarmInfo);
	}

	/**
	 * UnknownHost̃A[bZ[WA[L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 */
	public synchronized void setEorrorUnknownHostException(
			final String ipaddress) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.UNKNOWN_HOST_ID_ERROR);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage());
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * C^tF[XԂωꍇ̃A[Zbg܂B
	 * 
	 * @param ipaddress
	 *            IPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setCahngeInterfaceStatus(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.CHANGE_INTERFACE_STATUS_WARNING);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + message);
	}

	/**
	 * PrinterԂωꍇ̃A[Zbg܂B
	 * 
	 * @param ipaddress
	 *            IPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setCahngePrintStatus(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.CHANGE_PRINT_STATUS_WARNING);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + message);
	}
	
	/**
	 * C^tF[XύXꂽꍇ̃A[Zbg܂B
	 * 
	 * @param ipaddress
	 *            IPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setCahngeInterface(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.CHANGE_INTERFACE_WARNING);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + message);
	}

	/**
	 * PrinterC^tF[XύXꂽꍇ̃A[Zbg܂B
	 * 
	 * @param ipaddress
	 *            IPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setCahngePrinterInterface(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.CHANGE_PRINTER_INTERFACE_WARNING);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + message);
	}
	
	/**
	 * m[hύXꂽꍇ̃A[bZ[WA[L[ Put܂B
	 * 
	 * @param ipaddress
	 *            IPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setCahngeNode(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.CHANGE_NODE_WARNING);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + message);
	}

	/**
	 * m[h̃VXe񂪕ωꍇ̃A[bZ[WA[ L[Put܂B
	 * 
	 * @param ipaddress
	 *            IPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setCahngeNodeSystemInfo(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.CHANGE_NODE_SYSTEM_INFO_WARNING);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + message);
	}

	/**
	 * Ping Timeout̃A[bZ[WA[L[Put܂B
	 * 
	 * @param ipaddress
	 *            Ym[hIPAhX
	 */
	public synchronized void setErrorPingTimeout(final String ipaddress) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.PING_TIMEOUT);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage());
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * Ping Destination host unreachable.̃A[bZ[WA[ L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 */
	public synchronized void setEorrorPingDestinationHostUnreachable(
			final String ipaddress) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.PING_HOST_UNREACHABLE);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage());
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMP Timeout̃A[bZ[WA[L[Put܂B
	 * 
	 * @param ipAddress
	 *            m[hIPAhX
	 * @param oid
	 *            ̎OID
	 * @param socketTimeout
	 *            Socket^CAEgl
	 */
	public synchronized void setErrorSNMPTimeout(final String ipAddress,
			final String oid, final int socketTimeout) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SNMP_GET_TIMEOUT);
		AlarmPut.getInstance().putAlarm(
				ipAddress,
				alarmInfo,
				alarmInfo.getMessage() + " OID=" + oid + " Socket Tmeout="
						+ socketTimeout + "ms");
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipAddress,
				alarmInfo);
	}

	/**
	 * SNMP NoRoute to host̏ꍇ̃A[bZ[WA[L[ Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param oid
	 *            ̎OID
	 */
	public synchronized void setErrorSNMPNoRouteToHost(final String ipaddress,
			final String oid) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SNMP_NO_ROUTE_TOHOST);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + " : OID=" + oid);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMP IOExceptioñA[bZ[WA[L[ Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param oid
	 *            ̎OID
	 * @param msg
	 *            A[bZ[W
	 */
	public synchronized void setErrorSNMPIOException(final String ipaddress,
			final String oid, final String msg) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SNMP_IOEXCEPTION);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + " " + msg + " : OID=" + oid);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMPG[Xe[^Xُ̏ꍇ̃A[bZ[WA[ L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param msg
	 *            A[bZ[W
	 */
	public synchronized void setErrorSNMPErrorStatus(final String ipaddress,
			final String msg) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SNMP_RECEIVE_ERROR_STATUS_WARNING);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + " " + msg);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMP MIB̎掸s̃A[bZ[WA[L[Put ܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param oid
	 *            ̎OID
	 */
	public synchronized void setErrorSNMPAbortMIB(final String ipaddress,
			final String oid) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.ABORT_GET_SNMP_MIB_ERROR);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + " : OID=" + oid);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMP V3|[gOIDM̃A[bZ[WA[L[ Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param oid
	 *            ̎OID
	 * @param oidDescription
	 *            OID Description
	 * @param countValue
	 *            gCJEg
	 */
	public synchronized void setErrorSNMPV3ReportOID(final String ipaddress,
			final String oid, final String oidDescription,
			final String countValue) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SNMP_V3_RECEIVE_REPORT_OID_WARNING);
		AlarmPut.getInstance().putAlarm(
				ipaddress,
				alarmInfo,
				alarmInfo.getMessage() + "=" + oid + "(" + oidDescription
						+ ") Count=" + countValue);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMPNGXgʎqƎMʎqA}b`̏ꍇ̃A[bZ[W A[L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param msg
	 *            A[bZ[W
	 */
	public synchronized void setErrorSNMPUnmuchRequestID(
			final String ipaddress, final String msg) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SNMP_UNMUCH_REQUEST_ID_WARNING);
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo,
				alarmInfo.getMessage() + " " + msg);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMPNGXgʎqƎMʎqA}b`̏ꍇ̃A[bZ[W A[L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param requestID
	 *            NGXgʎq
	 * @param receiveRequestID
	 *            Mʎq
	 * @param msg
	 *            A[bZ[W
	 */
	public synchronized void setErrorSNMPUnmuchRequestID(
			final String ipaddress, final int requestID,
			final int receiveRequestID, final String msg) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SNMP_UNMUCH_REQUEST_ID_WARNING);
		AlarmPut.getInstance().putAlarm(
				ipaddress,
				alarmInfo,
				alarmInfo.getMessage() + " request ID=" + requestID
						+ " receive ID=" + receiveRequestID + " " + msg);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMP V3 msgIDҒlƃA}b`̏ꍇ̃A[bZ[WA[ L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param requestMsgID
	 *            NGXgmsgID
	 * @param receiveMsgID
	 *            MMsgID
	 * @param msg
	 *            A[bZ[W
	 */
	public synchronized void setErrorSNMPV3UnmuchRequestMsgID(
			final String ipaddress, final int requestMsgID,
			final String receiveMsgID, final String msg) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SNMP_V3_UNMUCH_REQUEST_MSG_ID_WARNING);
		AlarmPut.getInstance().putAlarm(
				ipaddress,
				alarmInfo,
				alarmInfo.getMessage() + " request MsgID=" + requestMsgID
						+ " receive MsgID=" + receiveMsgID + " " + msg);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * PingԂ臒lI[o[ꍇ̃A[bZ[W A[L[Put܂B
	 * 
	 * @param ipaddress
	 *            Ym[hIPAhX
	 * @param difftime
	 *            Ping
	 * @param pingThreshold
	 *            Ping臒l
	 */
	public synchronized void setPingResOver(final String ipaddress,
			final long difftime, final int pingThreshold) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.PING_OVER_AT_THRESHHOLD);
		String msg = alarmInfo.getMessage();
		String message = msg + " Threshold=" + pingThreshold
				+ PingExcecEngine.PING_RESPONSE_TIME_UNIT_MS + " Value="
				+ difftime + PingExcecEngine.PING_RESPONSE_TIME_UNIT_MS;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, message);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * v臒lI[o[ꍇ̃A[bZ[WA[ L[Put܂B
	 * 
	 * @param ipaddress
	 *            ^[QbgIPAhX
	 * @param oid
	 *            OID
	 * @param mibName
	 *            MIB
	 * @param type
	 *            vĎώZ\
	 * @param data
	 *            ̎擝vf[^
	 * @param threshold
	 *            臒lݒl
	 */
	public synchronized void setStatisticsMIBOver(final String ipaddress,
			final String oid, final String mibName, final String type,
			final double data, final double threshold) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.STATISTICS_MIB_OVER_AT_THRESHHOLD);
		String msg = alarmInfo.getMessage();
		String message = msg + " OID=" + oid + "(" + mibName + ") Threshold="
				+ threshold + " " + type + " value=" + data;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, message);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMPv臒lI[o[Ԃ畜ꍇ̃A[ bZ[WA[L[Put܂B
	 * 
	 * @param ipaddress
	 *            IPAhX
	 * @param oid
	 *            OID
	 * @param mibName
	 *            MIB
	 * @param type
	 *            MIB^Cv
	 * @param data
	 *            MIBl
	 * @param threshold
	 *            MIB臒l
	 */
	public synchronized void setRecoveryStatisticsMIBOver(
			final String ipaddress, final String oid, final String mibName,
			final String type, final double data, final double threshold) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_STATISTICS_MIB_OVER_AT_THRESHHOLD);
		String msg = alarmInfo.getMessage();
		String message = msg + " OID=" + oid + "(" + mibName + ") Threshold="
				+ threshold + " " + type + " value=" + data;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, message);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * Ping臒lI[o[畜ꍇ̃A[bZ[W A[L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param diffTime
	 *            Ping
	 * @param pingThreshold
	 *            PingĎ臒l
	 */
	public synchronized void setRecoveryPingResOver(final String ipaddress,
			final long diffTime, final int pingThreshold) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_PING_OVER_AT_THRESHHOLD);
		String msg = alarmInfo.getMessage();
		String message = msg + " Threshold=" + pingThreshold
				+ PingExcecEngine.PING_RESPONSE_TIME_UNIT_MS + " Value="
				+ diffTime + PingExcecEngine.PING_RESPONSE_TIME_UNIT_MS;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, message);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * PingTimeout畜ꍇ̃A[bZ[W A[L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 */
	public synchronized void setRecoveryPingTimeout(final String ipaddress) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_PING_TIMEOUT);
		String msg = alarmInfo.getMessage();
		ResourceInfo resourceInfo = SystemResourceConfig.getInstance()
				.getResourceFileParse().getResourceInfo();

		String message = msg + " Timeout Value="
				+ resourceInfo.getPingTimeout() + "ms" + " Retry value="
				+ resourceInfo.getPingRetry();
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, message);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMP Timeout畜ꍇ̃A[bZ[WA[ L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param oid
	 *            ̎OID
	 * @param socketTimeout
	 *            SocketTimeoutl
	 */
	public synchronized void setRecoverySNMPTimeout(final String ipaddress,
			final String oid, final int socketTimeout) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_SNMP_GET_TIMEOUT);
		String msg = alarmInfo.getMessage();
		String message = msg + " OID=" + oid + " Socket Tmeout="
				+ socketTimeout + "ms";
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, message);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMP NoRoute to host畜ꍇ̃A[bZ[W A[L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param oid
	 *            ̎OID
	 */
	public synchronized void setRecoverySNMPNoRouteToHost(
			final String ipaddress, final String oid) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_SNMP_NO_ROUTE_TOHOST);
		String msg = alarmInfo.getMessage();
		String message = msg + " OID=" + oid;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, message);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SNMP IOException畜ꍇ̃A[A[L[ Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param oid
	 *            ̎OID
	 */
	public synchronized void setRecoverySNMPIOException(final String ipaddress,
			final String oid) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_SNMP_IOEXCEPTION);
		String msg = alarmInfo.getMessage();
		String message = msg + " OID=" + oid;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, message);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * TrapM̃A[bZ[WA[L[Put܂B
	 * 
	 * @param ipaddress
	 *            Ym[hIPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setTrapReceive(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SNMP_TRAP_RECEIVE);
		String msg = alarmInfo.getMessage() + " : " + message;

		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * wURLGetăG[ꍇ̃A[A[L[ Put܂B
	 * 
	 * @param ipaddress
	 *            IPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setHTTPGetError(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.HTTP_GET_ERROR);
		String msg = alarmInfo.getMessage() + " : " + message;

		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * HTTPANZXG[畜ꍇ̃A[A[L[ Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setRecoveryHTTPGetError(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_HTTP_GET_ERROR);
		String msg = alarmInfo.getMessage() + " : " + message;

		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * Pop3ĎŃG[oꍇ̃A[A[L[ Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setPop3Error(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.POP3_CHECK_ERROR);
		String msg = alarmInfo.getMessage() + " : " + message;

		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * Pop3ĎG[畜ꍇ̃A[A[L[ Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setRecoveryPop3Error(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_POP3_CHECK_ERROR);
		String msg = alarmInfo.getMessage() + " : " + message;

		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SMTPĎG[õA[A[L[Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setSmtpError(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SMTP_CHECK_ERROR);
		String msg = alarmInfo.getMessage() + " : " + message;

		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * SMTPĎG[畜ꍇ̃A[A[L[ Put܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setRecoverySmtpError(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_SMTP_CHECK_ERROR);
		String msg = alarmInfo.getMessage() + " : " + message;

		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);

		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * A[ɂMailM̃G[A[L[ Put܂B
	 * 
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setMailSendError(final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SEND_MAIL_ERROR);
		String msg = alarmInfo.getMessage() + message;
		AlarmPut.getInstance().putAlarm(AlarmPut.APL_ERROR_MESSAGE, alarmInfo,
				msg);
	}

	/**
	 * A[ɂMailM̃L[I[o[t[ ꍇ̃A[L[Put܂B
	 * 
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setMailQueuOverflow(final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SEND_MAIL_QUEUE_OVERFLOW);
		String msg = alarmInfo.getMessage() + message;
		AlarmPut.getInstance().putAlarm(AlarmPut.APL_ERROR_MESSAGE, alarmInfo,
				msg);
	}

	/**
	 * SNMP V3\ُA[A[L[Put܂B
	 * 
	 * @param message
	 *            A[bZ[W
	 */
	public synchronized void setSnmpConfigError(final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SNMPV3_CONFIG_ERROR);
		String msg = alarmInfo.getMessage() + " (" + message + ")";
		AlarmPut.getInstance().putAlarm(AlarmPut.APL_ERROR_MESSAGE, alarmInfo,
				msg);
	}

	/**
	 * syslog-ngbZ[WMA[L[Put܂B
	 * 
	 * @param message
	 *            syslog-ngbZ[WM
	 */
	public synchronized void setSyslogNG(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.SYSLOG_NG);
		String msg = alarmInfo.getMessage() + " : " + message;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);
	}

	/**
	 * Honey Port XLõA[A[L[Put܂B
	 * 
	 * @param message
	 *            Honey Port XLȍ
	 */
	public synchronized void setHoneyPortScan(final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.HONEY_PORT_SCAN);
		String msg = alarmInfo.getMessage() + " : " + message;
		AlarmPut.getInstance().putAlarm(AlarmPut.HONEY_PORT_SCAN_NODE_MESSAGE, alarmInfo, msg);
	}
	/**
	 * Port XLNG̃A[A[L[Put܂B
	 *
	 * @param message
	 *            Port XLNG̃A[
	 */
	public synchronized void setPortScanError(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.PORT_SCAN_NG);
		String msg = alarmInfo.getMessage() + " : " + message;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);
	}
	/**
	 * Port XLNG畜̃A[A[L[Put܂B
	 * 
	 * @param message
	 *            sPort XLNG畜̏
	 */
	public synchronized void setRecoveryPortScanError(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_PORT_SCAN_NG);
		String msg = alarmInfo.getMessage() + " : " + message;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);
	}
	
	
	
	/**
	 * DatabaseڑG[̃A[A[L[Put܂B
	 *
	 * @param message
	 *            DatabaseڑG[̃A[
	 */
	public synchronized void setDatabaseConnectionError(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.DATABASE_CONNECTION_ERROR);
		String msg = alarmInfo.getMessage() + " : " + message;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}
	/**
	 * DatabaseڑG[畜̃A[A[L[Put܂B
	 * 
	 * @param message
	 *            DatabaseڑG[畜̏
	 */
	public synchronized void setRecoveryDatabaseConnectionError(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_DATABASE_CONNECTION_ERROR);
		String msg = alarmInfo.getMessage() + " : " + message;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * Database SQLG[̃A[A[L[Put܂B
	 *
	 * @param message
	 *            Database SQLG[̃A[
	 */
	public synchronized void setDatabaseSQLError(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.DATABASE_SQL_EXCEPTION_ERROR);
		String msg = alarmInfo.getMessage() + " : " + message;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}
	/**
	 * Database SQLG[畜̃A[A[L[Put܂B
	 * 
	 * @param message
	 *            Database SQLG[畜̏
	 */
	public synchronized void setRecoveryDatabaseSQLError(final String ipaddress,
			final String message) {
		AlarmCodeInformation alarmInfo = AlarmMessageResource
				.getAlertMessage(AlarmMessageResource.RECOVERY_DATABASE_SQL_EXCEPTION_ERROR);
		String msg = alarmInfo.getMessage() + " : " + message;
		AlarmPut.getInstance().putAlarm(ipaddress, alarmInfo, msg);
		AlarmRecovery.getInstance().putAlarmRecoveryInoformation(ipaddress,
				alarmInfo);
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonAlarmPut {
		static final AlarmMessageMake ALARMPUT = new AlarmMessageMake();
	}
}
