/*
 * Created on 2004/09/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.engine.socket.info.InterfaceData;
import netjfwatcher.engine.socket.info.StatisticsMibIfDescriptor;
import netjfwatcher.engine.socket.info.StatisticsMibInfo;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.socket.info.StatisticsMibSetStatus;

/**
 * SNMPvMIBe[u𑀍삷郁\bhNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DBTableStatisticsMIBControl extends DBTableBase {
	/** ̎MIB OIDACX^XA̎A臒le[uPrefix */
	public static final String SNMP_STATIS_CONFIG_TABLE_NAME = "_statis";

	/** CX^XA̎f[^ilje[uPrefix */
	public static final String SNMP_STATIS_MIB_DATA_TABLE = "_statisData";

	/** OIDACX^Xe[uPrefix */
	public static final String SNMP_STATIS_MIB_INSTANCE_TABLE = "_instance";

	/** vMIB̎OID J */
	public static final String STATIS_OID = "statis_oid";

	/** vMIB̎OIDCX^X J */
	public static final String INSTANCE_TOTAL = "instance_total";

	/** vMIB̎ J */
	public static final String PERIOD = "period";

	/** vMIB̎臒l J */
	public static final String THRESHOLD = "threshold";

	/** vMIB̎臒l`FbN^Cv J */
	public static final String THRESHOLD_TYPE = "thresholdtype";

	/** vMIB̎OIDCX^X J */
	public static final String INSTANCE_NAME = "instance_name";

	/** vMIB̎ J */
	public static final String CURDATE = AbstractDataAccessObject.CUR_DATE;

	/* MO */
	private static Logger logger = null;

	/* SNMPv̎tH[}bg */
	private final DateFormat simpleDateformat = new SimpleDateFormat(
			"yyyy-MM-dd HH:mm:ss");

	/**
	 * SNMPve[uNXCX^X𐶐܂B
	 * 
	 */
	private DBTableStatisticsMIBControl() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * SNMPve[uVOgNXCX^X 𐶐܂B
	 * 
	 * @return SNMPve[uVOgNXCX^X
	 */
	public static DBTableStatisticsMIBControl getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * SNMPvMIBe[u𐶐܂B i̎MIB OIDACX^XA̎A臒li[j
	 * 
	 * @param targetIpAddress
	 *            m[hIPAhX
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized void createStatisticsMibConfigTable(
			String targetIpAddress) throws DatabaseConnectionException,
			SQLException {
		String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
		ipaddress = ipaddress.replace('-', '_');

		DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			AbstractDataAccessObject dataaccess = DatabaseAccessControlKind
					.getInstance().getDataAccessObject();

			// ̃e[u폜
			this.deleteTable(databaseAccess, ipaddress
					+ SNMP_STATIS_CONFIG_TABLE_NAME);

			// f[^x[XEe[u쐬
			databaseAccess.executeUpdate("CREATE TABLE " + ipaddress
					+ SNMP_STATIS_CONFIG_TABLE_NAME
					+ dataaccess.getItemSnmpStatisticsTableSQL());

			DBTableManagement tableManagement = new DBTableManagement();
			tableManagement
					.put(targetIpAddress, ipaddress
							+ SNMP_STATIS_CONFIG_TABLE_NAME,
							DBTableManagement.LIMIT_NO);
		} finally {
			if (databaseAccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						databaseAccess);
			}
		}
	}

	/**
	 * SNMP vMIBi[e[uiCX^XA̎f[^iljj ܂B
	 * OIDCX^XɂẮAv̎OIDwł̉CX^X ̃Jǉ܂B ie[usuffix_statisDataj
	 * 
	 * @param targetIpAddress
	 *            m[hIPAhX
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized void createStatisticsMibDataTable(
			final String targetIpAddress) throws DatabaseConnectionException,
			SQLException {
		String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
		ipaddress = ipaddress.replace('-', '_');

		DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			this.deleteTable(databaseAccess, ipaddress
					+ SNMP_STATIS_MIB_DATA_TABLE);
		} catch (SQLException e) {
			logger.info(DatabaseAccessControlKind.getInstance()
					.getDatabaseName()
					+ " : " + e.getMessage());
		}

		try {
			// f[^x[XEe[u쐬
			AbstractDataAccessObject dataaccess = DatabaseAccessControlKind
					.getInstance().getDataAccessObject();

			String statisItem = null;

			if (DatabaseAccessControlKind.getInstance().getDatabaseName()
					.equals(AbstractDataAccessObject.POSTGRESQL)) {
				this.dropSequence(databaseAccess, "DROP SEQUENCE " + ipaddress
						+ "_sta_id_seq");

				databaseAccess.executeUpdate("CREATE SEQUENCE " + ipaddress
						+ "_sta_id_seq");

				statisItem = " (id INTEGER DEFAULT NEXTVAL('" + ipaddress
						+ "_sta_id_seq'" + "), " + STATIS_OID
						+ "  VARCHAR(255)," + CURDATE + " "
						+ AbstractDataAccessObject.TIMESTAMP + ")";
			} else {
				String autoIncrement = dataaccess.getAutoIncrement();
				statisItem = " (" + autoIncrement + ", " + STATIS_OID
						+ "  VARCHAR(255)," + CURDATE + " "
						+ AbstractDataAccessObject.TIMESTAMP + ")";
			}

			databaseAccess.executeUpdate("CREATE TABLE " + ipaddress
					+ SNMP_STATIS_MIB_DATA_TABLE + statisItem);

			DBTableManagement tableManagement = new DBTableManagement();
			tableManagement.put(targetIpAddress, ipaddress
					+ SNMP_STATIS_MIB_DATA_TABLE, DBTableManagement.LIMIT_YES);
		} finally {
			if (databaseAccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						databaseAccess);
			}
		}
	}

	/**
	 * v̎OIDƃCX^Xi[f[^x[Xe[u𐶐 ܂B
	 * ie[usuffix_instanceOIDACX^Xi[j
	 * 
	 * @param targetIpAddress
	 *            m[hIPAhX
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized void createMibInstanceTable(final String targetIpAddress)
			throws DatabaseConnectionException, SQLException {
		String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
		ipaddress = ipaddress.replace('-', '_');

		DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			this.deleteTable(databaseAccess, ipaddress
					+ SNMP_STATIS_MIB_INSTANCE_TABLE);
		} catch (SQLException e) {
			logger.info(DatabaseAccessControlKind.getInstance()
					.getDatabaseName()
					+ " : " + e.getMessage());
		}

		try {
			String statisItem = " (" + STATIS_OID + "  VARCHAR(255), "
					+ INSTANCE_NAME + " VARCHAR(255)" + ")";
			databaseAccess.executeUpdate("CREATE TABLE " + ipaddress
					+ SNMP_STATIS_MIB_INSTANCE_TABLE + statisItem);
		} finally {
			if (databaseAccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						databaseAccess);
				databaseAccess = null;
			}
		}
	}

	/**
	 * vMIBf[^i[f[^x[Xe[ũCX^X ̎f[^i[邽߂̃CX^XJɒǉ܂B
	 * 
	 * ie[usuffix_statisDataj
	 * 
	 * @param targetIpAddress
	 *            m[hIPAhX
	 * @param columnName
	 *            e[uɒǉJ
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized void addStatisticsMibDataColumn(String targetIpAddress,
			String columnName) throws DatabaseConnectionException, SQLException {
		String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
		ipaddress = ipaddress.replace('-', '_');

		// DatabaseAccess databaseAccess = new DatabaseAccess();
		DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			this.addColumn(databaseAccess, ipaddress
					+ SNMP_STATIS_MIB_DATA_TABLE, columnName);

			// databaseAccess.executeUpdate(AbstractDataAccessObject.COMMIT);
		} finally {
			if (databaseAccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						databaseAccess);
				databaseAccess = null;
			}
		}
	}

	/**
	 * w̃e[uSNMPvi[Jǉ܂B
	 * 
	 * @param databaseAccess
	 *            f[^x[XANZXCX^X
	 * @param addTableName
	 *            ǉe[u
	 * @param columnName
	 *            J
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	private void addColumn(final DatabaseAccess databaseAccess,
			final String addTableName, final String columnName)
			throws DatabaseConnectionException, SQLException {
		String databaseKind = DatabaseAccessControlKind.getInstance()
				.getDatabaseName();

		if (databaseKind.equals(AbstractDataAccessObject.MYSQL)) {
			/* MySqlSQL */
			databaseAccess.executeUpdate("ALTER TABLE " + addTableName
					+ " ADD (" + columnName + " "
					+ AbstractDataAccessObject.MYSQL_DOUBLE + ");");
		} else if (databaseKind.equals(AbstractDataAccessObject.POSTGRESQL)) {
			/* PostgreSQLSQL */
			databaseAccess.executeUpdate("ALTER TABLE " + addTableName
					+ " ADD COLUMN " + columnName + " "
					+ AbstractDataAccessObject.POSTGRESQL_DOUBLE + ";");
		} else if (databaseKind.equals(AbstractDataAccessObject.HSQLDB)) {
			/* HSQLDBSQL */
			databaseAccess.executeUpdate("ALTER TABLE " + addTableName
					+ " ADD COLUMN " + columnName + " "
					+ AbstractDataAccessObject.HSQLDB_DOUBLE + ";");
		} else if (databaseKind.equals(AbstractDataAccessObject.DERBY)
				|| databaseKind.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
			/* Apache DerbySQL */
			databaseAccess.executeUpdate("ALTER TABLE " + addTableName
					+ " ADD COLUMN " + columnName + " "
					+ AbstractDataAccessObject.APACHE_DERBY_DOUBLE);
		} else {
			databaseAccess.executeUpdate("ALTER TABLE " + addTableName
					+ " ADD COLUMN " + columnName + " "
					+ AbstractDataAccessObject.BIGINT + ";");
		}

		// databaseAccess.executeUpdate("commit");
	}

	/**
	 * ̎OIDɑ΂CX^Xe[uɊi[܂B
	 * 
	 * @param targetIpAddress
	 *            m[hIPAhX
	 * @param oid
	 *            OID
	 * @param instanceName
	 *            CX^X
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized void putInstanceTable(final String targetIpAddress,
			final String oid, final String instanceName)
			throws DatabaseConnectionException, SQLException {
		String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
		ipaddress = ipaddress.replace('-', '_');

		DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			databaseAccess.executeUpdate("insert into " + ipaddress
					+ SNMP_STATIS_MIB_INSTANCE_TABLE + "(" + STATIS_OID + ","
					+ INSTANCE_NAME + ")" + " VALUES( " + "'" + oid + "',"
					+ "'" + instanceName + "')");

			// databaseAccess.executeUpdate(AbstractDataAccessObject.COMMIT);
		} finally {
			if (databaseAccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						databaseAccess);
				databaseAccess = null;
			}
		}
	}

	/**
	 * vWʃf[^e[uɊi[܂B
	 * 
	 * 
	 * @param snmptablename
	 *            e[u
	 * @param oid
	 *            ̎OID
	 * @param statisItemList
	 *            OIDCX^X̎f[^̃Xg
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized void put(final String snmptablename, final String oid,
			final ArrayList statisItemList) throws DatabaseConnectionException,
			SQLException {
		StringBuffer item = new StringBuffer();
		StringBuffer value = new StringBuffer();
		String sql = "";
		Date date = Calendar.getInstance().getTime();

		// DatabaseAccess databaseAccess = new DatabaseAccess();
		DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			// CX^X Loop
			for (int j = 0; j < statisItemList.size(); j++) {
				item.append((((MibValue) (statisItemList.get(j))).getMibName()
						.replace('.', '_') + ","));

				if (DatabaseAccessControlKind.getInstance().getDatabaseName()
						.equals(AbstractDataAccessObject.DERBY)
						|| DatabaseAccessControlKind
								.getInstance()
								.getDatabaseName()
								.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
					String mibValue = ((MibValue) (statisItemList.get(j)))
							.getMibValue();
					if (mibValue.equals("NaN") || mibValue.equals("NAN")) {
						mibValue = "0";
					}
					value.append((" " + mibValue + ","));
				} else {
					value.append(("'"
							+ ((MibValue) (statisItemList.get(j)))
									.getMibValue() + "',"));
				}
			}

			sql = "insert into " + snmptablename + SNMP_STATIS_MIB_DATA_TABLE
					+ " ( " + STATIS_OID + ", " + item + " " + CURDATE + " )"
					+ " VALUES( '" + oid + "', " + value + " '"
					+ simpleDateformat.format(date) + "'" + ")";

			// vWʃf[^DBɊi[
			databaseAccess.executeUpdate(sql);
		} catch (SQLException ex) {
			logger.warning(ex.getMessage() + " SQL=" + sql);
			logger.warning("Table=" + snmptablename
					+ SNMP_STATIS_MIB_DATA_TABLE + " oid=" + oid);
			throw ex;
		} finally {
			if (databaseAccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						databaseAccess);
				databaseAccess = null;
			}
		}
	}

	/**
	 * vMIB̎ɂ̎CX^XA̎A臒lȂǂ e[uɊi[܂B vMIB̎JnɌĂ΂܂B
	 * 
	 * @param targetIpAddress
	 *            m[hIPAhX
	 * @param oid
	 *            OID
	 * @param period
	 *            ̎
	 * @param threshHold
	 *            臒l
	 * @param type
	 *            臒lĎ^Cv
	 * @param instanceNo
	 *            CX^XNo.
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized void putStatisticsTable(String targetIpAddress,
			String oid, String period, String threshHold, String type,
			int instanceNo) throws DatabaseConnectionException, SQLException {
		Date date = Calendar.getInstance().getTime();

		String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
		ipaddress = ipaddress.replace('-', '_');

		String sql = "insert into " + ipaddress + SNMP_STATIS_CONFIG_TABLE_NAME
				+ "( " + STATIS_OID + ", " + INSTANCE_TOTAL + ", " + PERIOD
				+ ", " + THRESHOLD + ", " + THRESHOLD_TYPE + ", " + CURDATE
				+ " )" + " VALUES( " + "'" + oid + "'," + "'" + instanceNo
				+ "'," + "'" + period + "'," + "'" + threshHold + "'," + "'"
				+ type + "'," + "'" + simpleDateformat.format(date) + "') ";

		DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			databaseAccess.executeUpdate(sql);

			// databaseAccess.executeUpdate("commit");
		} catch (DatabaseConnectionException e) {
			logger.warning(e.getMessage() + " : IP=" + targetIpAddress
					+ " OID=" + oid + " Period=" + period + " Threshold="
					+ threshHold + " Type=" + type + " Instance=" + instanceNo);
			throw e;
		} catch (SQLException e) {
			logger.warning(e.getMessage() + " : IP=" + targetIpAddress
					+ " OID=" + oid + " Period=" + period + " Threshold="
					+ threshHold + " Type=" + type + " Instance=" + instanceNo);
			throw e;
		} finally {
			if (databaseAccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						databaseAccess);
				databaseAccess = null;
			}
		}
	}

	/**
	 * vMIB̎ɂ̎A臒lA臒lĎ@ȂǕύX܂B
	 * 
	 * @param targetIpAddress
	 *            m[hIPAhX
	 * @param oid
	 *            vMIB OID
	 * @param period
	 *            ̎
	 * @param threshHold
	 *            Ď臒l
	 * @param type
	 *            臒lĎ^CviώZ/j
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized void updateStatisticsTable(
			final String targetIpAddress, final String oid,
			final String period, final String threshHold, final String type)
			throws DatabaseConnectionException, SQLException {
		String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
		ipaddress = ipaddress.replace('-', '_');

		DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			String sql = "UPDATE " + ipaddress + SNMP_STATIS_CONFIG_TABLE_NAME
					+ " set" + " " + PERIOD + "= " + "'" + period + "'," + " "
					+ THRESHOLD + "= " + "'" + threshHold + "'," + " "
					+ THRESHOLD_TYPE + "= " + "'" + type + "'" + " where "
					+ STATIS_OID + "=" + "'" + oid + "'";
			databaseAccess.executeUpdate(sql);
		} catch (DatabaseConnectionException e) {
			logger.warning(e.getMessage() + " : IP=" + targetIpAddress
					+ " OID=" + oid + " Period=" + period + " Threshold="
					+ threshHold + " Type=" + type);
			throw e;
		} catch (SQLException ex) {
			logger.warning(ex.getMessage() + " : IP=" + targetIpAddress
					+ " OID=" + oid + " Period=" + period + " Threshold="
					+ threshHold + " Type=" + type);
			throw ex;
		} finally {
			if (databaseAccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						databaseAccess);
				databaseAccess = null;
			}
		}
	}

	/**
	 * wOIDɑ΂CX^X̍ŐVf[^擾 MIBv臒lĎŌĂ΂āAO|[Of[^ƂĒlԂ܂B
	 * 
	 * @param snmptablename
	 *            IPAhX̃hbgA_[o[ɕϊ
	 * @param oid
	 *            OID
	 * @param statisItemList
	 *            ̎OIDɑ΂CX^X̃e[ui[ XgiCX^X̃Xgj
	 * @return dataList ̎CX^X̓vf[^Xg
	 */
	public synchronized ArrayList get(final String snmptablename,
			final String oid, final ArrayList statisItemList) {
		ArrayList dataList = new ArrayList();

		DatabaseAccess dataaccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;

		// e[uiCX^Xj𒊏o
		String[] item = new String[statisItemList.size()];

		for (int j = 0; j < statisItemList.size(); j++) {
			item[j] = (((MibValue) (statisItemList.get(j))).getMibName()
					.replace('.', '_'));
		}

		/*
		 * eCX^XɑΉ|[Of[^ƍ̎ Database擾
		 */
		try {
			String exesql = "select * from " + snmptablename
					+ SNMP_STATIS_MIB_DATA_TABLE + " where " + STATIS_OID + "="
					+ "'" + oid + "'" + " order by " + CURDATE + " desc";

			conn = dataaccess.getConnection();
			stmt = conn.createStatement();
			rs = stmt.executeQuery(exesql);

			while (rs.next()) {
				/* ̎OIDɑΉCX^X̃f[^ƍ̎擾 */
				for (int i = 0; i < item.length; i++) {
					StatisticsInfo info = new StatisticsInfo();

					// info.setInstance(rs.getString(item[i]));
					info.setInstance(rs.getObject(item[i]).toString());

					info.setDate((Date) rs.getObject(CURDATE));

					dataList.add(info);
				}

				break;
			}
		} catch (Exception ex) {
			logger.warning(ex.getMessage() + " : Table=" + snmptablename
					+ " OID=" + oid);
			ex.printStackTrace();
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				rs = null;
			}

			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (conn != null) {
				if (dataaccess != null) {
					dataaccess.releaseConnection(conn);
					conn = null;
				}
			}

			if (dataaccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						dataaccess);
			}

			dataaccess = null;
		}

		return dataList;
	}

	/**
	 * wm[hAwOIDyюwԂ̃CX^Xf[^Ԃ܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param oid
	 *            wOID
	 * @param instance
	 *            CX^X
	 * @param startTime
	 *            wԊJn
	 * @param endTime
	 *            wԏI
	 * @return statisticsInfoList vf[^Xg
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized ArrayList findInstance(final String ipaddress,
			final String oid, final String instance, final String startTime,
			final String endTime) throws SQLException,
			DatabaseConnectionException {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;

		DatabaseAccess dataaccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		StatisticsMibInfo statisticsMibInfo;

		ArrayList statisticsInfoList = new ArrayList();

		try {
			String convIPAddress = DBTableBase.IP + ipaddress.replace('.', '_');
			convIPAddress = convIPAddress.replace('-', '_');

			String convInstance = instance.replace('.', '_');
			String convDotOid = oid.replace('_', '.');

			// sql̍쐬
			String sql;

			if ((startTime != null) && (endTime != null)) {
				sql = "SELECT "
						+ convInstance
						+ ","
						+ CURDATE
						+ " from "
						+ convIPAddress
						+ DBTableStatisticsMIBControl.SNMP_STATIS_MIB_DATA_TABLE
						+ " where " + CURDATE + " between " + "'" + startTime
						+ "'" + " and " + "'" + endTime + "'" + " and "
						+ STATIS_OID + "=" + "'" + convDotOid + "'"
						+ " order by " + CURDATE + " desc";
			} else {
				sql = "SELECT "
						+ convInstance
						+ ","
						+ CURDATE
						+ " from "
						+ convIPAddress
						+ DBTableStatisticsMIBControl.SNMP_STATIS_MIB_DATA_TABLE
						+ " where " + STATIS_OID + "=" + "'" + convDotOid + "'"
						+ " order by " + CURDATE + " desc";
			}

			conn = dataaccess.getConnection();

			// SQLXe[ggIuWFNg̍쐬
			stmt = conn.createStatement();

			// select̎s
			rs = stmt.executeQuery(sql);

			while (rs.next()) {
				/* vMIBlƍ̎Zbg */
				statisticsMibInfo = new StatisticsMibInfo();

				statisticsMibInfo.setStatisMibValue(rs.getObject(convInstance)
						.toString());
				statisticsMibInfo.setDate((Date) rs.getObject(CURDATE));

				statisticsInfoList.add(statisticsMibInfo);
			}
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				rs = null;
			}

			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (conn != null) {
				if (dataaccess != null) {
					dataaccess.releaseConnection(conn);
					conn = null;
					DatabaseAccessPool.getInstance()
							.releaseQueueDatabaseAccess(dataaccess);
				}
			}

			dataaccess = null;
		}

		return statisticsInfoList;
	}

	/**
	 * vMIB̎ɂāAȉ̃f[^Ԃ܂B EOID EĎ E臒l EĎ臒l^Cvi/ώZj E̎Jn
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @return controlDataList v̎vpeB
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized ArrayList getList(final String ipaddress)
			throws SQLException, DatabaseConnectionException {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;

		ArrayList controlDataList = new ArrayList();
		String convipaddress = DBTableBase.IP + ipaddress.replace('.', '_');
		convipaddress = convipaddress.replace('-', '_');

		DatabaseAccess dataaccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			// sql̍쐬
			String sql = "SELECT * from " + convipaddress
					+ DBTableStatisticsMIBControl.SNMP_STATIS_CONFIG_TABLE_NAME;
			conn = dataaccess.getConnection();

			// SQLXe[ggIuWFNg̍쐬
			stmt = conn.createStatement();

			// select̎s
			rs = stmt.executeQuery(sql);

			while (rs.next()) {
				StatisticsMibSetStatus statisticsset = new StatisticsMibSetStatus();

				statisticsset.setReadOid(rs.getObject(STATIS_OID).toString());
				statisticsset.setReadPeriod(rs.getObject(PERIOD).toString());
				statisticsset.setReadThreshold(rs.getObject(THRESHOLD)
						.toString());
				statisticsset.setReadThresholdType(rs.getObject(THRESHOLD_TYPE)
						.toString());
				statisticsset.setReadCurDate(rs.getObject(CURDATE).toString());

				controlDataList.add(statisticsset);
			}
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				rs = null;
			}

			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (conn != null) {
				if (dataaccess != null) {
					dataaccess.releaseConnection(conn);
					conn = null;
					DatabaseAccessPool.getInstance()
							.releaseQueueDatabaseAccess(dataaccess);
				}
			}

			dataaccess = null;
		}

		return controlDataList;
	}

	/**
	 * vMIB̎ɂāAȉ̃f[^Ԃ܂B E̎f[^ Eől Eŏl E̎Jn EŐV̎
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param oid
	 *            OID
	 * @param instance
	 *            CX^X
	 * @return statisticsProp vvpeB
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized StatisticsMibProperty getDataCount(
			final String ipaddress, final String oid, final String instance)
			throws SQLException, DatabaseConnectionException {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;

		DatabaseAccess dataaccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		StatisticsMibProperty statisticsProp = new StatisticsMibProperty();

		try {
			String convIPAddress = DBTableBase.IP + ipaddress.replace('.', '_');
			convIPAddress = convIPAddress.replace('-', '_');

			String convInstance = instance.replace('.', '_');
			String convDotOid = oid.replace('_', '.');

			// sql̍쐬
			String sql = "select count(*) from " + convIPAddress
					+ SNMP_STATIS_MIB_DATA_TABLE + " where " + STATIS_OID + "="
					+ "'" + convDotOid + "'";
			conn = dataaccess.getConnection();

			// SQLXe[ggIuWFNg̍쐬
			stmt = conn.createStatement();

			// select̎s
			rs = stmt.executeQuery(sql);
			rs.next();

			int count = -1;
			count = rs.getInt(1);
			statisticsProp.setTotalDataCount(count);

			sql = "select " + AbstractDataAccessObject.MIN + "(" + CURDATE
					+ "), " + AbstractDataAccessObject.MAX + "(" + CURDATE
					+ ") from " + convIPAddress
					+ DBTableStatisticsMIBControl.SNMP_STATIS_MIB_DATA_TABLE
					+ " where " + STATIS_OID + "=" + "'" + convDotOid + "'";

			// select̎s
			rs = stmt.executeQuery(sql);
			rs.next();

			statisticsProp.setStartDate((Date) rs.getObject(1));
			statisticsProp.setEndDate((Date) rs.getObject(2));

			/*
			 * ŏlyэőlo
			 */
			sql = "select " + AbstractDataAccessObject.MIN + "(" + convInstance
					+ "), " + AbstractDataAccessObject.MAX + "(" + convInstance
					+ ") from " + convIPAddress
					+ DBTableStatisticsMIBControl.SNMP_STATIS_MIB_DATA_TABLE
					+ " where " + STATIS_OID + "=" + "'" + convDotOid + "'";

			// select̎s
			rs = stmt.executeQuery(sql);
			rs.next();

			double minValue = -1;

			if (rs.getObject(1) != null) {
				minValue = Double.parseDouble(rs.getObject(1).toString());
			}

			double maxValue = -1;

			if (rs.getObject(2) != null) {
				maxValue = Double.parseDouble(rs.getObject(2).toString());
			}

			statisticsProp.setMinData(Double.toString(minValue));
			statisticsProp.setMaxData(Double.toString(maxValue));
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				rs = null;
			}

			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (conn != null) {
				if (dataaccess != null) {
					dataaccess.releaseConnection(conn);
					conn = null;
					DatabaseAccessPool.getInstance()
							.releaseQueueDatabaseAccess(dataaccess);
				}
			}

			dataaccess = null;
		}

		return statisticsProp;
	}

	/**
	 * wm[hIPAhX̓v̎MIBɂāACX^XAOIDȂǂ XgƂĕԂ܂B OIDC^tF[Xn(ifEntry :
	 * OID=1.3.6.1.2.1.2.2.1 )̏ꍇɂ́A C^tF[XifDesctĕԂ܂B
	 * 
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @return statisticsMibIfDescList vMIB
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized ArrayList findIfDescriptor(String ipaddress)
			throws DatabaseConnectionException, SQLException {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;

		DatabaseAccess dataaccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		ArrayList statisticsMibIfDescList = new ArrayList();
		ArrayList oidList = new ArrayList();

		String convipaddress = DBTableBase.IP + ipaddress.replace('.', '_');
		convipaddress = convipaddress.replace('-', '_');

		try {
			/*
			 * vMIB̎OIDf[^x[X擾
			 */

			// sql̍쐬 _statis
			String sql = "SELECT * from " + convipaddress
					+ DBTableStatisticsMIBControl.SNMP_STATIS_CONFIG_TABLE_NAME;
			System.out.println(sql);

			// select̎s
			conn = dataaccess.getConnection();

			// SQLXe[ggIuWFNg̍쐬
			stmt = conn.createStatement();

			// select̎s
			rs = stmt.executeQuery(sql);

			while (rs.next()) {
				oidList.add((rs.getObject(STATIS_OID).toString()).replace('.',
						'_'));
			}

			/*
			 * ifDesc܂ރC^tF[XMIB擾 _if
			 */
			sql = "SELECT * from " + convipaddress
					+ DBTableInterfaceMIB.SNMP_IF_TABLE_NAME;

			HashMap ifDescMap = new HashMap();

			// select̎s
			rs = stmt.executeQuery(sql);

			while (rs.next()) {
				ifDescMap.put(rs.getObject("ifIndex").toString(), rs.getObject(
						"ifDesc").toString());
			}

			StatisticsMibIfDescriptor statisticsMibIfDesc;

			for (int i = 0; i < oidList.size(); i++) {
				/*
				 * 
				 * _instancef[^e[uɑ΂OID񂩂CX^Xiexp. ifInOctets.1j 擾
				 */
				sql = "SELECT * from "
						+ convipaddress
						+ DBTableStatisticsMIBControl.SNMP_STATIS_MIB_INSTANCE_TABLE
						+ " where " + STATIS_OID + "=" + "'"
						+ ((String) oidList.get(i)).replace('_', '.') + "'";
				System.out.println(sql);

				// select̎s
				rs = stmt.executeQuery(sql);

				while (rs.next()) {
					String instanceName = rs.getObject(INSTANCE_NAME)
							.toString();

					String[] instanceSplit = instanceName.split("[.]", 2);
					String ifDesc = (String) ifDescMap.get(instanceSplit[1]);

					statisticsMibIfDesc = new StatisticsMibIfDescriptor();
					statisticsMibIfDesc.setOid("Oid="
							+ ((String) oidList.get(i)).replace('_', '.'));
					statisticsMibIfDesc.setInstance((rs
							.getObject(INSTANCE_NAME).toString()));

					/*
					 * ifEntry(1.3.6.1.2.1.2.2.1)Ɋ܂܂OIDiC^tF[XnOIDj`FbN
					 */
					int check0 = ((String) oidList.get(i)).replace('_', '.')
							.indexOf("1.3.6.1.2.1.2.2.1");

					if (check0 >= 0) {
						/*
						 * C^tF[XnOID̏ꍇ́AifDesc̋LqZbg exp. ifDesc=Realtek
						 * RTL8139/810X Family PCI Fast Eth
						 */
						statisticsMibIfDesc.setIfDescriptor("ifDesc=" + ifDesc);
					} else {
						statisticsMibIfDesc.setIfDescriptor("");
					}

					statisticsMibIfDescList.add(statisticsMibIfDesc);
				} // OIDPʂ̃f[^x[XSelect while endŏListɒǉ
			} // v̎SOID List Loop end
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				rs = null;
			}

			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (conn != null) {
				if (dataaccess != null) {
					dataaccess.releaseConnection(conn);
					conn = null;
					DatabaseAccessPool.getInstance()
							.releaseQueueDatabaseAccess(dataaccess);
				}
			}

			dataaccess = null;
		}

		return statisticsMibIfDescList;
	}

	/**
	 * wm[hIPAhXSNMPvvpeB擾܂B
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @return StatisticsMibProperty
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized StatisticsMibProperty findStatisticsInstanceMap(
			String ipaddress) throws DatabaseConnectionException, SQLException {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;

		DatabaseAccess dataaccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		StatisticsMibProperty mibProperty = new StatisticsMibProperty();
		ArrayList statisticsMibIfDescList = new ArrayList();
		HashMap statisticsMibInstanceMap = new HashMap();
		ArrayList oidList = new ArrayList();

		String convipaddress = DBTableBase.IP + ipaddress.replace('.', '_');
		convipaddress = convipaddress.replace('-', '_');

		try {
			/*
			 * vMIB̎OIDf[^x[X擾
			 */

			// sql̍쐬 _statis
			String sql = "SELECT * from " + convipaddress
					+ DBTableStatisticsMIBControl.SNMP_STATIS_CONFIG_TABLE_NAME;
			System.out.println(sql);

			// select̎s
			conn = dataaccess.getConnection();

			// SQLXe[ggIuWFNg̍쐬
			stmt = conn.createStatement();

			// select̎s
			rs = stmt.executeQuery(sql);

			while (rs.next()) {
				oidList.add((rs.getObject(STATIS_OID).toString()).replace('.',
						'_'));
			}

			/*
			 * ifDesc܂ރC^tF[XMIB擾 _if
			 */
			sql = "SELECT * from " + convipaddress
					+ DBTableInterfaceMIB.SNMP_IF_TABLE_NAME;
			System.out.println(sql);

			HashMap ifDescMap = new HashMap();

			// select̎s
			rs = stmt.executeQuery(sql);

			while (rs.next()) {
				ifDescMap.put(rs.getObject("ifIndex").toString(), rs.getObject(
						"ifDesc").toString());
				System.out.println("ifDesc : "
						+ (rs.getObject("ifDesc").toString()));
				System.out.println("ifIndex : "
						+ (rs.getObject("ifIndex").toString()));
			}

			StatisticsMibIfDescriptor statisticsMibIfDesc;

			for (int i = 0; i < oidList.size(); i++) {
				/*
				 * 
				 * _instancef[^e[uɑ΂OID񂩂CX^Xiexp. ifInOctets.1j 擾
				 */
				sql = "SELECT * from "
						+ convipaddress
						+ DBTableStatisticsMIBControl.SNMP_STATIS_MIB_INSTANCE_TABLE
						+ " where " + STATIS_OID + "=" + "'"
						+ ((String) oidList.get(i)).replace('_', '.') + "'";
				System.out.println(sql);

				// select̎s
				rs = stmt.executeQuery(sql);

				while (rs.next()) {
					String instanceName = rs.getObject(INSTANCE_NAME)
							.toString();

					String[] instanceSplit = instanceName.split("[.]", 2);
					String ifDesc = (String) ifDescMap.get(instanceSplit[1]);

					statisticsMibIfDesc = new StatisticsMibIfDescriptor();
					statisticsMibIfDesc.setOid("Oid="
							+ ((String) oidList.get(i)).replace('_', '.'));
					statisticsMibIfDesc.setInstance((rs
							.getObject(INSTANCE_NAME).toString()));

					/*
					 * ifEntry(1.3.6.1.2.1.2.2.1)Ɋ܂܂OIDiC^tF[XnOIDj`FbN
					 */
					int check0 = ((String) oidList.get(i)).replace('_', '.')
							.indexOf("1.3.6.1.2.1.2.2.1");

					if (check0 >= 0) {
						/*
						 * C^tF[XnOID̏ꍇ́AifDesc̋LqZbg exp. ifDesc=Realtek
						 * RTL8139/810X Family PCI Fast Eth
						 */
						statisticsMibIfDesc.setIfDescriptor("ifDesc=" + ifDesc);
					} else {
						statisticsMibIfDesc.setIfDescriptor("");
					}

					statisticsMibIfDescList.add(statisticsMibIfDesc);

					/*
					 * v̎OIDL[ƂA̎MIBCX^X MapɊi[B ́Av̎f[^wOIDʂ
					 * IE\ꍇɎgpB
					 */
					String checkOID = ((String) oidList.get(i)).replace('_',
							'.');

					if (statisticsMibInstanceMap.containsKey(checkOID)) {
						/*
						 * wOIDɑΉCX^Xi[Xg oăCX^Xǉ
						 */
						ArrayList ifList = (ArrayList) statisticsMibInstanceMap
								.get(checkOID);
						ifList.add(statisticsMibIfDesc);
						statisticsMibInstanceMap.put(checkOID, ifList);
					} else {
						/*
						 * MapɎwOID݂Ȃꍇɂ́ACX^X i[Xg𐶐i[
						 */
						ArrayList ifList = new ArrayList();
						ifList.add(statisticsMibIfDesc);
						statisticsMibInstanceMap.put(checkOID, ifList);
					}
				} // OIDPʂ̃f[^x[XSelect while endŏListɒǉ
			} // v̎SOID List Loop end
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				rs = null;
			}

			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (conn != null) {
				if (dataaccess != null) {
					dataaccess.releaseConnection(conn);
					conn = null;
					DatabaseAccessPool.getInstance()
							.releaseQueueDatabaseAccess(dataaccess);
				}
			}

			dataaccess = null;
		}

		mibProperty.setMibIfDescriptorList(statisticsMibIfDescList);
		mibProperty.setStatisticsMibInstanceMap(statisticsMibInstanceMap);

		return mibProperty;
	}

	/**
	 * C^tF[XMIBf[^𓝌vMIBe[u擾ĕԂ܂B ̃\bh̓C^tF[XMIB_Ot\p̃f[^擾
	 * ČĂ΂܂B [hƂāAώZ܂͍Ot\AώZOt\ ł́AŐVf[^݂̂ԂAOt\ł͍ŐVf[^
	 * Õf[^Ԃ܂B
	 * 
	 * 
	 * @param ipaddress
	 *            m[hIPAhX
	 * @param oid
	 *            OID
	 * @param mode
	 *            ώZ/[h
	 * @return ifObjectList v񃊃Xg
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public synchronized ArrayList getInterfaceDataList(final String ipaddress,
			final String oid, final String mode) throws SQLException,
			DatabaseConnectionException {
		//
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;

		// DatabaseAccess dataaccess = new DatabaseAccess();
		DatabaseAccess dataaccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		ArrayList ifObjectList = new ArrayList();
		ArrayList instanceNameList = new ArrayList();

		try {
			// MINebgyюMINebgMIB̃CX^Xf[^x[X璊o
			String convIPAddress = DBTableBase.IP + ipaddress.replace('.', '_');
			convIPAddress = convIPAddress.replace('-', '_');

			String sql = "SELECT "
					+ INSTANCE_NAME
					+ " from "
					+ convIPAddress
					+ DBTableStatisticsMIBControl.SNMP_STATIS_MIB_INSTANCE_TABLE
					+ " where " + STATIS_OID + "=" + "'" + oid + "'";

			// DB Selectcolum񐶐
			String instanceName = "";

			// SQLXe[ggIuWFNg̍쐬
			conn = dataaccess.getConnection();
			stmt = conn.createStatement();

			// select̎s
			rs = stmt.executeQuery(sql);

			while (rs.next()) {
				instanceNameList.add(((String) rs.getObject(INSTANCE_NAME))
						.replace('.', '_'));
				instanceName += (((String) rs.getObject(INSTANCE_NAME))
						.replace('.', '_') + ",");
			}

			// CX^X̓vf[^ŐVŃ\[gĒo
			sql = "SELECT " + instanceName + " " + CURDATE + " from "
					+ convIPAddress
					+ DBTableStatisticsMIBControl.SNMP_STATIS_MIB_DATA_TABLE
					+ " where " + STATIS_OID + "=" + "'" + oid + "'"
					+ " order by " + CURDATE + " desc";

			rs = stmt.executeQuery(sql);

			int datacnt = 0;
			InterfaceData interfaceinfo = null;

			while (rs.next()) {
				/*
				 * CX^XɃCX^XAlyэ̎ 擾ăCX^XɃZbgAXgɒǉ
				 */
				for (int i = 0; instanceNameList.size() > i; i++) {
					interfaceinfo = new InterfaceData();
					interfaceinfo.setInstanceName((String) instanceNameList
							.get(i));
					interfaceinfo.setInstanceValue(rs.getObject(
							(String) instanceNameList.get(i)).toString());

					/* ̎ */
					interfaceinfo.setDate((Date) rs.getObject(CURDATE));

					/* CX^XAlA̎Xgɒǉ */
					ifObjectList.add(interfaceinfo);
				}

				// ŐVƑO̎Zbgbreak
				if (mode.equals("integral")) {
					/* ώZ̏ꍇ́AŐVf[^̂ݎ擾ŏI */
					break;
				}

				/* ̏ꍇ́AŐVƈÔQ񕪂擾ďI */
				if (datacnt >= 1) {
					break;
				}

				datacnt++;
			}
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				rs = null;
			}

			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (conn != null) {
				if (dataaccess != null) {
					dataaccess.releaseConnection(conn);
					conn = null;
				}
			}

			if (dataaccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						dataaccess);
			}
		}

		return ifObjectList;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final DBTableStatisticsMIBControl RESOURCE = new DBTableStatisticsMIBControl();
	}
}
