/*
 * Created on 2007/03/12
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap.gui.icon;

import netjfwatcher.engine.nodemaneger.map.NodeMapInfo;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;

public class NodeIconViewMouseListener extends MouseAdapter implements
		MouseMoveListener {

	/* GC */
	private GC gc;

	private NodeMapInfo nodeMapInfo;

	/* m[hMapr[`NXCX^X */
	private NodeIconViewDraw mapDraw;

	public NodeIconViewMouseListener(Canvas canvas, GC gc, boolean isSocket,
			NodeMapInfo nodeMapinfo) {
		this.gc = gc;
		this.nodeMapInfo = nodeMapinfo;
		mapDraw = new NodeIconViewDraw(canvas, gc);

	}

	/**
	 * }EXDownCxgXi[łB m[hIcon̈ړ܂́Am[hԃN`Jn܂B
	 * 
	 * @param event
	 *            MouseEvent
	 */
	public void mouseDown(MouseEvent event) {

		int pointX = NodeIconView.NODE_ICON_X;
		int pointY = NodeIconView.NODE_ICON_Y;
		nodeMapInfo.setX(pointX);
		nodeMapInfo.setY(pointY);
		nodeMapInfo.setSelected(true);

		/* ĕ` */
		mapDraw.redraw(nodeMapInfo);
		NodeIcon.getInstance().setValid(true);
		NodeIcon.getInstance().setSetViewList(false);
		NodeIcon.getInstance().setNodeMapinfo(nodeMapInfo);
	}

	public void mouseUp(MouseEvent event) {

		mapDraw.redraw(nodeMapInfo);
		nodeMapInfo.setSelected(false);

	}

	public void mouseMove(MouseEvent event) {

	}

	public void redraw() {

		/* ĕ` */
		mapDraw.redraw(nodeMapInfo);

	}

	public NodeIconViewDraw getMapDraw() {
		return mapDraw;
	}
}
