/*
 * Created on 2007/01/30
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.osgi.framework.Bundle;


public class EnterpriseOIDConfig {
    /* Logging */
    private static Logger logger = null;
    private Map<String, EnterpriseOIDInfo> enterpriseOidHashMap;


    private EnterpriseOIDConfig() {
        logger = Logger.getLogger(this.getClass().getName());
        enterpriseOidHashMap = Collections.synchronizedMap(new LinkedHashMap<String, EnterpriseOIDInfo>());

        URL url = getDocument(TrapPreference.ENTERPRISE_OID_CONF_FILE);

        if (url != null) {
            parseFile(url);
        }
    }

    /*
     * t@CE͂URLԂ܂B
     *
     * @param filePath t@CpX
     * @return url URL
     */
    private URL getDocument(String filePath) {
        URL url = null;

        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

        // this.getClass().getClassLoader().getResource(filePath);
        url = bundle.getEntry(filePath);

        if (url == null) {
            /* bZ[W\[Xt@CȂꍇMO̎ */
            logger.severe("Not found file url : " + filePath);

            return null;
        }

        return url;
    }

    public void parseFile(URL url) {
        logger = Logger.getLogger(this.getClass().getName());

        logger.info("file : " + url.getFile());

        InputStream is = null;

        try {
            is = url.openStream();
        } catch (IOException e3) {
            e3.printStackTrace();
            return;
        }

        BufferedReader buffReader = null;

        try {
            InputStreamReader ti = new InputStreamReader(is);
            buffReader = new BufferedReader(ti);

            String str;
            Pattern pattern;
            String[] item;

            while ((str = buffReader.readLine()) != null) {
                pattern = Pattern.compile("[ \t]"); // 󔒂܂̓^u
                item = pattern.split(str, 2);

                if (item.length >= 2) {
                	EnterpriseOIDInfo enterpriseOidInfo = new EnterpriseOIDInfo();
                    enterpriseOidInfo.setEnterpriseOID(item[0]);

                    String company = item[1].replaceAll("\t", " ");
                    enterpriseOidInfo.setCompany(company);

                    enterpriseOidHashMap.put(item[0], enterpriseOidInfo);
                }
            }
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (buffReader != null) {
                try {
                    buffReader.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }

            if (is != null) {
                try {
                    is.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    public Map getEnterpriseOidHashMap() {
        return enterpriseOidHashMap;
    }
    
    
	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static EnterpriseOIDConfig getInstance() {
		return SingletonResource.ENTERPRISE_OID_INSTANCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final EnterpriseOIDConfig ENTERPRISE_OID_INSTANCE = new EnterpriseOIDConfig();
	}
}
