/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;


/**
 * SNMP Agentj^[ɕ\邽߂̃L[\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AgentMonitorMessageQueue {
    /* L[List */
    private static List list = Collections.synchronizedList(new LinkedList());

    /* L[TCYl */
    private static final int QUEUE_LIMIT = 1000;

    /* L[Ƀf[^i[邩ۂtO */
    private boolean isMonitor = false;

    /*
     * SNMP Agentj^[ɕ\邽߂̃L[\NX
     * CX^X𐶐܂B
     *
     */
    private AgentMonitorMessageQueue() {
        // nothing
    }

    /**
     *  SNMP Agentj^[ɕ\郁bZ[WL[
     * Push܂B
     *
     * @param obj bZ[W
     */
    public void pushAgentMessage(Object obj) {
        if (isMonitor) {
            if (list.size() > QUEUE_LIMIT) {
                list.remove(0);
                list.add(obj);
            } else {
                list.add(obj);
            }
        }
    }

    /**
     * SNMP Agentj^[ɕ\郁bZ[WL[
     * Pop܂B
     *
     * @return message bZ[W
     */
    public Object popAgentMessage() {
        Object message = null;

        if (list.size() > 0) {
            message = list.get(0);
            list.remove(0);
        }

        return message;
    }

    /**
     * L[ɃbZ[Wi[邩ۂ̃tOZbg܂B
     *
     * @param isMonitor iL[ɃbZ[Wi[邩ۂ̃tO
     */
    public void setMonitor(boolean isMonitor) {
        list.clear();
        this.isMonitor = isMonitor;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static AgentMonitorMessageQueue getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final AgentMonitorMessageQueue RESOURCE =
            new AgentMonitorMessageQueue();
    }
}
