/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.model;

import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter64;
import netjfwatcher.snmp.snmpobject.integer.SnmpGauge32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.integer.SnmpUInteger32;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmpagent.process.ThreadAgent;



/**
 * SNMP^G[WFg삷ThreadN܂B
 * IMIBvCX^Xf[^JEgAbv܂B
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentMIBCountUpThread implements Runnable {
    /* Tread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger;

    /* MIBvCX^Xf[^XV */
    private int period;

    /* MIBvCX^Xf[^l */
    private int incrementData;

    /* ^[QbgMIBvCX^X */
    private MibInfo oidInfo;

    /**
     * Snmp AgentCX^XXVXbh𐶐܂B
     *
     * @param targetOid ΏOID
     * @param period XV
     * @param incrementData Zl
     */
    public AgentMIBCountUpThread(
        String targetOid, int period, int incrementData) {
        this.period = period;
        this.incrementData = incrementData;

        logger = Logger.getLogger(this.getClass().getName());

        oidInfo =
            AgentInstanceDataMap.getInstance().getAgentInstanceDataInfo(
                targetOid);
    }

    /**
     * Snmp AgentCX^XXVIɎs܂B
     *
     */
    public void run() {
        while (!Thread.interrupted()) {
            try {
                /* XVf[^쐬 */
                int value = Integer.parseInt(oidInfo.getValue());

                /*
                 * f[^ZA܂͌ZiZl}CiX̏ꍇj
                 */
                int newData = value + incrementData;
                oidInfo.setValue(Integer.toString(newData));

                logger.info("new Value : " + oidInfo.getValue());
                logger.info("period : " + period);

                /* SNMP Agent̃CX^Xf[^ێĂlXV */
                AgentInstanceDataMap.getInstance().setAgentInstanceDataMap(
                    oidInfo.getOid(), oidInfo);

                /* Agnet MIB`ǂݍ */
                AgentMibTree agentMibTree = AgentMibTree.getInstance();
                HashMap agentOidHashMap = agentMibTree.getOidHashMap();

                /*
                 * AgentCX^Xf[^XV
                 */
                MibInfo agentInstanceDataOidInfo =
                    (MibInfo) agentOidHashMap.get(oidInfo.getOid());
                AbstractSnmpObject newSnmpObject =
                    createSnmpObject(
                        oidInfo.getOid(), oidInfo.getValue(),
                        oidInfo.getSyntax());

                if (newSnmpObject != null) {
                    agentInstanceDataOidInfo.setAgentMibValue(newSnmpObject);
                    agentOidHashMap.put(
                        oidInfo.getOid(), agentInstanceDataOidInfo);
                    agentMibTree.setOidHashMap(agentOidHashMap);
                    /*
                     * Snmp AgentCX^Xf[^\e[uXV
                     * L[ɍXVf[^Push
                     */
                    AgentInstanceDataRefreshQueue.getInstance().pushQueue(
                        oidInfo);
                }

                Thread.sleep(period * WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.info(e.getMessage());

                break;
            }
        }
    }

    /**
     * wSNMP Object TypeSNMP Object𐶐ĕԂ܂B
     *
     * @param oid OID
     * @param value SNMP Objectl
     * @param oidType SNMP Object Type
     * @return newSnmpObject SNMP Object
     */
    private AbstractSnmpObject createSnmpObject(
        final String oid, final String value, final String oidType) {
        /*
             * SNMP ObjectwTypeŐ
             */
        AbstractSnmpObject newSnmpObject = null;

        if (oidType.equals(ManagerMibTree.INTEGER)) {
            newSnmpObject = new SnmpInteger();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                return null;
            }
        } else if (oidType.equals(ManagerMibTree.COUNTER32)) {
            newSnmpObject = new SnmpCounter32();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                return null;
            }
        } else if (oidType.equals(ManagerMibTree.COUNTER64)) {
            newSnmpObject = new SnmpCounter64();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                return null;
            }
        } else if (oidType.equals(ManagerMibTree.GAUGE32)) {
            newSnmpObject = new SnmpGauge32();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                return null;
            }
        } else if (oidType.equals(ManagerMibTree.UINTEGER32)) {
            newSnmpObject = new SnmpUInteger32();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                return null;
            }
        } else if (oidType.equals(ManagerMibTree.OBJECTID)) {
            newSnmpObject = new SnmpObjectIdentifier();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                return null;
            }
        } else if (oidType.equals(ManagerMibTree.TIMETICKS)) {
            newSnmpObject = new SnmpTimeTicks();

            try {
                newSnmpObject.setValue(value);

                if (oid.equals(AgentDataImport.SYSUPTIME_OID)) {
                    long sysupTimeMills =
                        System.currentTimeMillis()
                        - (Long.parseLong(value) * 1000);
                    ThreadAgent.getInstance().setStartSnmpAgentEngineTime(
                        sysupTimeMills);
                }
            } catch (SnmpBadValueException e) {
                return null;
            }
        } else if (oidType.equals(ManagerMibTree.OCTETSTRING)) {
            newSnmpObject = new SnmpOctetString();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                return null;
            }
        }

        return newSnmpObject;
    }

    /**
     * OIDԂ܂B
     * ̒ɂ́AdescriptionA^CvAANZX^CvȂǂێĂ܂B
     * G[WFg̃CX^XݒIy[VViewł
     * ݒl\ŌĂ΂܂B
     *
     * @return oidInfo ߂܂B
     */
    public MibInfo getOidInfo() {
        return oidInfo;
    }

    /**
     * CX^XlԂ܂B
     * G[WFg̃CX^XݒIy[VViewł
     * ݒl\ŌĂ΂܂B
     *
     * @return incrementData ߂܂B
     */
    public int getIncrementData() {
        return incrementData;
    }

    /**
     * XVԂ܂B
     * G[WFg̃CX^XݒIy[VViewł
     * ݒl\ŌĂ΂܂B
     *
     * @return period ߂܂B
     */
    public int getPeriod() {
        return period;
    }
}
