/*
 * Created on 2003/06/25
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.preference;


/**
 * SNMP V3 vtFXNXłB
 * SNMP V3f[^tH[}bg̒`s܂B
 *
 * +-----------+-----------+----------------------------+
 * | Header    |           | msgVersion                 |
 * |           |           +----------------------------+
 * |           |           | msgID                      |
 * |           |           +----------------------------+
 * |           |           | msgMaxSize                 |
 * |           |           +----------------------------+
 * |           |           | msgFlags                   |
 * |           |           +----------------------------+
 * |           |           | msgSecurityModel           |
 * +-----------+-----------+----------------------------+
 * | Security  |           | msgAuthoritativeEngineID   |
 * | Params    |           +----------------------------+
 * |           |           | msgAuthoritativeBoots      |
 * |           |           +----------------------------+
 * |           |           | msgAuthoritativeEngineTime |
 * |           |           +----------------------------+
 * |           |           | msgUserName                |
 * |           |           +----------------------------+
 * |           |           | msgAuthenticationParameters|
 * |           |           +----------------------------+
 * |           |           | msgPrivacyParameters       |
 * +-----------+-----------+----------------------------+
 * | Scoped    |           | contextEngineID            |
 * | PDU Data  |           +----------------------------+
 * |           |           | contextName                |
 * |           |           +----------------------------+
 * |           |           | PDU Data                   |
 * +-----------+-----------+----------------------------+
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpV3Preference {
    /** SNMP V3 Engine Sysup Time̋e͈(b) */
    public static final int NOT_INTIME_WINDOWS = 150;

    /** SNMP V3 msgFlagɂReport Flag */
    public static final byte SNMPV3_MSG_FLAGS_REPORT = 0x04;
    /** SNMP V3 msgFlagɂReport Flag}XN */
    public static final byte SNMPV3_MSG_FLAGS_REPORT_MASK = 0x03;
    /** SNMP V3 msgFlagɂNo Auth R[h */
    public static final byte SNMPV3_MSG_FLAGS_NOAUTH = 0x00;

    /** SNMP V3 msgFlagɂAuth Flag Bit */
    public static final byte SNMPV3_MSG_FLAGS_AUTH = 0x01;

    /** SNMP V3 msgFlagɂPriv Flag Bit */
    public static final byte SNMPV3_MSG_FLAGS_PRIV = 0x02;
    /** SNMP V3 msgFlagɂAuth/Priv Flag Bit */
    public static final byte SNMPV3_MSG_FLAGS_AUTH_PRIV = 0x03;
    /*
     * snmpEngine Security Model
     */

    /** snmpEngine Security Model "Any" */
    public static final int SECURITY_MODEL_ANY = 0;

    /** snmpEngine Security Model SNMPv1 */
    public static final int SECURITY_MODEL_SNMPV1 = 1;

    /** snmpEngine Security Model SNMPv2 */
    public static final int SECURITY_MODEL_SNMPV2C = 2;

    /** snmpEngine Security Model USM */
    public static final int SECURITY_MODEL_USM = 3;

    /** SNMP V3 őPDUTCY */
    public static final int SNMP_V3_MAX_PDU_SIZE = 1472;

    /** SNMP V3 bZ[WőTCY */
    public static final int SNMP_V3_MSG_MAXSIZE = 8192;

    /**
     * USM msgAuthenticationParameters message digest,
     * 12bytes̒`
     */
    public static final int MSG_AUTHENTICATION_PARAM_MSG_DIGEST_LEN = 12;

    /** Auth description */
    public static final String AUTH = "AUTH";

    /** NoAuth description */
    public static final String NOAUTH = "NOAUTH";

    /** Priv description */
    public static final String PRIV = "PRIV";

    /** Auth Protocol MD5 description */
    public static final String AUTH_PROTOCOL_MD5 = "MD5";

    /** Priv Protocol DES description */
    public static final String PRIV_PROTOCOL_DES = "DES";

    /** Auth Protocol SHA1 description */
    public static final String AUTH_PROTOCOL_SHA1 = "SHA-1";

    /** Hmac MD5 description */
    public static final String HMAC_MD5 = "HmacMD5";

    /** Hmac SHA1 description */
    public static final String HMAC_SHA1 = "HmacSHA1";

    /*
     * SNMP V3 bZ[WtH[}bg
     *
     * +-----------+-----------+----------------------------+
     * | Header    |           | msgVersion                 |
     * |           |           +----------------------------+
     * |           |           | msgID                      |
     * |           |           +----------------------------+
     * |           |           | msgMaxSize                 |
     * |           |           +----------------------------+
     * |           |           | msgFlags                   |
     * |           |           +----------------------------+
     * |           |           | msgSecurityModel           |
     * +-----------+-----------+----------------------------+
     * | Security  |           | msgAuthoritativeEngineID   |
     * | Params    |           +----------------------------+
     * |           |           | msgAuthoritativeBoots      |
     * |           |           +----------------------------+
     * |           |           | msgAuthoritativeEngineTime |
     * |           |           +----------------------------+
     * |           |           | msgUserName                |
     * |           |           +----------------------------+
     * |           |           | msgAuthenticationParameters|
     * |           |           +----------------------------+
     * |           |           | msgPrivacyParameters       |
     * +-----------+-----------+----------------------------+
     * | Scoped    |           | contextEngineID            |
     * | PDU Data  |           +----------------------------+
     * |           |           | contextName                |
     * |           |           +----------------------------+
     * |           |           | PDU Data                   |
     * +-----------+-----------+----------------------------+
     */

    /** Snmp V3 MessageVesion̈ʒu */
    public static final int POS_MSG_VERSION_OF_MESSAGE = 0;

    /** MessageHeader̈ʒu */
    public static final int POS_HEADER_OF_MESSAGE = 1;

    /** MessageSecurity Params̈ʒu */
    public static final int POS_SECURITY_PARA_MESSAGE = 2;

    /** MessageSecurity Params̈ʒu */
    public static final int POS_SCOPED_PDU_DATA = 3;

    /** HeaderɂmsgVersionʒu */
    public static final int HEADER_MSG_VERSION = 0;

    /** HeaderɂmsgIDʒu */
    public static final int HEADER_MSG_ID = 0;

    /** HeaderɂmsgMaxSizeʒu */
    public static final int HEADER_MSG_MAXSIZE = 1;

    /** HeaderɂmsgFlagsʒu */
    public static final int HEADER_MSG_FLAGS = 2;

    /** HeaderɂmsgSecModelʒu */
    public static final int HEADER_MSG_SEC_MODEL = 3;

    /**
     * Security ParamsɂmsgAuthoritativeEngineIDʒu
     */
    public static final int SECURITY_PARAMS_MSG_AUTH_ENGINEID = 0;

    /** Security ParamsɂmsgAuthEngineBootsʒu */
    public static final int SECURITY_PARAMS_MSG_AUTH_ENGINEBOOTS = 1;

    /** Security ParamsɂmsgAuthEngineTimeʒu */
    public static final int SECURITY_PARAMS_MSG_AUTH_ENGINETIME = 2;

    /** Security ParamsɂmsgUserNameʒu */
    public static final int SECURITY_PARAMS_MSG_USERNAME = 3;

    /** Security ParamsɂmsgAuthenticationParametersʒu */
    public static final int SECURITY_PARAMS_MSG_AUTH_PARAMS = 4;

    /** Security ParamsɂmsgPrivacyParametersʒu */
    public static final int SECURITY_PARAMS_MSG_PRIV_PARAMS = 5;

    /** Scoped PDUɂContext EngineIDʒu */
    public static final int SCOPED_PDU_CONTEXT_ENGINEID = 0;

    /** Scoped PDUɂContext Nameʒu */
    public static final int SCOPED_PDU_CONTEXT_NAME = 1;

    /** Scoped PDUɂPDU Dataʒu */
    public static final int SCOPED_PDU_PDU_DATA = 2;
}
