/*
 * Created on 2004/04/19
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 * m[hIPAhXL[ƂāAA[Mapɕێ
 * NXłB
 * m[hɈȑOA[ԂێĂA퓮
 * mFɕێĂA[݂ꍇɃA[
 * ܂B
 *
 *                        IP Address Key                    Alarm ID Key
 * AlarmRecovery ĩNXj---------------- AlarmRecoveryIP ---------------- A[
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AlarmRecovery {
    /*
     * IPAhXL[ƂIPAhXΏۂŔA[
     * ێ
     */
    private static Map<String, AlarmRecoveryIP> nodeIPAlarmMap =
        Collections.synchronizedMap(new HashMap<String, AlarmRecoveryIP>());

    /*
     * A[`FbNNXCX^X𐶐܂B
     */
    private AlarmRecovery() {
    }

    /**
     * m[ho^ɌĂ΂āAMapɃm[hIPAhXL[Ƃ
     * A[MapɊi[܂B
     *
     * @param ipAddress m[hIPAhX
     */
    public synchronized void setArarmrecoveryCheck(final String ipAddress) {
        nodeIPAlarmMap.put(ipAddress, new AlarmRecoveryIP());
    }

    /**
     * A[ɌĂ΂MapIPAhXMapɃA[
     * i[܂B
     *
     * @param ipAddress m[hIPAhX
     * @param alarmCodeInfo A[R[h
     */
    public synchronized void putAlarmRecoveryInoformation(
        final String ipAddress, final AlarmCodeInformation alarmCodeInfo) {
        /* m[hIPAhXL[ƂAlarm񒊏o */
        AlarmRecoveryIP recoveryIpInfo =
            (AlarmRecoveryIP) nodeIPAlarmMap.get(ipAddress);

        /* m[hIPAhXL[ƂMapɃA[i[ */
        if (recoveryIpInfo != null) {
            recoveryIpInfo.putAlarmInfo(alarmCodeInfo.getId(), alarmCodeInfo);
            nodeIPAlarmMap.put(ipAddress, recoveryIpInfo);
        }
    }

    /**
     * m[hĎɂ`FbNʂȏꍇɌĂ΂܂B
     * wm[hIPAhX̎wA[IDȑOɔĂ
     * `FbN܂B
     * EȑOɎwA[IDĂȂꍇtrue
     * EȑOɎwA[IDĂꍇfalse
     *
     * @param ipAddress m[hIPAhX
     * @param alarmid ȑOɔmFA[ID
     * @return wIPAhXŎw̃A[IDĂꍇtrue
     * ŁAĂȂꍇɂgalse
     */
    public synchronized boolean isOccurredAlarmId(
        final String ipAddress, final String alarmid) {
        AlarmRecoveryIP recoveryIPAddressInfo =
            (AlarmRecoveryIP) nodeIPAlarmMap.get(ipAddress);

        if (recoveryIPAddressInfo != null) {
            AlarmCodeInformation alarmCodeInfo =
                recoveryIPAddressInfo.getAlarmInfo(alarmid);

            if (alarmCodeInfo != null) {
                /*
                     * ȑOɔĂA[ID̏ꍇAƂ
                     * YA[ID폜AtrueԂ
                     */
                this.delete(ipAddress, alarmid);

                return true;
            }
        }

        /* wm[hł̎wA[ID͈ȑOɔĂȂ */
        return false;
    }

    /**
     * wm[hIPAhX̎wA[IDMap폜܂B
     * AlarmɂĂ΂܂B
     *
     * @param ipAddress m[hIPAhX
     * @param alarmId A[ID
     */
    private synchronized void delete(
        final String ipAddress, final String alarmId) {
        AlarmRecoveryIP recoveryIpInfo =
            (AlarmRecoveryIP) nodeIPAlarmMap.get(ipAddress);

        if (recoveryIpInfo != null) {
            recoveryIpInfo.delete(alarmId);
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNgԂ
     * ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static AlarmRecovery getInstance() {
        return SingletonMessage.INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonMessage {
        static final AlarmRecovery INSTANCE = new AlarmRecovery();
    }
}
