/*
 * Created on 2004/04/28
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;


/**
 * m[hNe[u𑀍삷郁\bh܂B
 * m[hԂ̃N̃EƂAn_ƏI_̃m[hIPAhX
 * eJɋLq܂B
 *
 * exp.
 * node0address | node1address
 * -------------+--------------
 *    10.0.0.1  | 192.168.0.1
 *    10.0.0.1  | 192.168.0.2
 * 192.168.0.1  | 192.168.0.3
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DBTableMapLink extends DBTableBase {
    /** m[hMap Linke[u */
    public static final String NODE_MAPLINK_TABLE = "nodeMapLink_table";

    /** m[hMap Link ID J */
    public static final String NODE_MAPLINK_ID = "id";

    /** m[hMap Link X_J */
    public static final String NODE_X_ADDRESS = "node0address";

    /** m[hMap Link Y_J */
    public static final String NODE_Y_ADDRESS = "node1address";

    /* MO */
    private static Logger logger = null;

    /**
     * f[^x[X̃m[hMappNi[e[u𐧌䂷
     * CX^X𐶐܂B
     *
     */
    public DBTableMapLink() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * MapLinke[u
     *
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        AbstractDataAccessObject dataaccessobject =
            DatabaseAccessControlKind.getInstance().getDataAccessObject();

        try {
            databaseAccess.executeUpdate(
                dataaccessobject.getDropNodeMapLinkTableSQL());
        } catch (SQLException e) {
            logger.info(
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                + " : " + e.getMessage());
        }

        /* V[PXe[u폜 */
        try {
            this.dropSequence(
                databaseAccess,
                dataaccessobject.getDropNodeMapLinkTableSequenceSQL());

            // f[^x[XEe[u쐬
            databaseAccess.executeUpdate(
                dataaccessobject.getCreateNodeMapLinkTableSQL());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * MapLinke[u폜܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            AbstractDataAccessObject dataaccessobject =
                DatabaseAccessControlKind.getInstance().getDataAccessObject();
            databaseAccess.executeUpdate(
                dataaccessobject.getDropNodeMapLinkTableSQL());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * m[hMapLinkXV܂B
     *
     * @param nodMapLinkInfo m[hMap Link
     * @param isDeleteLinkData f[^폜邩̃tO
     * @return XV
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public boolean updateNodeMapLink(
        final NodeMapLinkInformation nodMapLinkInfo, boolean isDeleteLinkData)
        throws SQLException, DatabaseConnectionException {
        boolean isSuccess = false;

        /*
         * XVɂẮAe[ȗSẴf[^U폜
         * ɁAf[^e[uɕtB
         * ́AXVׂA폜ׂAVɕtׂ
         * ̔foȂ߁B
         */
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            ArrayList mapLinkIDList = null;

            String sql = "SELECT * from " + NODE_MAPLINK_TABLE;

            // SQLXe[ggIuWFNg̍쐬
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();

            // m[hMap LinkID𒊏oAListɊi[
            rs = stmt.executeQuery(sql);
            mapLinkIDList = new ArrayList();

            while (rs.next()) {
                mapLinkIDList.add(rs.getObject(NODE_MAPLINK_ID).toString());
            }

            SystemResourceFileParse resourceset =
                (SystemResourceConfig.getInstance()).getResourceFileParse();
            String databaseKind =
                resourceset.getResourceInfo().getDatabaseName();

            if (isDeleteLinkData) {
                /*
                 * oMap Link IDf[^U폜
                 */
                for (int i = 0; i < mapLinkIDList.size(); i++) {
                    if (
                        databaseKind.equals(AbstractDataAccessObject.DERBY)
                            || databaseKind.equals(
                                AbstractDataAccessObject.EMBEDDED_DERBY)) {
                        sql = "DELETE from " + NODE_MAPLINK_TABLE + " where "
                            + NODE_MAPLINK_ID + " = " + mapLinkIDList.get(i);
                    } else {
                        sql = "DELETE from " + NODE_MAPLINK_TABLE + " where "
                            + NODE_MAPLINK_ID + " = '" + mapLinkIDList.get(i)
                            + "'";
                    }

                    // 폜Select̎s
                    stmt.execute(sql);
                }
            }

            /*
             * f[^U폜ɁAm[hMapLinkt
             */
            ArrayList node0AddressList = nodMapLinkInfo.getNode0address();
            ArrayList node1AddressList = nodMapLinkInfo.getNode1address();

            for (int i = 0; i < node0AddressList.size(); i++) {
                //sql̍쐬
                sql = "INSERT INTO " + NODE_MAPLINK_TABLE + "( "
                    + NODE_X_ADDRESS + "," + NODE_Y_ADDRESS + " )"
                    + "VALUES ( '" + (String) node0AddressList.get(i) + "','"
                    + (String) node1AddressList.get(i) + "' )";

                stmt.executeUpdate(sql);
            }

            // stmt.executeUpdate(AbstractDataAccessObject.COMMIT);
            isSuccess = true;
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }

            dataaccess = null;
        }

        return isSuccess;
    }

    /**
     * m[hMapLinkԂ܂B
     *
     * @return nodeMapLinkInfo m[hMap Link
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public NodeMapLinkInformation findAll()
        throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        ArrayList nodeMapLink0List = new ArrayList();
        ArrayList nodeMapLink1List = new ArrayList();

        try {
            //sql̍쐬
            String sql = "SELECT * from " + NODE_MAPLINK_TABLE;

            // select̎s
            conn = dataaccess.getConnection();

            // SQLXe[ggIuWFNg̍쐬
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            while (rs.next()) {
                /* LinkXɈʒum[hAhX擾 */
                String nodeX = (String) rs.getObject(NODE_X_ADDRESS);

                if ((nodeX == null) || nodeX.equals("")) {
                    nodeX = "0";
                }

                nodeMapLink0List.add(nodeX);

                /* LinkYɈʒum[hAhX擾 */
                String nodeY = (String) rs.getObject(NODE_Y_ADDRESS);

                if ((nodeY == null) || nodeY.equals("")) {
                    nodeY = "0";
                }

                nodeMapLink1List.add(nodeY);
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }

            dataaccess = null;
        }

        NodeMapLinkInformation nodeMapLinkInfo = new NodeMapLinkInformation();
        nodeMapLinkInfo.setNode0address(nodeMapLink0List);
        nodeMapLinkInfo.setNode1address(nodeMapLink1List);

        return nodeMapLinkInfo;
    }

    /**
     * wm[h̃N폜܂B
     * LinkƂāAwm[hAhXX܂YɋLqĂ
     * Link񂷂ׂĂ폜܂B
     *
     * @param ipaddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void deleteNode(String ipaddress)
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            //sql̍쐬
            String sql;

            sql = "DELETE from " + NODE_MAPLINK_TABLE + " where "
                + NODE_X_ADDRESS + "=" + "'" + ipaddress + "'";

            // select̎s
            databaseAccess.executeUpdate(sql);

            sql = "DELETE from " + NODE_MAPLINK_TABLE + " where "
                + NODE_Y_ADDRESS + "=" + "'" + ipaddress + "'";

            // select̎s
            databaseAccess.executeUpdate(sql);
            logger.info("Node Map Link Delete IP=" + ipaddress);
        } catch (DatabaseConnectionException ex) {
            ex.printStackTrace();
            throw ex;
        } catch (SQLException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
            throw ex;
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
                databaseAccess = null;
            }
        }
    }
}
