/*
 * Created on 2004/04/27
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.control;

import java.util.logging.Logger;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.ResourceInfo;


/**
 * f[^x[XʂɑΉDataAccessObject𐶐
 * VOgNXłB
 * \[Xt@C̃f[^x[XݒɑΉf[^x[X
 * ʖDataAccessObjectݒ肵܂B
 * f[^ANZXIuWFNgɈȉ̏ݒ肵܂B
 *
 * JDBC Driver
 * URL
 * User
 * Password
 *
 * ܂AΉf[^x[Xʂ͈ȉłB
 * EHSQLDB
 * EMySQL
 * EPostgreSQL
 * EOracle
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DatabaseAccessControlKind {
    // Web̃f[^x[XIuWFNg擾ł̓\[Xݒ肳
    private static ResourceInfo resourceInfo = null;

    // MO
    private static Logger logger = null;

    // f[^x[XIuWFNg
    private AbstractDataAccessObject databaseAccessObject;

    // f[^x[X
    private String databaseName;

    /**
     * f[^x[XʂɑΉCX^Xݒ肵܂B
     *
     */
    private DatabaseAccessControlKind() {
        logger = Logger.getLogger(this.getClass().getName());
        setDatabaseKindControl();
    }

    /**
     *
     *
     */
    public void updateDatabaseKindControl() {
        SystemResourceFileParse resourceset =
            (SystemResourceConfig.getInstance()).getResourceFileParse();
        resourceInfo = resourceset.getResourceInfo();
        setDatabaseKindControl();
    }

    /*
     *
     */
    private void setDatabaseKindControl() {
        // Web̏ꍇ̓\[Xݒ肳Ă
        if (resourceInfo == null) {
            //@\[Xt@Cf[^x[X擾
            SystemResourceFileParse resourceset =
                (SystemResourceConfig.getInstance()).getResourceFileParse();
            resourceInfo = resourceset.getResourceInfo();
        }

        String kind = resourceInfo.getDatabaseName();
        databaseName = kind;

        // f[^x[XɑΉf[^ANZXIuWFNg𐶐
        if (kind.equals(AbstractDataAccessObject.HSQLDB)) {
            databaseAccessObject = new DataAccessObjectHSQLDB();
        } else if (
            kind.equals(AbstractDataAccessObject.DERBY)
                || kind.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
            databaseAccessObject = new DataAccessObjectApacheDerby();
        } else if (kind.equals(AbstractDataAccessObject.MYSQL)) {
            databaseAccessObject = new DataAccessObjectMySQL();
        } else if (kind.equals(AbstractDataAccessObject.POSTGRESQL)) {
            databaseAccessObject = new DataAccessObjectPostgreSQL();
        } else if (kind.equals(AbstractDataAccessObject.ORACLE)) {
            databaseAccessObject = new DataAccessObjectOracle();
        } else if (kind.equals(AbstractDataAccessObject.AXION)) {
            databaseAccessObject = new DataAccessObjectAxion();
        } else {
            logger.warning("Database Nosuport : " + kind);
        }

        logger.info("Database Kind : " + kind);

        // f[^ANZXIuWFNg̃vpeBݒ
        databaseAccessObject.setDriver(resourceInfo.getDatabaseDriver());
        databaseAccessObject.setDatabaseurl(resourceInfo.getDatabaseUrl());
        databaseAccessObject.setUser(resourceInfo.getDatabaseUser());
        databaseAccessObject.setPassword(resourceInfo.getDatabasePassword());
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static DatabaseAccessControlKind getInstance() {
        return SingletonAboutMessage.DBKIND;
    }

    /**
     * Webł̃f[^x[Xʂ̓GW̃\[XƂ邽߂ɁA\[XZbg
     *
     * @param setResourceInfo \[X
     */
    public static void setResource(final ResourceInfo setResourceInfo) {
        resourceInfo = setResourceInfo;
    }

    /**
     * f[^x[XANZXIuWFNgԂ܂B
     *
     * @return databaseAccessObject f[^x[XANZXIuWFNg
     */
    public AbstractDataAccessObject getDataAccessObject() {
        return databaseAccessObject;
    }

    /**
     * f[^x[XԂ܂B
     *
     * @return databaseName f[^x[X
     */
    public String getDatabaseName() {
        return databaseName;
    }

    /**
     * \[XԂ܂B
     *
     * @return resourceInfo \[X
     */
    public static ResourceInfo getResourceInfo() {
        return resourceInfo;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final DatabaseAccessControlKind DBKIND =
            new DatabaseAccessControlKind();
    }
}
