/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.application;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.hsqldb.HsqldbControl;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.IActionBarConfigurer;

/**
 * j[𐶐NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class NetJFWatcherMenuManager {

	private ActionBuilderPerspective perspectiveAction = new ActionBuilderPerspective();

	/* MO */
	private static Logger logger;

	/*
	 * j[NXCX^X𐶐܂B
	 */
	private NetJFWatcherMenuManager() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * j[o[\z܂B
	 * 
	 * @param window
	 *            IWorkbenchWindow
	 * @param configurer
	 *            IActionBarConfigurer
	 */
	public void fillMenuBar(IWorkbenchWindow window,
			IActionBarConfigurer configurer) {
		IMenuManager menuBar = configurer.getMenuManager();
		menuBar.add(createFileMenu(window));
		menuBar.add(createWindowMenu(window));
		menuBar.add(createAlarmMenu(window));
		menuBar.add(createPortMenu(window));
		menuBar.add(createMacAddressMenu(window));
		menuBar.add(createSyslogNGMenu(window));
		menuBar.add(createJettyMenu(window));
		menuBar.add(createSSH2Menu(window));
		menuBar.add(createProvisionMenu(window));
		menuBar.add(createJMXMenu(window));
		menuBar.add(createWebalizerMenu(window));
		menuBar.add(createHelpMenu(window));
	}

	/*
	 * Filej[𐶐܂B
	 * 
	 * @param window IWorkbenchWindow @return menu MenuManager
	 */
	private MenuManager createFileMenu(IWorkbenchWindow window) {
		// Filej[́uIv`
		MenuManager menu = new MenuManager(Messages
				.getString("NetJFWatcherMenuManager.0"),
				IWorkbenchActionConstants.M_FILE); //$NON-NLS-1$

		menu.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		menu.add(new Separator());
		menu.add(ActionFactory.QUIT.create(window));

		// ToolBarContributionItem.SHOW_ALL_add(preView);
		// menu.add(preView);
		// IToolBarManager toolBarManager =
		// window.getShell().getgetActionBars().getToolBarManager();
		// tB[hēǍANV
		// toolBarManager.add(preView);
		return menu;
	}

	/*
	 * Windowj[𐶐܂B
	 * 
	 * @param window @return
	 */
	private MenuManager createWindowMenu(IWorkbenchWindow window) {
		/* Windowj[ */
		MenuManager menuManager = new MenuManager(Messages
				.getString("NetJFWatcherMenuManager.1"),
				IWorkbenchActionConstants.M_WINDOW); //$NON-NLS-1$

		/* Perspectivej[ */
		MenuManager perspectiveMenu = new MenuManager(Messages
				.getString("NetJFWatcherMenuManager.2"), Messages
				.getString("NetJFWatcherMenuManager.3")); //$NON-NLS-1$ //$NON-NLS-2$

		perspectiveMenu.add(perspectiveAction.getActionSnmpBrowser());
		perspectiveMenu.add(perspectiveAction.getActionSnmpAgent());
		perspectiveMenu.add(perspectiveAction.getActionNetworkWatch());
		perspectiveMenu.add(perspectiveAction.getActionNodeManager());
		perspectiveMenu.add(perspectiveAction.getActionEngineManager());
		perspectiveMenu.add(perspectiveAction.getActionNodeMapDraw());
		perspectiveMenu.add(perspectiveAction.getActionSocketClient());

		IContributionItem perspectiveList = ContributionItemFactory.PERSPECTIVES_SHORTLIST
				.create(window);
		perspectiveMenu.add(perspectiveList);

		// perspectiveMenu.add(ActionFactory.OPEN_PERSPECTIVE_DIALOG.create(window));
		menuManager.add(perspectiveMenu);

		/* Show Viewj[ */
		menuManager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));

		MenuManager showViewMenu = new MenuManager(Messages
				.getString("NetJFWatcherMenuManager.4")); //$NON-NLS-1$
		IContributionItem viewList = ContributionItemFactory.VIEWS_SHORTLIST
				.create(window);
		showViewMenu.add(viewList);
		menuManager.add(showViewMenu);

		/* Preferencej[ */
		menuManager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
		menuManager.add(ActionFactory.PREFERENCES.create(window));
		menuManager.add(ContributionItemFactory.OPEN_WINDOWS.create(window));

		return menuManager;
	}

	/*
	 * Alarmj[𐶐܂B
	 * 
	 * @param window @return
	 */
	private MenuManager createAlarmMenu(IWorkbenchWindow window) {
		/* Alarmj[ */
		MenuManager menuManager = new MenuManager("Alarm",
				"alarmMenu"); //$NON-NLS-1$
		return menuManager;
	}
	
	/*
	 * Portj[𐶐܂B
	 * 
	 * @param window @return
	 */
	private MenuManager createPortMenu(IWorkbenchWindow window) {
		/* syslog-ngj[ */
		MenuManager menuManager = new MenuManager("Port",
				"portMenu"); //$NON-NLS-1$
		return menuManager;
	}
	
	/*
	 * Mac Addressj[𐶐܂B
	 * 
	 * @param window @return
	 */
	private MenuManager createMacAddressMenu(IWorkbenchWindow window) {
		/* Mac Addressj[ */
		MenuManager menuManager = new MenuManager("MAC Address",
				"ifMacMenu"); //$NON-NLS-1$
		return menuManager;
	}
	
	/*
	 * syslog-ngj[𐶐܂B
	 * 
	 * @param window @return
	 */
	private MenuManager createSyslogNGMenu(IWorkbenchWindow window) {
		/* syslog-ngj[ */
		MenuManager menuManager = new MenuManager("Syslog-NG",
				"syslogMenu"); //$NON-NLS-1$
		return menuManager;
	}
	
	/*
	 * Jettyj[𐶐܂B
	 * 
	 * @param window
	 * @return
	 */
	private MenuManager createJettyMenu(IWorkbenchWindow window) {
		/* Jettyj[ */
		MenuManager menuManager = new MenuManager("Jetty",
				"jettyMenu");
		return menuManager;
	}
	
	/*
	 * SSH2j[𐶐܂B
	 * 
	 * @param window
	 * @return
	 */
	private MenuManager createSSH2Menu(IWorkbenchWindow window) {
		/* Jettyj[ */
		MenuManager menuManager = new MenuManager("SSH2",
				"ssh2Menu");
		return menuManager;
	}
	
	/*
	 * Provisionj[𐶐܂B
	 * 
	 * @param window
	 * @return
	 */
	private MenuManager createProvisionMenu(IWorkbenchWindow window) {
		/* Jettyj[ */
		MenuManager menuManager = new MenuManager("Provision",
				"provisionMenu");
		return menuManager;
	}
	
	/*
	 * JMXj[𐶐܂B
	 * 
	 * @param window
	 * @return
	 */
	private MenuManager createJMXMenu(IWorkbenchWindow window) {
		/* Jettyj[ */
		MenuManager menuManager = new MenuManager("JMX",
				"JMXMenu");
		return menuManager;
	}
	
	
	/*
	 * Webalizerj[𐶐܂B
	 * 
	 * @param window
	 * @return
	 */
	private MenuManager createWebalizerMenu(IWorkbenchWindow window) {
		/* Jettyj[ */
		MenuManager menuManager = new MenuManager("WebLogAnalyze",
				"webalizerMenu");
		return menuManager;
	}
	
	/*
	 * Helpj[𐶐܂B
	 * 
	 * @param window IWorkbenchWindow @return menu MenuManager
	 */
	private MenuManager createHelpMenu(IWorkbenchWindow window) {
		MenuManager menu = new MenuManager(
				"Help", IWorkbenchActionConstants.M_HELP); //$NON-NLS-1$

		// Welcome or intro page would go here
		menu.add(ActionFactory.HELP_CONTENTS.create(window));

		// Tips and tricks page would go here
		menu.add(new GroupMarker(IWorkbenchActionConstants.HELP_START));
		menu.add(new GroupMarker(IWorkbenchActionConstants.HELP_END));
		menu.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		// About should always be at the bottom
		// To use the real RCP About dialog uncomment these lines
		menu.add(new Separator());
		menu.add(ActionFactory.ABOUT.create(window));

		return menu;
	}

	/**
	 * HSQLDBT[oNłShutdown܂B
	 * 
	 */
	public void stopHsqlDB() {
		/*
		 * [Nx`IɂāAHSQLDBT[oN Shutdown
		 */
		try {
			/* HSQLDB}l[W~ */
			HsqldbControl.getInstance().stopHsqlDBManager();

			/* HSQLDB~ */
			HsqldbControl.getInstance().stopHsqlDB();
		} catch (ClassNotFoundException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		} catch (SQLException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static NetJFWatcherMenuManager getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final NetJFWatcherMenuManager RESOURCE = new NetJFWatcherMenuManager();
	}
}
