/*
 * Created on 2007/03/12
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.nodemaneger.map.NodeMapInfo;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeAlarm;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeConfig;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeOperation;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeSnmp;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeSnmpStatisticsSet;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeControl;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.ConnectionNodeMapLink;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.ping.NodePingMenu;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/**
 * m[hMap ViewCanvasPopUpj[NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapDrawViewPopUpMenuSocket extends NodeMapDrawViewPopUpMenu {
	/* MO */
	private static Logger logger;

	/**
	 * m[hMap ViewCanvasPopUpj[NXCX^X ܂A
	 * 
	 * @param display
	 *            Display
	 * @param canvas
	 *            Canvas
	 * @param mapDraw
	 *            m[hMap`NXCX^X
	 * @param mouseListener
	 *            }EXXi[NXCX^X
	 * @param statusLineManager
	 *            Xe[^XC}l[W
	 */
	public NodeMapDrawViewPopUpMenuSocket(Display display, Canvas canvas,
			NodeMapDrawViewDraw mapDraw,
			NodeMapDrawViewMouseListener mouseListener,
			SubStatusLineManager statusLineManager) {
		super(display, canvas, mapDraw, mouseListener, statusLineManager);
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * Popupj[Zbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void setPopUpMenu(Composite parent) {

		/* popUpj[Zbg */
		popUpMenu = new Menu(parent.getShell(), SWT.POP_UP);
		canvas.setMenu(popUpMenu);

		MenuItem menuItemLoad = new MenuItem(popUpMenu, SWT.PUSH);
		menuItemLoad.setText(LOAD_MENU);

		menuItemLoad.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				loadNodeMap();
			}
		});

		/*
		 * m[hMap Save
		 */
		MenuItem menuItemSave = new MenuItem(popUpMenu, SWT.PUSH);
		menuItemSave.setText(SAVE_MENU);

		/*
		 * m[hMap popupj[łSaveI
		 */
		menuItemSave.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				String engineAddress = ClientEngineInfo
						.getClientEngineInfoInstance().getEngineAddress();

				for (int i = 0; i < nodeMapNodeInfoList.size(); i++) {
					NodeMapInfo nodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList
							.get(i);
					NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();

					ConnectionNodeControl threadstop = new ConnectionNodeControl(
							engineAddress);

					try {
						threadstop
								.requestThread(
										nodeInfo.getIpaddress(),
										CommandMappingTableResource.THREAD_RESTART_COMMAND_ID,
										nodeInfo);
					} catch (EngineConnectException e1) {
						Shell shell = new Shell();
						MessageDialog.openError(shell,
								"Node List import error", e1.getMessage());
						logger.warning("Node List import error"
								+ e1.getMessage());
						shell.dispose();
						e1.printStackTrace();
					} catch (IOException e1) {
						Shell shell = new Shell();
						MessageDialog.openError(shell,
								"Node List import error", e1.getMessage());
						logger.warning("Node List import error"
								+ e1.getMessage());
						shell.dispose();
						e1.printStackTrace();
					}
				}

				if (nodMapLinkInformationList == null) {
					return;
				}

				ConnectionNodeMapLink connectNodeInfo = new ConnectionNodeMapLink(
						engineAddress);

				try {
					nodMapLinkInformationList = connectNodeInfo
							.updateNodeMapInformation(nodMapLinkInformationList);
				} catch (EngineConnectException e1) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Node List import error", e1
							.getMessage());
					logger.warning("Node List import error" + e1.getMessage());
					shell.dispose();
					e1.printStackTrace();
				} catch (IOException e1) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Node List import error", e1
							.getMessage());
					logger.warning("Node List import error" + e1.getMessage());
					shell.dispose();
					e1.printStackTrace();
				}
			}
		});

		/*
		 * Linkj[
		 */
		MenuItem menuItemLink = new MenuItem(popUpMenu, SWT.CHECK);
		menuItemLink.setText(LINK_MENU);

		if (mouseListener.isLineSelected()) {
			menuItemLink.setSelection(true);
		} else {
			menuItemLink.setSelection(false);
		}

		/*
		 * Linkj[I
		 */
		menuItemLink.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				/*
				 * LinktO(Link`惂[hm[hIconړ [h)𔽓]
				 */
				if (mouseListener.isLineSelected()) {
					mouseListener.setLineSelected(false);
				} else {
					mouseListener.setLineSelected(true);
				}
			}
		});
	}

	/**
	 * m[hʃj[ƂāAm[hIPopupj[ m[hIj[ǉ܂B
	 * 
	 * @param nodeI
	 *            m[hĎ
	 */
	protected void setNodeMenu(final NodeInformation nodeI, boolean isNodeMenu) {
		if (isNodeMenu) {
			nodeViewMenuItem = new MenuItem(popUpMenu, SWT.PUSH);
			nodeViewMenuItem.setText(MenuPreference.NODE_CONFIG_VIEW);

			NodeMapMenuNodeConfig nodeConfig = new NodeMapMenuNodeConfig(nodeI,
					true);
			nodeViewMenuItem.addSelectionListener(nodeConfig);

			nodeAlarmMenuItem = new MenuItem(popUpMenu, SWT.PUSH);
			nodeAlarmMenuItem.setText(MenuPreference.NODE_ALARM_VIEW);

			NodeMapMenuNodeAlarm nodeAlarm = new NodeMapMenuNodeAlarm(nodeI,
					true);
			nodeAlarmMenuItem.addSelectionListener(nodeAlarm);

			nodeSnmpMenuItem = new MenuItem(popUpMenu, SWT.PUSH);
			nodeSnmpMenuItem.setText(MenuPreference.NODE_SNMP_VIEW);

			NodeMapMenuNodeSnmp nodeSnmp = new NodeMapMenuNodeSnmp(nodeI, true);
			nodeSnmpMenuItem.addSelectionListener(nodeSnmp);

			NodePingMenu menuPing = new NodePingMenu();
			menuPing.createPingMenu(popUpMenu, nodeI, true);

			NodeSnmpStatisticsMenu menuSnmpStatistics = new NodeSnmpStatisticsMenu();
			menuSnmpStatistics.createSnmpStatisticsMenu(popUpMenu, nodeI, true);

			nodeSnmpStatisticsSetMenuItem = new MenuItem(popUpMenu, SWT.PUSH);
			nodeSnmpStatisticsSetMenuItem
					.setText(MenuPreference.NODE_SNMP_STATISTICS_SET);

			NodeMapMenuNodeSnmpStatisticsSet nodeSnmpStatisticsSet = new NodeMapMenuNodeSnmpStatisticsSet(
					nodeI, true);
			nodeSnmpStatisticsSetMenuItem
					.addSelectionListener(nodeSnmpStatisticsSet);
		}
		/* m[h\`j[ */
		nodeViewMenuItem = new MenuItem(popUpMenu, SWT.PUSH);
		nodeViewMenuItem.setText(MenuPreference.NODE_OPERATION_VIEW);

		NodeMapMenuNodeOperation nodeOperaqtion = new NodeMapMenuNodeOperation(
				nodeI, false);
		nodeViewMenuItem.addSelectionListener(nodeOperaqtion);
	}

	/**
	 * m[hMap񃊃XgSocketoRŃGW擾܂B
	 * 
	 * @param isNodeInfo
	 *            m[hMap LinkSocketoRŃGW擾邩ۂtO
	 * @return nodeList m[hMap񃊃Xg
	 */
	protected ArrayList getNodeInfoListMapView(boolean isNodeInfo) {
		if (!isNodeInfo) {
			return new ArrayList();
		}

		ArrayList nodeList = null;
		String engineAddress = ClientEngineInfo.getClientEngineInfoInstance()
				.getEngineAddress();

		try {
			ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(
					engineAddress);
			nodeList = connectNodeInfo.getNodeInformationList(null, null);

			if (nodeList.size() == 0) {
				return nodeList;
			}
		} catch (EngineConnectException e) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e
					.getMessage()
					+ "Engine = " + engineAddress);
			logger.warning("Node List import error" + e.getMessage()
					+ "Engine = " + engineAddress);
			shell.dispose();
			e.printStackTrace();
		} catch (IOException e) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e
					.getMessage()
					+ "Engine = " + engineAddress);
			logger.warning("Node List import error" + e.getMessage()
					+ "Engine = " + engineAddress);
			shell.dispose();
			e.printStackTrace();
		}

		return nodeList;
	}

	/*
	 * m[hMap LinkSocketoRŃGW擾܂B
	 * 
	 * @param isNodeMap m[hMap LinkSocketoRŃGW擾邩ۂtO
	 */
	private void getNodeMapLink(boolean isNodeMap) {
		if (!isNodeMap) {
			return;
		}

		String engineAddress = ClientEngineInfo.getClientEngineInfoInstance()
				.getEngineAddress();

		try {
			ConnectionNodeMapLink connectNodeInfo = new ConnectionNodeMapLink(
					engineAddress);
			nodMapLinkInformationList = connectNodeInfo.getNodeMapInformation();
		} catch (EngineConnectException e) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e
					.getMessage()
					+ "Engine = " + engineAddress);
			logger.warning("Node List import error" + e.getMessage()
					+ "Engine = " + engineAddress);
			shell.dispose();
			e.printStackTrace();
		} catch (IOException e) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e
					.getMessage()
					+ "Engine = " + engineAddress);
			logger.warning("Node List import error" + e.getMessage()
					+ "Engine = " + engineAddress);
			shell.dispose();
			e.printStackTrace();
		}
	}

	/**
	 * m[hMap View[hĕ`悵܂B
	 * 
	 */
	public void loadNodeMap() {
		getNodeMapLink(true);

		ArrayList nodeList = getNodeInfoListMapView(true);
		createNodeMapInfo(nodeList);

		mapDraw.redraw(nodeMapNodeInfoList, nodMapLinkInformationList);

		setStatusLine();
	}
}
