/*
 * Created on 2007/03/12
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap.gui;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderNodeList;
import netjfwatcher.engine.model.action.EngineStatus;
import netjfwatcher.engine.view.canvas.CanvasViewConfigFileParse;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

/**
 * m[hMap\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapDrawView extends ViewPart {
	/* MO */
	private static Logger logger;

	/* Node Map View size */
	private int[] nodeMapViewSize = new int[2];

	/* zFColor` */
	private Color whiteColor = new Color(null, 255, 255, 255);

	/* zFColor` */
	private Color blackColor = new Color(null, 0, 0, 0);

	/* zFColor` */
	private Color redColor = new Color(null, 255, 0, 0);

	/* Display */
	private Display display;

	/* m[hMap View̃}EXXi[ */
	private NodeMapDrawViewMouseListener mouseListener;

	/* m[hMap Canvas */
	private Canvas canvas;

	/* GC */
	private GC gc;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/* 摜肷邽߂PluginResource bundle */
	private Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	/* m[hXgANV */
	private NodeListAction nodeListAction = new NodeListAction();

	/* EditorsPartɕ\ANV */
	private ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();

	/* A[ANV */
	private ActionBuilderAlarmList actionBuilderAlarm = new ActionBuilderAlarmList();

	/**
	 * m[hMap ViewNXCX^X𐶐܂B
	 * 
	 */
	public NodeMapDrawView() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(final Composite parent) {
		setCanvasSize();
		/*
		 * ColorIuWFNgjĂꍇ͍ăZbg
		 */
		if ((whiteColor == null) || whiteColor.isDisposed()) {
			whiteColor = new Color(null, 255, 255, 255);
		}

		if ((blackColor == null) || blackColor.isDisposed()) {
			blackColor = new Color(null, 0, 0, 0);
		}

		if ((redColor == null) || redColor.isDisposed()) {
			redColor = new Color(null, 255, 0, 0);
		}

		display = parent.getDisplay();
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, true);
		scrollComposite.setLayout(layout);

		canvas = new Canvas(scrollComposite, SWT.NULL);

		gc = new GC(canvas);

		scrollComposite.setBackground(whiteColor);
		gc.setBackground(scrollComposite.getBackground());
		scrollComposite.setContent(canvas);
		scrollComposite.setMinSize(nodeMapViewSize[0], nodeMapViewSize[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());

		mouseListener = new NodeMapDrawViewMouseListener(scrollComposite,
				display, parent, canvas, gc, statusLineManager, false);
		mouseListener.getPopMenu().setPopUpMenu(parent);

		canvas.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				mouseListener.redraw();
			}
		});
		scrollComposite.addMouseListener(mouseListener);

		// setPopUpMenu(parent);
		/*
		 * Canvas mouseXi[Zbg
		 */
		canvas.addMouseListener(mouseListener);

		/*
		 * m[hړ܂Link`揈
		 */
		canvas.addMouseMoveListener(mouseListener);

		setToolBarActions();
	}

	protected void setCanvasSize() {
		nodeMapViewSize[0] = CanvasViewConfigFileParse.getInstance()
				.getNodeMapWidth();
		nodeMapViewSize[1] = CanvasViewConfigFileParse.getInstance()
				.getNodeMapHeight();
	}

	/**
	 * ToolBarANV̏s܂B
	 * 
	 */
	protected void setToolBarActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		/* Node MapXVANV */
		toolBarManager.add(new ActionLoadNodeMapView());

		/* NodeĎImport */
		toolBarManager.add(nodeListAction.getActionImportNodeListFile());

		/* NodeĎExport */
		toolBarManager.add(nodeListAction.getActionExportNodeListFile());

		/* Sm[hAlarm\ANV */
		toolBarManager.add(actionBuilderAlarm
				.getActionShowAllNodeAlarmListTable());

		/* Editor part closeANV */
		toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (whiteColor != null) {
			whiteColor.dispose();
		}

		if (blackColor != null) {
			blackColor.dispose();
		}

		if (redColor != null) {
			redColor.dispose();
		}

		if (gc != null) {
			gc.dispose();
		}
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 * 
	 */
	public void setFocus() {
	}

	/*
	 * m[hListe[ũANV܂B
	 * 
	 * @author Yoshimasa Matsumoto
	 * 
	 * @version 1.0
	 */
	protected class NodeListAction extends ActionBuilderNodeList {
	}

	/**
	 * m[hMap View̃ANVۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public abstract class AbstractNodeMapAction extends Action {
		/**
		 * Node ListǂݍŃe[u\ANṼACR ImageDescriptorԂ܂B
		 * 
		 * @return Node ListǂݍŃe[u\ANV ̃ACRImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/reload.gif"));
		}

		/**
		 * Node ListǂݍŃe[u\ANVText Ԃ܂B
		 * 
		 * @return Node ListǂݍŃe[u\ANV Text
		 */
		public String getText() {
			return "Node Map Load";
		}

		/**
		 * Node ListǂݍŃe[u\ANVToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Node Map Load";
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.action.IAction#run()
		 */
		public final void run() {
			doTask();
		}

		/**
		 * ANVŎs^XNłB
		 * 
		 */
		protected abstract void doTask();
	}

	/**
	 * Node MapǂݍMap\ANVNXłB
	 */
	public class ActionLoadNodeMapView extends AbstractNodeMapAction {
		/**
		 * Node Map\XV܂B
		 * 
		 */
		protected void doTask() {
			mouseListener.getPopMenu().loadNodeMap();
		}
	}
}
