/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.socketclient;

import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractNodeTreeView;
import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderNetworkCamera;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderSnmp;
import netjfwatcher.engine.model.action.ListenerNodeListTree;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.ping.NodePingMenu;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;
import netjfwatcher.socketclient.ActionBuilderXMLSocket;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;

public class NetworkClientNodeTreeView
extends AbstractNodeTreeView {
    private static Logger logger = null;
    private NodeSnmpStatisticsMenu nodeSnmpStatisticsMenu = new NodeSnmpStatisticsMenu();
    private NodePingMenu nodePingMenu = new NodePingMenu();
    private static ActionBuilderXMLSocket xmlSocketAction = new ActionBuilderXMLSocket();
    private ActionBuilderNetworkCamera networkCameraAction = new ActionBuilderNetworkCamera();

    public NetworkClientNodeTreeView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void initShow() {
    }

    public void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NetworkClientNodeTreeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.nodeListTreeViewer.getControl());
        this.nodeListTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.nodeListTreeViewer);
    }

    protected void setToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.getActionNodeTreeBuilder().actionReloadNodeTreeSocket());
        toolBarManager.add(this.getActionNodeTreeBuilder().actionSortNodeTreeSocket());
        toolBarManager.add(this.actionBuilderNodeOperation.getActionNodeOperationSocket());
        toolBarManager.add(xmlSocketAction.getActionXMLSocketView());
        toolBarManager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.getActionNodeTreeBuilder().actionReloadNodeTreeSocket());
        manager.add(this.getActionNodeTreeBuilder().actionSortNodeTreeSocket());
        if (this.nodeListTreeViewer.getTree().getSelection() != null) {
            TreeItem[] treeItem = this.nodeListTreeViewer.getTree().getSelection();
            if (treeItem != null && treeItem.length > 0) {
                int nodeTreeSelectNo = 0;
                while (nodeTreeSelectNo < treeItem.length) {
                    if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTreeGroup) {
                        this.nodeListTreeViewer.getTree().deselectAll();
                    } else if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTree) {
                        NodeInformation targetNodeInfo = ((NodeTree)treeItem[nodeTreeSelectNo].getData()).getNodeInfo();
                        ((ActionBuilderNodeOperation.ActionShowNodeViewSocket)this.actionBuilderNodeOperation.getActionShowNodeViewSocket()).setNodeInfo(targetNodeInfo);
                        manager.add(this.actionBuilderNodeOperation.getActionShowNodeViewSocket());
                        ((ActionBuilderAlarmList.ActionOpenEditorPartPersonalNodeAlarmSocket)this.actinAlarm.getActionOpenEditorPartPersonalNodeAlarmSocket()).setNodeInfo(targetNodeInfo);
                        manager.add(this.actinAlarm.getActionOpenEditorPartPersonalNodeAlarmSocket());
                        ((ActionBuilderSnmp.ActionShowNodeSnmpViewSocket)this.snmpAction.getActionSnmpInfoSocket()).setNodeInfo(targetNodeInfo);
                        manager.add(this.snmpAction.getActionSnmpInfoSocket());
                        ((ActionBuilderNodeOperation.ActionNodeOperationSocket)this.actionBuilderNodeOperation.getActionNodeOperationSocket()).setNodeInfo(targetNodeInfo);
                        manager.add(this.actionBuilderNodeOperation.getActionNodeOperationSocket());
                        this.nodePingMenu.createPingMenu(manager, targetNodeInfo, true);
                        this.nodeSnmpStatisticsMenu.createSnmpStatisticsMenu(manager, targetNodeInfo, true);
                        ((ActionBuilderSnmp.ActionSnmpStatisticsSetSocket)this.snmpAction.getActionSnmpStatisticsSetSocket()).setNodeInfo(targetNodeInfo);
                        manager.add(this.snmpAction.getActionSnmpStatisticsSetSocket());
                        if (targetNodeInfo.getNodeKind().equals("Printer")) {
                            ((ActionBuilderSnmp.ActionSnmpPrintSocket)this.snmpAction.getActionPrintSnmpSocket()).setNodeInfo(targetNodeInfo);
                            manager.add(this.snmpAction.getActionPrintSnmpSocket());
                        }
                        if (targetNodeInfo.getNodeKind().equals("Camera")) {
                            ((ActionBuilderNetworkCamera.ActionNetworkCameraSocket)this.networkCameraAction.getActionNetworkCameraSocket()).setNodeInfo(targetNodeInfo);
                            manager.add(this.networkCameraAction.getActionNetworkCameraSocket());
                        }
                    } else {
                        this.nodeListTreeViewer.getTree().deselectAll();
                    }
                    ++nodeTreeSelectNo;
                }
            } else {
                manager.add(this.actionBuilderNodeOperation.getActionNodeOperationSocket());
            }
        }
        manager.add(this.snmpAction.getActionSnmpStatisticsSocket());
        manager.add(this.actinAlarm.getActionShowAllNodeAlarmListTableSocket());
        manager.add(xmlSocketAction.getActionXMLSocketView());
    }

    protected void setupNodeTreeViewListener() {
        this.nodeListTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new ListenerNodeListTree(true));
    }

    public static final String getTitleSuffixEngineAddress() {
        String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
        return " (Engine=" + engineAddress + ")";
    }
}

