/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.model;

import java.io.File;
import java.security.AccessControlException;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;

public class FileChooser {
    public static final String CSVFILE_INPUT = "CSV File Input Select";
    public static final String CSVFILE_OUTPUT = "CSV File Output Select";
    public static final String XMLFILE_INPUT = "XML File Input Select";
    public static final String XMLFILE_OUTPUT = "XML File Output Select";
    public static final String TITLE_DATABASA_SELECT = "Database File Select";
    public static final String NEW_DATABASA_SELECT = "New Database File Select";
    public static final String[][] FILE_CHOOSER = new String[][]{{".csv", "CSV\u30d5\u30a1\u30a4\u30eb(*.csv)", "*.csv"}, {".xml", "XML\u30d5\u30a1\u30a4\u30eb(*.xml)", "*.xml"}};
    public static final int CSV_FILE = 0;
    public static final int XML_FILE = 1;
    public static final int FILE_FILTER_EXTENSION = 0;
    public static final int FILE_FILTER_DESCRIPTION = 1;
    public static final int SELECTED_FILE = 2;
    private static Logger logger;
    private String title;

    public FileChooser() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public String getChooserFile(String dialogTitle, String[] fileExtension) {
        JLabel fileChooserDialogLabel;
        int fileChooserDialogReturn;
        JFileChooser fileChooser = null;
        String selectedFileName = null;
        this.title = dialogTitle == null ? TITLE_DATABASA_SELECT : dialogTitle;
        try {
            fileChooser = new JFileChooser(".");
        }
        catch (AccessControlException accessControlException) {
            return selectedFileName;
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle(this.title);
        if (fileExtension != null) {
            fileChooser.setSelectedFile(new FileSelect(fileExtension));
            fileChooser.setFileFilter(new FileFilterEx(fileExtension));
        }
        if ((fileChooserDialogReturn = fileChooser.showOpenDialog(fileChooserDialogLabel = new JLabel())) != 0) {
            return selectedFileName;
        }
        selectedFileName = fileChooser.getSelectedFile().getAbsolutePath();
        return selectedFileName;
    }

    private final class FileSelect
    extends File {
        private FileSelect(String[] fileFilter) {
            super(fileFilter[2]);
        }
    }

    private final class FileFilterEx
    extends FileFilter {
        private String extension;
        private String description;

        private FileFilterEx(String[] fileFilter) {
            this.extension = fileFilter[0];
            this.description = fileFilter[1];
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(this.extension);
        }

        public String getDescription() {
            return this.description;
        }
    }
}

