/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.snmpmanager.TableDataCsvFileOutput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.osgi.framework.Bundle;

public class ActionBuilderOidTable {
    private static Logger logger;
    private final Table instanceTable;
    private final IAction clearTableAction = new ActionTableClear();
    private final IAction exportOidInstanceInfoAction = new ActionExportOidInstanceInfo();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderOidTable(Table table) {
        this.instanceTable = table;
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction actionClearTable() {
        return this.clearTableAction;
    }

    public IAction actionExportOidInstanceInfo() {
        return this.exportOidInstanceInfoAction;
    }

    private abstract class AbstractNodeAction
    extends Action {
        private AbstractNodeAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    private final class ActionTableClear
    extends AbstractNodeAction {
        private ActionTableClear() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderOidTable.this.bundle.getEntry("icons/clear.gif"));
        }

        public String getText() {
            return "Table Clear";
        }

        public String getToolTipText() {
            return "Table Clear";
        }

        protected void doTask() {
            ActionBuilderOidTable.this.instanceTable.removeAll();
            TableViewer view = NetJFWatcherApplication.getOidTableView().getViewer();
            view.refresh();
        }
    }

    private final class ActionExportOidInstanceInfo
    extends AbstractNodeAction {
        private ActionExportOidInstanceInfo() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderOidTable.this.bundle.getEntry("icons/saveas_edit.gif"));
        }

        public String getText() {
            return "\u30c6\u30fc\u30d6\u30eb\u306e\u60c5\u5831\u3092\u30d5\u30a1\u30a4\u30eb\u51fa\u529b";
        }

        public String getToolTipText() {
            return "\u30c6\u30fc\u30d6\u30eb\u306e\u60c5\u5831\u3092\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u3057\u307e\u3059";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void doTask() {
            String csvFile;
            Shell shell;
            block9: {
                shell = new Shell();
                FileDialog openDialog = new FileDialog(shell, 8192);
                csvFile = openDialog.open();
                logger.info("CSV file name : " + csvFile);
                if (csvFile != null) break block9;
                return;
            }
            try {
                try {
                    TableDataCsvFileOutput fileOutput = TableDataCsvFileOutput.getInstance();
                    fileOutput.writeCSVFile(csvFile, ActionBuilderOidTable.this.instanceTable);
                    return;
                }
                catch (FileNotFoundException e) {
                    logger.warning(e.getMessage());
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("FileNotFoundException " + e.getMessage()));
                    return;
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("IOException " + e.getMessage()));
                    return;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (shell != null) {
                    shell.dispose();
                }
            }
        }
    }
}

