/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.snmpagent.process.ThreadAgent;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Document;

public class SnmpV3AgentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int ENGINEID_TEXT_WIDTH = 250;
    private static final int TEXT_WIDTH = 200;
    private static Logger logger;
    private Text engineIDText;
    private Text engineBootText;
    private Text engineSysUpTimeText;
    private Text userNameText;
    private Combo authPrivCombo;
    private Combo authProtocolCombo;
    private Text authPassPhrasaText;
    private Text privProtocolText;
    private Text privPassPhrasaText;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        SnmpV3AgentConfigInfo snmpV3AgentInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("EngineID");
        label.setLayoutData((Object)new GridData());
        this.engineIDText = new Text(composite, 2048);
        this.engineIDText.setText(snmpV3AgentInfo.getSnmpEngineID());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.engineIDText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("EngineBoots");
        label.setLayoutData((Object)new GridData());
        this.engineBootText = new Text(composite, 2048);
        this.engineBootText.setText(snmpV3AgentInfo.getSnmpEngineBoots());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.engineBootText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("EngineSysUpTime");
        label.setLayoutData((Object)new GridData());
        this.engineSysUpTimeText = new Text(composite, 2048);
        Date agentDate = Calendar.getInstance().getTime();
        long agentStartTime = ThreadAgent.getInstance().getStartSnmpAgentEngineTime();
        agentDate.setTime(agentStartTime);
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.engineSysUpTimeText.setText(dateformat.format(agentDate));
        this.engineSysUpTimeText.setEditable(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.engineSysUpTimeText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("User Name");
        label.setLayoutData((Object)new GridData());
        this.userNameText = new Text(composite, 2048);
        this.userNameText.setText(snmpV3AgentInfo.getUserName());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.userNameText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("AuthPriv");
        label.setLayoutData((Object)new GridData());
        this.authPrivCombo = new Combo(composite, 12);
        this.authPrivCombo.add("NOAUTH");
        this.authPrivCombo.add("AUTH");
        this.authPrivCombo.add("PRIV");
        this.authPrivCombo.setText(snmpV3AgentInfo.getAuthPriv());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.authPrivCombo.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("AuthProtocol");
        label.setLayoutData((Object)new GridData());
        this.authProtocolCombo = new Combo(composite, 12);
        this.authProtocolCombo.add("MD5");
        this.authProtocolCombo.add("SHA");
        this.authProtocolCombo.setText(snmpV3AgentInfo.getAuthProtocol());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.authProtocolCombo.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("AuthPassPhrase");
        label.setLayoutData((Object)new GridData());
        this.authPassPhrasaText = new Text(composite, 2048);
        this.authPassPhrasaText.setText(snmpV3AgentInfo.getAuthPassPhrase());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.authPassPhrasaText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("PrivProtocol");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.privProtocolText = new Text(composite, 2048);
        this.privProtocolText.setText(snmpV3AgentInfo.getPrivProtocol());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.privProtocolText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("PrivPassPhrase");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.privPassPhrasaText = new Text(composite, 2048);
        this.privPassPhrasaText.setText(snmpV3AgentInfo.getPrivPassPhrase());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.privPassPhrasaText.setLayoutData((Object)gridData);
        return composite;
    }

    protected void performDefaults() {
        SnmpV3AgentConfigInfo snmpV3info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        this.engineIDText.setText(snmpV3info.getSnmpEngineID());
        this.engineBootText.setText(snmpV3info.getSnmpEngineBoots());
        this.userNameText.setText(snmpV3info.getUserName());
        this.authPrivCombo.setText(snmpV3info.getAuthPriv());
        this.authProtocolCombo.setText(snmpV3info.getAuthProtocol());
        this.authPassPhrasaText.setText(snmpV3info.getAuthPassPhrase());
        this.privProtocolText.setText(snmpV3info.getPrivProtocol());
        this.privPassPhrasaText.setText(snmpV3info.getPrivPassPhrase());
    }

    public boolean performOk() {
        SnmpAgentConfigInfo snmpV3AgentConfInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
        SnmpV3AgentConfigInfo snmpV3Info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        snmpV3Info.setSnmpEngineBoots(this.engineBootText.getText());
        snmpV3Info.setUserName(this.userNameText.getText());
        snmpV3Info.setAuthPriv(this.authPrivCombo.getText());
        snmpV3Info.setAuthProtocol(this.authProtocolCombo.getText());
        snmpV3Info.setAuthPassPhrase(this.authPassPhrasaText.getText());
        snmpV3Info.setPrivProtocol(this.privProtocolText.getText());
        snmpV3Info.setPrivPassPhrase(this.privPassPhrasaText.getText());
        Document dom = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().updateDocument(snmpV3AgentConfInfo, snmpV3Info);
        BufferedWriter bufWriter = null;
        bufWriter = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getResourceFileWriter();
        SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for snmp V3 agent resource : " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (NetJFWatcherApplication.getAgentOperationView() != null) {
            NetJFWatcherApplication.getAgentOperationView().updateSnmpAgentInfo();
        }
        return super.performOk();
    }
}

