/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.integer;

import java.math.BigInteger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;

public class SnmpCounter64
extends SnmpInteger {
    private static BigInteger maxValue = new BigInteger("18446744070000000000");

    public SnmpCounter64() {
        this(0L);
        this.tag = (byte)70;
        this.tagDescription = "COUNTER64";
    }

    public SnmpCounter64(long newValue) {
        this.integerValue = new BigInteger(Long.toString(newValue));
        this.integerValue = this.integerValue.mod(maxValue);
        this.tag = (byte)70;
        this.tagDescription = "COUNTER64";
    }

    public SnmpCounter64(byte[] enc) throws SnmpBadValueException {
        this.extractValueFromBEREncoding(enc);
        this.integerValue = this.integerValue.mod(maxValue);
        this.tag = (byte)70;
        this.tagDescription = "COUNTER64";
    }

    public void setValue(Object newValue) throws SnmpBadValueException {
        if (newValue instanceof BigInteger) {
            this.integerValue = (BigInteger)newValue;
            this.integerValue = this.integerValue.mod(maxValue);
        } else if (newValue instanceof Integer) {
            this.integerValue = new BigInteger(newValue.toString());
            this.integerValue = this.integerValue.mod(maxValue);
        } else if (newValue instanceof String) {
            try {
                this.integerValue = new BigInteger((String)newValue);
                this.integerValue = this.integerValue.mod(maxValue);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpBadValueException(" Counter64: bad object supplied to set value ");
            }
        } else {
            throw new SnmpBadValueException(" Counter64: bad object supplied to set value ");
        }
    }
}

