/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.node;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditorNodeConfig
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = " Node View";
    public static final int DATE_TEXT_WIDTH = 250;
    public static final int TEXT_WIDTH1 = 120;
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{800, 800};
    private static final int HORIZONTAL_SPAN3 = 3;
    private static Logger logger;
    private NodeInformation targetNodeInfo;
    private Text nodeRegisterDateText;
    private Text nodeLastCheckDateText;
    private Text nodeNameText;
    private Text nodeIPAddressText;
    private Text nodeGroupText;
    private Text nodeKindText;
    private Text pingPeriodText;
    private Text pingThresholdText;
    private Text snmpVersionText;
    private Text snmpLevelText;
    private Text snmpPeriodText;
    private Text snmpROCommunityText;
    private Text snmpRWCommunityText;
    private Text httpPeriodText;
    private Text httpUrlText;
    private Text httpPortText;
    private Text httpTimeoutText;
    private Text pop3PeriodText;
    private Text pop3PortText;
    private Text pop3TimeoutText;
    private Text pop3UserText;
    private Text pop3PasswordText;
    private Text smtpTestAddressText;
    private Text smtpPeriodText;
    private Text smtpPortText;
    private Text smtpTimeoutText;
    private Text smtpCheckPop3HostText;
    private Text smtpCheckPop3UserText;
    private Text smtpCheckPop3PasswordText;
    private Text smtpCheckPop3PortText;
    private Text smtpCheckPop3TimeoutText;
    private Button refreshButton;
    private Color textBackColor;

    public EditorNodeConfig() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = WHITE_COLOR;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView)this.getEditorInput();
        this.targetNodeInfo = nodeViewEditorInput.getNodeInfo();
        this.isSocket = nodeViewEditorInput.isSocket();
        if (this.targetNodeInfo == null) {
            logger.warning("NodeInfo null");
        }
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite((Composite)scrollComposite, 0);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData(272));
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite1 = new Composite(composite0, 0);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite1, 0);
        label.setText("Node Register Date");
        label.setLayoutData((Object)new GridData());
        this.nodeRegisterDateText = new Text(composite1, 2056);
        this.nodeRegisterDateText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.nodeRegisterDateText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("      ");
        this.refreshButton = new Button(composite1, 0);
        this.refreshButton.setText("Refresh");
        label = new Label(composite1, 0);
        label.setText("Node Last Check Date");
        label.setLayoutData((Object)new GridData());
        this.nodeLastCheckDateText = new Text(composite1, 2056);
        this.nodeLastCheckDateText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.nodeLastCheckDateText.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout(5, false);
        Composite composite2 = new Composite(composite0, 0);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setLayout((Layout)gridLayout2);
        label = new Label(composite2, 0);
        label.setText("Node Name");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.nodeNameText = new Text(composite2, 2056);
        this.nodeNameText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeNameText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Ping");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pingPeriodText = new Text(composite2, 2056);
        this.pingPeriodText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pingPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Node IPAddress");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.nodeIPAddressText = new Text(composite2, 2056);
        this.nodeIPAddressText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeIPAddressText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Threshold(ms)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pingThresholdText = new Text(composite2, 2056);
        this.pingThresholdText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pingThresholdText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Group");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.nodeGroupText = new Text(composite2, 2056);
        this.nodeGroupText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeGroupText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Snmp");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Version");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpVersionText = new Text(composite2, 2056);
        this.snmpVersionText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpVersionText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Node Kind");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.nodeKindText = new Text(composite2, 2056);
        this.nodeKindText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeKindText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Level");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpLevelText = new Text(composite2, 2056);
        this.snmpLevelText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpLevelText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpPeriodText = new Text(composite2, 2056);
        this.snmpPeriodText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("RO Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpROCommunityText = new Text(composite2, 2056);
        this.snmpROCommunityText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpROCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("RW Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpRWCommunityText = new Text(composite2, 2056);
        this.snmpRWCommunityText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpRWCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Http");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpPeriodText = new Text(composite2, 2056);
        this.httpPeriodText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.httpPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("URL");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpUrlText = new Text(composite2, 2056);
        this.httpUrlText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 400;
        this.httpUrlText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpPortText = new Text(composite2, 2056);
        this.httpPortText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.httpPortText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpTimeoutText = new Text(composite2, 2056);
        this.httpTimeoutText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.httpTimeoutText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Pop3");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3PeriodText = new Text(composite2, 2056);
        this.pop3PeriodText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pop3PeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("User");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3UserText = new Text(composite2, 2056);
        this.pop3UserText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pop3UserText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Password");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3PasswordText = new Text(composite2, 0x400808);
        this.pop3PasswordText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pop3PasswordText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3PortText = new Text(composite2, 2056);
        this.pop3PortText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pop3PortText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3TimeoutText = new Text(composite2, 2056);
        this.pop3TimeoutText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pop3TimeoutText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("SMTP");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpPeriodText = new Text(composite2, 2056);
        this.smtpPeriodText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpPortText = new Text(composite2, 2056);
        this.smtpPortText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpPortText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpTimeoutText = new Text(composite2, 2056);
        this.smtpTimeoutText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpTimeoutText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Address (xxx@xxx)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpTestAddressText = new Text(composite2, 2056);
        this.smtpTestAddressText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpTestAddressText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Smtp check Pop3 Host");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpCheckPop3HostText = new Text(composite2, 2056);
        this.smtpCheckPop3HostText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpCheckPop3HostText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Smtp check Pop3 User");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpCheckPop3UserText = new Text(composite2, 2056);
        this.smtpCheckPop3UserText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpCheckPop3UserText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Smtp check Pop3 Password");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpCheckPop3PasswordText = new Text(composite2, 0x400808);
        this.smtpCheckPop3PasswordText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpCheckPop3PasswordText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Smtp check Pop3 Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpCheckPop3PortText = new Text(composite2, 2056);
        this.smtpCheckPop3PortText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpCheckPop3PortText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Smtp check Pop3 Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpCheckPop3TimeoutText = new Text(composite2, 2056);
        this.smtpCheckPop3TimeoutText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpCheckPop3TimeoutText.setLayoutData((Object)gridData);
        scrollComposite.setContent((Control)composite0);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.targetNodeInfo = this.getNodeInformation();
        this.setTextNodeInfo(this.targetNodeInfo);
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorNodeConfig.this.refreshButton.setEnabled(false);
                try {
                    EditorNodeConfig.this.targetNodeInfo = EditorNodeConfig.this.getNodeInformation();
                    EditorNodeConfig.this.setTextNodeInfo(EditorNodeConfig.this.targetNodeInfo);
                }
                finally {
                    EditorNodeConfig.this.refreshButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private NodeInformation getNodeInformation() {
        NodeInformation refreshNodeInfo = null;
        if (!this.isSocket) {
            DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
            ArrayList nodeList = null;
            try {
                try {
                    nodeList = nodeRegisterDBTable.findTarget(this.targetNodeInfo.getIpaddress());
                    refreshNodeInfo = (NodeInformation)nodeList.get(0);
                    this.setTextNodeInfo(refreshNodeInfo);
                }
                catch (SQLException e1) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Abort Node information get", (String)e1.getMessage());
                    logger.warning("Abort Node information get" + e1.getMessage());
                    shell.dispose();
                }
                catch (Exception e1) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Abort Node information get", (String)e1.getMessage());
                    logger.warning("Abort Node information get" + e1.getMessage());
                    shell.dispose();
                }
            }
            finally {
                nodeRegisterDBTable = null;
            }
        } else {
            String testEngineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(testEngineAddress);
            try {
                refreshNodeInfo = connectNodeInfo.getNodeInformation(this.targetNodeInfo.getIpaddress());
                this.setTextNodeInfo(refreshNodeInfo);
            }
            catch (EngineConnectException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
            catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
        }
        return refreshNodeInfo;
    }

    private void setTextNodeInfo(NodeInformation refreshNodeInfo) {
        if (refreshNodeInfo == null) {
            return;
        }
        if (refreshNodeInfo.getRegisterDate() != null) {
            this.nodeRegisterDateText.setText(refreshNodeInfo.getRegisterDate());
        }
        if (refreshNodeInfo.getLastCheck() != null) {
            this.nodeLastCheckDateText.setText(refreshNodeInfo.getLastCheck());
        }
        if (refreshNodeInfo.getNodename() != null) {
            this.nodeNameText.setText(refreshNodeInfo.getNodename());
        }
        if (refreshNodeInfo.getIpaddress() != null) {
            this.nodeIPAddressText.setText(refreshNodeInfo.getIpaddress());
        }
        if (refreshNodeInfo.getGroup() != null) {
            this.nodeGroupText.setText(refreshNodeInfo.getGroup());
        }
        if (refreshNodeInfo.getNodeKind() != null) {
            this.nodeKindText.setText(refreshNodeInfo.getNodeKind());
        }
        if (refreshNodeInfo.getPingPeriod() != null) {
            this.pingPeriodText.setText(refreshNodeInfo.getPingPeriod());
        }
        if (refreshNodeInfo.getPingThreshold() != null) {
            this.pingThresholdText.setText(refreshNodeInfo.getPingThreshold());
        }
        if (refreshNodeInfo.getSnmpVersion() != null) {
            this.snmpVersionText.setText(refreshNodeInfo.getSnmpVersion());
        }
        if (refreshNodeInfo.getSnmpLevel() != null) {
            if (refreshNodeInfo.getSnmpLevel().equals("0")) {
                this.snmpLevelText.setText("No SNMP");
            }
            if (refreshNodeInfo.getSnmpLevel().equals("1")) {
                this.snmpLevelText.setText("SNMP Configration");
            }
            if (refreshNodeInfo.getSnmpLevel().equals("2")) {
                this.snmpLevelText.setText("SNMP ifOctets");
            }
            if (refreshNodeInfo.getSnmpLevel().equals("3")) {
                this.snmpLevelText.setText("SNMP laLoad");
            }
            if (refreshNodeInfo.getSnmpLevel().equals("4")) {
                this.snmpLevelText.setText("SNMP disk");
            }
        }
        if (refreshNodeInfo.getSnmpPeriod() != null) {
            this.snmpPeriodText.setText(refreshNodeInfo.getSnmpPeriod());
        }
        if (refreshNodeInfo.getRoCommunity() != null) {
            this.snmpROCommunityText.setText(refreshNodeInfo.getRoCommunity());
        }
        if (refreshNodeInfo.getRwCommunity() != null) {
            this.snmpRWCommunityText.setText(refreshNodeInfo.getRwCommunity());
        }
        if (refreshNodeInfo.getHttpPeriod() != null) {
            this.httpPeriodText.setText(refreshNodeInfo.getHttpPeriod());
        }
        if (refreshNodeInfo.getHttpUrl() != null) {
            this.httpUrlText.setText(refreshNodeInfo.getHttpUrl());
        }
        if (refreshNodeInfo.getHttpPort() != null) {
            this.httpPortText.setText(refreshNodeInfo.getHttpPort());
        }
        if (refreshNodeInfo.getHttpTimeout() != null) {
            this.httpTimeoutText.setText(refreshNodeInfo.getHttpTimeout());
        }
        if (refreshNodeInfo.getPopPeriod() != null) {
            this.pop3PeriodText.setText(refreshNodeInfo.getPopPeriod());
        }
        if (refreshNodeInfo.getPopUser() != null) {
            this.pop3UserText.setText(refreshNodeInfo.getPopUser());
        }
        if (refreshNodeInfo.getPopPassword() != null) {
            this.pop3PasswordText.setText(refreshNodeInfo.getPopPassword());
        }
        if (refreshNodeInfo.getPopPort() != null) {
            this.pop3PortText.setText(refreshNodeInfo.getPopPort());
        }
        if (refreshNodeInfo.getPopTimeout() != null) {
            this.pop3TimeoutText.setText(refreshNodeInfo.getPopTimeout());
        }
        if (refreshNodeInfo.getSmtpPeriod() != null) {
            this.smtpPeriodText.setText(refreshNodeInfo.getSmtpPeriod());
        }
        if (refreshNodeInfo.getSmtpPort() != null) {
            this.smtpPortText.setText(refreshNodeInfo.getSmtpPort());
        }
        if (refreshNodeInfo.getSmtpTimeout() != null) {
            this.smtpTimeoutText.setText(refreshNodeInfo.getSmtpTimeout());
        }
        if (refreshNodeInfo.getSmtpSendAddress() != null) {
            this.smtpTestAddressText.setText(refreshNodeInfo.getSmtpSendAddress());
        }
        if (refreshNodeInfo.getSmtpCheckHost() != null) {
            this.smtpCheckPop3HostText.setText(refreshNodeInfo.getSmtpCheckHost());
        }
        if (refreshNodeInfo.getSmtpCheckUser() != null) {
            this.smtpCheckPop3UserText.setText(refreshNodeInfo.getSmtpCheckUser());
        }
        if (refreshNodeInfo.getSmtpCheckPassword() != null) {
            this.smtpCheckPop3PasswordText.setText(refreshNodeInfo.getSmtpCheckPassword());
        }
        if (refreshNodeInfo.getSmtpCheckPort() != null) {
            this.smtpCheckPop3PortText.setText(refreshNodeInfo.getSmtpCheckPort());
        }
        if (refreshNodeInfo.getSmtpCheckTimeout() != null) {
            this.smtpCheckPop3TimeoutText.setText(refreshNodeInfo.getSmtpCheckTimeout());
        }
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }
}

