/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.alarm;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.common.view.TableListViewColor;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderDataExport;
import netjfwatcher.engine.model.action.EngineStatus;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionAlarmInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.alarm.AlarmListTableViewLabelProvider;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditorNodeAlarm
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = " Alarm View";
    protected static final int COUNT_TEXT_WIDTH = 100;
    private static Logger logger;
    private static final float COLUMN0NO = 0.05f;
    private static final float COLUMN1ALARMDETECT = 0.15f;
    private static final float COLUMN2NODE_NAME = 0.1f;
    private static final float COLUMN3NODE_GROUP = 0.1f;
    private static final float COLUMN4IPADDRESSP = 0.1f;
    private static final float COLUMN5ALARM_MESSAGE = 0.5f;
    private AlarmAction alarmAction = new AlarmAction();
    protected ActionBuilderDataExport exportAction = new ActionBuilderDataExport();
    protected String sortColumn = null;
    protected String sortDirection = null;
    protected NodeInformation targetNodeInfo;
    protected Text alarmCountText;
    protected Button refreshButton;
    protected TableViewer viewer;
    protected Color textBackColor;
    protected int errorCount;
    protected int warningCount;
    protected int infoCount;

    public EditorNodeAlarm() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.textBackColor = WHITE_COLOR;
        EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView)this.getEditorInput();
        this.targetNodeInfo = nodeViewEditorInput.getNodeInfo();
        this.isSocket = nodeViewEditorInput.isSocket();
        if (this.targetNodeInfo == null) {
            logger.warning("NodeInfo null");
        }
        this.createImage(parent);
        AlarmTable alarmTable = new AlarmTable();
        this.table = alarmTable.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.createContextMenu();
        this.setNodeAlarmeView(this.targetNodeInfo.getIpaddress(), this.sortColumn, this.sortDirection);
        this.table.addSelectionListener((SelectionListener)new TableColumnControlTableListener(this.table, 5));
    }

    public void setNodeAlarmeView(String ipAddress, String sortColumn, String sortDirection) {
        this.table.removeAll();
        this.viewer.refresh();
        ArrayList alarmInfoList = this.getAlarmList(ipAddress, sortColumn, sortDirection);
        if (alarmInfoList == null) {
            return;
        }
        this.alarmCountText.setText(Integer.toString(alarmInfoList.size()));
        this.errorCount = 0;
        this.warningCount = 0;
        this.infoCount = 0;
        int i = 0;
        while (i < alarmInfoList.size()) {
            String[] alarmCellArray = new String[AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS.length];
            AlarmInformation alarmInfo = (AlarmInformation)alarmInfoList.get(i);
            alarmCellArray[0] = alarmInfo.getAlarmID();
            alarmCellArray[1] = alarmInfo.getAlarmDate();
            alarmCellArray[2] = alarmInfo.getNodename();
            alarmCellArray[3] = alarmInfo.getGroup();
            alarmCellArray[4] = alarmInfo.getIpaddress();
            alarmCellArray[5] = alarmInfo.getAlarmMessage();
            TableItem item = new TableItem(this.table, 0);
            item.setText(alarmCellArray);
            item.setData((Object)alarmCellArray);
            if (alarmInfo.getAlarmLevel().equals("ERROR")) {
                item.setForeground(TableListViewColor.getInstance().getAlarmErrorLevelColor());
                item.setImage(5, this.errorImage);
                ++this.errorCount;
            } else if (alarmInfo.getAlarmLevel().equals("WARNING")) {
                item.setForeground(TableListViewColor.getInstance().getAlarmWarningLevelColor());
                item.setImage(5, this.warningImage);
                ++this.warningCount;
            } else if (alarmInfo.getAlarmLevel().equals("INFO")) {
                item.setForeground(TableListViewColor.getInstance().getAlarmInfoLevelColor());
                item.setImage(5, this.infoImage);
                ++this.infoCount;
            } else {
                logger.warning("Unknown alarm level : " + alarmInfo.getAlarmLevel());
            }
            ++i;
        }
        this.setStatusLine();
    }

    public ArrayList getAlarmList(String ipAddress, String sortColumn, String sortDirection) {
        ArrayList alarmInfoList = null;
        if (!this.isSocket) {
            DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();
            try {
                alarmInfoList = alarmDBTable.findAllAlarm(0, ipAddress, sortColumn, sortDirection);
            }
            catch (SQLException e) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Alarm List import error", (String)e.getMessage());
                logger.warning("Alarm List import error " + e.getMessage());
            }
            catch (DatabaseConnectionException e) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Alarm List import error", (String)e.getMessage());
                logger.warning("Alarm List import error " + e.getMessage());
            }
        } else {
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionAlarmInformation connectAlarmInfo = new ConnectionAlarmInformation(engineAddress);
            try {
                alarmInfoList = connectAlarmInfo.getAlarmInformationList(0, ipAddress, null, null);
            }
            catch (EngineConnectException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
            catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
        }
        return alarmInfoList;
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EditorNodeAlarm.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.alarmAction.getActionShowNodeAlarmListTable());
        if (this.table.getSelectionIndex() >= 0 && this.table.getSelection() != null) {
            TableItem[] item = this.table.getSelection();
            String[] alarmInfo = (String[])item[0].getData();
            if (!this.isSocket) {
                ((ActionBuilderAlarmList.ActionConfirmAlarm)this.alarmAction.getActionConfirmAlarm()).setConfirmAlarm(alarmInfo[0], alarmInfo[4]);
                manager.add(this.alarmAction.getActionConfirmAlarm());
                ((ActionBuilderDataExport.ActionExportAlarm)this.exportAction.getActionExportAlarm()).setTable(this.table);
                manager.add(this.exportAction.getActionExportAlarm());
                ((ActionBuilderAlarmList.ActionExportAlarmInfo)this.alarmAction.getActionExportAlarm()).setIpAddress(this.targetNodeInfo.getIpaddress());
                manager.add(this.alarmAction.getActionExportAlarm());
            } else {
                ((ActionBuilderAlarmList.ActionConfirmAlarmSocket)this.alarmAction.getActionConfirmAlarmSocket()).setConfirmAlarm(alarmInfo[0], alarmInfo[4]);
                manager.add(this.alarmAction.getActionConfirmAlarmSocket());
                ((ActionBuilderDataExport.ActionExportAlarm)this.exportAction.getActionExportAlarm()).setTable(this.table);
                manager.add(this.exportAction.getActionExportAlarm());
                ((ActionBuilderAlarmList.ActionExportAlarmInfoSocket)this.alarmAction.getActionExportAlarmSocket()).setIpAddress(this.targetNodeInfo.getIpaddress());
                manager.add(this.alarmAction.getActionExportAlarmSocket());
            }
        }
        if (!this.isSocket) {
            ((ActionBuilderAlarmList.ActionExportAlarmInfo)this.alarmAction.getActionExportAlarm()).setIpAddress(this.targetNodeInfo.getIpaddress());
            manager.add(this.alarmAction.getActionExportAlarm());
            ((ActionBuilderAlarmList.ActionConfirmAllAlarm)this.alarmAction.getActionConfirmAllAlarm()).setAlarmIPAddress(this.targetNodeInfo.getIpaddress());
            manager.add(this.alarmAction.getActionConfirmAllAlarm());
        } else {
            ((ActionBuilderAlarmList.ActionExportAlarmInfoSocket)this.alarmAction.getActionExportAlarmSocket()).setIpAddress(this.targetNodeInfo.getIpaddress());
            manager.add(this.alarmAction.getActionExportAlarmSocket());
            ((ActionBuilderAlarmList.ActionConfirmAllAlarmSocket)this.alarmAction.getActionConfirmAllAlarmSocket()).setAlarmIPAddress(this.targetNodeInfo.getIpaddress());
            manager.add(this.alarmAction.getActionConfirmAllAlarmSocket());
        }
    }

    protected int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.05f);
    }

    protected int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.15f);
    }

    protected int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol3Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol4Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol5Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.5f);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        this.statusLineManager.setMessage("Alarm View Error=" + this.errorCount + " Warning=" + this.warningCount + " Info=" + this.infoCount);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.table != null) {
            this.table.dispose();
        }
    }

    public void setFocus() {
        if (EngineStatus.getInstance().isEngine()) {
            this.setNodeAlarmeView(this.targetNodeInfo.getIpaddress(), this.sortColumn, this.sortDirection);
        }
    }

    private final class AlarmTable
    extends AbstractTableView {
        private boolean isCol0Direction = false;
        private boolean isCol1Direction = true;
        private boolean isCol2Direction = true;
        private boolean isCol3Direction = true;
        private boolean isCol4Direction = true;
        private boolean isCol5Direction = true;
        private TableColumn col0;
        private TableColumn col1;
        private TableColumn col2;
        private TableColumn col3;
        private TableColumn col4;
        private TableColumn col5;
        private int[] imageColumn = new int[]{5};

        private AlarmTable() {
        }

        private Table createTable(Composite parent) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            parent.setLayout((Layout)gridLayout);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new RowLayout(256));
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            composite.setLayoutData((Object)data);
            Label labelAddress = new Label(composite, 0);
            labelAddress.setText("Alarm count");
            EditorNodeAlarm.this.alarmCountText = new Text(composite, 133128);
            EditorNodeAlarm.this.alarmCountText.setLayoutData((Object)new RowData(100, -1));
            EditorNodeAlarm.this.alarmCountText.setEditable(false);
            EditorNodeAlarm.this.alarmCountText.setEnabled(false);
            EditorNodeAlarm.this.alarmCountText.setBackground(EditorNodeAlarm.this.textBackColor);
            EditorNodeAlarm.this.refreshButton = new Button(composite, 0);
            EditorNodeAlarm.this.refreshButton.setText("Refresh");
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.verticalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            this.table = new Table(parent, 66304);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)data2);
            EditorNodeAlarm.this.refreshButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    ((AlarmTable)AlarmTable.this).EditorNodeAlarm.this.refreshButton.setEnabled(false);
                    EditorNodeAlarm.this.setNodeAlarmeView(((AlarmTable)AlarmTable.this).EditorNodeAlarm.this.targetNodeInfo.getIpaddress(), ((AlarmTable)AlarmTable.this).EditorNodeAlarm.this.sortColumn, ((AlarmTable)AlarmTable.this).EditorNodeAlarm.this.sortDirection);
                    ((AlarmTable)AlarmTable.this).EditorNodeAlarm.this.refreshButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
            this.col0 = new TableColumn(this.table, 0x1000000);
            this.col0.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[0]);
            this.col0.setWidth(EditorNodeAlarm.this.computeCol0Width());
            this.col1 = new TableColumn(this.table, 0x1000000);
            this.col1.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[1]);
            this.col1.setWidth(EditorNodeAlarm.this.computeCol1Width());
            this.col2 = new TableColumn(this.table, 0x1000000);
            this.col2.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[2]);
            this.col2.setWidth(EditorNodeAlarm.this.computeCol2Width());
            this.col3 = new TableColumn(this.table, 0x1000000);
            this.col3.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[3]);
            this.col3.setWidth(EditorNodeAlarm.this.computeCol3Width());
            this.col4 = new TableColumn(this.table, 0x1000000);
            this.col4.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[4]);
            this.col4.setWidth(EditorNodeAlarm.this.computeCol4Width());
            this.col5 = new TableColumn(this.table, 0x1000000);
            this.col5.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[5]);
            this.col5.setWidth(EditorNodeAlarm.this.computeCol5Width());
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                }

                public void controlResized(ControlEvent event) {
                    AlarmTable.this.setResizedTableColumnWidth();
                }
            });
            this.col0.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol0Direction = AlarmTable.this.sortIntegerTable(AlarmTable.this.table, 0, AlarmTable.this.isCol0Direction, AlarmTable.this.imageColumn);
                }
            });
            this.col1.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol1Direction = AlarmTable.this.sortTable(AlarmTable.this.table, 1, AlarmTable.this.isCol1Direction, AlarmTable.this.imageColumn);
                }
            });
            this.col2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol2Direction = AlarmTable.this.sortTable(AlarmTable.this.table, 2, AlarmTable.this.isCol2Direction, AlarmTable.this.imageColumn);
                }
            });
            this.col3.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol3Direction = AlarmTable.this.sortTable(AlarmTable.this.table, 3, AlarmTable.this.isCol3Direction, AlarmTable.this.imageColumn);
                }
            });
            this.col4.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol4Direction = AlarmTable.this.sortTable(AlarmTable.this.table, 4, AlarmTable.this.isCol4Direction, AlarmTable.this.imageColumn);
                }
            });
            this.col5.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmTable.this.isCol5Direction = AlarmTable.this.sortTable(AlarmTable.this.table, 5, AlarmTable.this.isCol5Direction, AlarmTable.this.imageColumn);
                }
            });
            return this.table;
        }

        protected void setResizedTableColumnWidth() {
            if (EditorNodeAlarm.this.getEditorSite().getPage().isPartVisible(EditorNodeAlarm.this.getEditorSite().getPart()) && EditorNodeAlarm.this.getEditorSite().getShell() != null && EditorNodeAlarm.this.getEditorSite().getShell().getSize() != null) {
                this.col0.setWidth(EditorNodeAlarm.this.computeCol0Width());
                this.col1.setWidth(EditorNodeAlarm.this.computeCol1Width());
                this.col2.setWidth(EditorNodeAlarm.this.computeCol2Width());
                this.col3.setWidth(EditorNodeAlarm.this.computeCol3Width());
                this.col4.setWidth(EditorNodeAlarm.this.computeCol4Width());
                this.col5.setWidth(EditorNodeAlarm.this.computeCol5Width());
            }
        }

        protected TableItem setTableItem(Table table, TableItem item, String[] strs) {
            Color obj = item.getForeground();
            Image image1 = item.getImage(5);
            item.dispose();
            item = new TableItem(table, 0);
            item.setText(strs);
            item.setData((Object)strs);
            item.setForeground(obj);
            item.setImage(5, image1);
            return item;
        }
    }

    private final class AlarmAction
    extends ActionBuilderAlarmList {
        private AlarmAction() {
        }

        public void refreshNodeAlarmTable() {
            EditorNodeAlarm.this.setNodeAlarmeView(EditorNodeAlarm.this.targetNodeInfo.getIpaddress(), EditorNodeAlarm.this.sortColumn, EditorNodeAlarm.this.sortDirection);
        }
    }
}

