/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.top;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.ActionBuilderEngine;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class TopView
extends ViewPart {
    private static Display display;
    private static Color whiteColor;
    private static Color blackColor;
    private Button engineStartButton;
    private Button snmpBrowserStartButton;
    protected static final int HORIZONTAL_SPAN1 = 1;
    private static Logger logger;
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private Image splashImage;
    private ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();

    static {
        whiteColor = new Color(null, 255, 255, 255);
        blackColor = new Color(null, 0, 0, 0);
    }

    public TopView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        if (whiteColor == null || whiteColor.isDisposed()) {
            whiteColor = new Color(null, 255, 255, 255);
        }
        if (blackColor == null || blackColor.isDisposed()) {
            blackColor = new Color(null, 0, 0, 0);
        }
        display = parent.getDisplay();
        GridLayout gridLayout = new GridLayout(1, false);
        parent.setLayout((Layout)gridLayout);
        parent.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout0);
        composite.setLayoutData((Object)new GridData(1872));
        composite.setBackground(whiteColor);
        composite.setForeground(blackColor);
        Composite composite0 = new Composite(composite, 0);
        composite0.setLayout((Layout)new GridLayout(1, false));
        composite0.setLayoutData((Object)new GridData(1872));
        composite0.setBackground(whiteColor);
        composite0.setForeground(blackColor);
        Composite composite1 = new Composite(composite, 0);
        composite1.setLayout((Layout)new GridLayout(1, true));
        composite1.setLayoutData((Object)new GridData(1872));
        composite1.setBackground(whiteColor);
        composite1.setForeground(blackColor);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(1872));
        composite2.setBackground(whiteColor);
        composite2.setForeground(blackColor);
        this.createImage();
        Label label1 = new Label(composite1, 0x1000000);
        label1.setBackground(whiteColor);
        GridData gridData = new GridData(836);
        gridData.horizontalSpan = 1;
        label1.setLayoutData((Object)gridData);
        label1.setImage(this.splashImage);
        this.engineStartButton = new Button(composite1, 0);
        gridData = new GridData(68);
        this.engineStartButton.setLayoutData((Object)gridData);
        this.engineStartButton.setText("Network Watcher start");
        this.snmpBrowserStartButton = new Button(composite1, 0);
        this.snmpBrowserStartButton.setLayoutData((Object)gridData);
        this.snmpBrowserStartButton.setText("SNMP Browser start");
        Font font = new Font((Device)Display.getCurrent(), "", 20, 3);
        Label label = new Label(composite2, 0x1000000);
        label.setFont(font);
        label.setBackground(whiteColor);
        label.setText(" NetJFWatch Ver. 1.4 ");
        GridData gridData2 = new GridData(1872);
        label.setLayoutData((Object)gridData2);
        font = new Font((Device)Display.getCurrent(), "", 16, 2);
        Label label3 = new Label(composite2, 0x1000000);
        label3.setFont(font);
        label3.setBackground(whiteColor);
        label3.setText("Copyright 2004-2007");
        GridData gridData3 = new GridData(1872);
        label3.setLayoutData((Object)gridData3);
        this.setSelectionListener();
    }

    private void setSelectionListener() {
        this.engineStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TopView.this.engineStartButton.setEnabled(false);
                TopView.this.actionBuilderEngine.getActionStartEngine().run();
                try {
                    TopView.this.getSite().getWorkbenchWindow().getWorkbench().showPerspective("netjfwatcher.engine.view.EngineManagerPerspective", TopView.this.getSite().getWorkbenchWindow());
                    TopView.this.getSite().getWorkbenchWindow().getWorkbench().showPerspective("netjfwatcher.engine.nodemaneger.NodeManagerPerspective", TopView.this.getSite().getWorkbenchWindow());
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)TopView.this.getSite().getShell(), (String)"Error", (String)"Abort system start.");
                    logger.warning("Abort system start. " + e.getMessage());
                }
                TopView.this.engineStartButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.snmpBrowserStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TopView.this.snmpBrowserStartButton.setEnabled(false);
                try {
                    TopView.this.getSite().getWorkbenchWindow().getWorkbench().openWorkbenchWindow("SNMPManager", TopView.this.getSite().getPage().getInput());
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)TopView.this.getSite().getShell(), (String)"Error", (String)"Abort SNMP Browser start.");
                    logger.warning("Abort SNMP Browser start. " + e.getMessage());
                }
                TopView.this.snmpBrowserStartButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    public void setFocus() {
    }

    private void createImage() {
        URL url = null;
        try {
            url = this.bundle.getEntry("icons/start_splash.gif");
            if (url == null) {
                logger.severe("Not found icon file : icons/start_splash.gif");
            } else {
                this.splashImage = new Image((Device)display, url.openStream());
            }
        }
        catch (IOException e) {
            logger.warning("Abort create image " + e.getMessage() + " for " + "icons/start_splash.gif");
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.splashImage != null) {
            this.splashImage.dispose();
        }
        whiteColor.dispose();
        blackColor.dispose();
    }
}

