/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.preferance.AbstractEnginePreferancePage;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class XMLSocketPreferancePage
extends AbstractEnginePreferancePage
implements IWorkbenchPreferencePage {
    private static final int TEXT_WIDTH = 200;
    private static Logger logger;
    private ResourceInfo resourceInfo;
    private Combo alertSoundCombo;
    private Text allowHostText;
    private Text xmlSocketPortText;
    private Text xmlSocketMaxConnectText;
    private Text alertSoundText;
    private Text refreshTimeText;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("XML Socket allow-host");
        label.setLayoutData((Object)new GridData());
        this.allowHostText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.allowHostText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("XML Socket port");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.xmlSocketPortText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.xmlSocketPortText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("XML Socket maxconnect");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.xmlSocketMaxConnectText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.xmlSocketMaxConnectText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Alert sound");
        label.setLayoutData((Object)new GridData());
        this.alertSoundText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.alertSoundText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Refresh time(sec)");
        label.setLayoutData((Object)new GridData());
        this.refreshTimeText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.refreshTimeText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Alert sound");
        label.setLayoutData((Object)new GridData());
        this.alertSoundCombo = new Combo(composite, 12);
        ArrayList soundList = MediaResource.getInstance().getSoundFileList();
        int i = 0;
        while (i < soundList.size()) {
            String work = (String)soundList.get(i);
            int pathPoint = work.lastIndexOf("sound/");
            if (pathPoint >= 0) {
                this.alertSoundCombo.add(work.substring("sound/".length()));
            } else {
                this.alertSoundCombo.add(work);
            }
            ++i;
        }
        this.alertSoundCombo.select(0);
        this.showXMLSocketProp();
        this.alertSoundCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLSocketPreferancePage.this.alertSoundText.setText(XMLSocketPreferancePage.this.alertSoundCombo.getText());
            }
        });
        return composite;
    }

    private void showXMLSocketProp() {
        this.allowHostText.setText(this.resourceInfo.getXmlsocketAllowHost());
        this.xmlSocketPortText.setText(this.resourceInfo.getXmlSocketPort());
        this.xmlSocketMaxConnectText.setText(this.resourceInfo.getXmlSocketMaxConnect());
        this.alertSoundText.setText(this.resourceInfo.getAlertSound());
        this.refreshTimeText.setText(this.resourceInfo.getRefreshTime());
    }

    protected void performDefaults() {
        this.resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        this.showXMLSocketProp();
    }

    public boolean performOk() {
        this.resourceInfo.setXmlsocketAllowHost(this.allowHostText.getText());
        this.resourceInfo.setXmlSocketPort(this.xmlSocketPortText.getText());
        this.resourceInfo.setXmlSocketMaxConnect(this.xmlSocketMaxConnectText.getText());
        this.resourceInfo.setAlertSound(this.alertSoundText.getText());
        this.resourceInfo.setRefreshTime(this.refreshTimeText.getText());
        this.saveResourceXMLInfo(this.resourceInfo);
        return super.performOk();
    }
}

