/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodemaneger.map;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableMapLink;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.nodecontrol.NodeEdit;
import netjfwatcher.engine.nodemaneger.map.NodeMapInfo;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeAlarm;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeConfig;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeOperation;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeSnmp;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeSnmpStatisticsSet;
import netjfwatcher.engine.nodemaneger.map.NodeMapViewDraw;
import netjfwatcher.engine.nodemaneger.map.NodeMapViewMouseListener;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.engine.view.editorpart.ping.NodePingMenu;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class NodeMapViewPopUpMenu {
    protected static String LOAD_MENU = "Load";
    protected static String SAVE_MENU = "Save";
    protected static String LINK_MENU = "Link";
    private static Logger logger;
    protected Display display;
    protected Canvas canvas;
    protected Menu popUpMenu;
    protected MenuItem nodeViewMenuItem;
    protected MenuItem nodeAlarmMenuItem;
    protected MenuItem nodeSnmpMenuItem;
    protected MenuItem nodeSnmpStatisticsSetMenuItem;
    protected NodeMapViewDraw mapDraw;
    protected ArrayList<NodeMapInfo> nodeMapNodeInfoList = new ArrayList();
    protected NodeMapLinkInformation nodMapLinkInformationList;
    protected Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    protected HashMap nodeIconImageMap = new HashMap();
    protected Image[] nodeImage = null;
    protected SubStatusLineManager statusLineManager;
    protected NodeMapViewMouseListener mouseListener;

    public NodeMapViewPopUpMenu(Display display, Canvas canvas, NodeMapViewDraw mapDraw, NodeMapViewMouseListener mouseListener, SubStatusLineManager statusLineManager) {
        logger = Logger.getLogger(this.getClass().getName());
        this.display = display;
        this.canvas = canvas;
        this.mapDraw = mapDraw;
        this.statusLineManager = statusLineManager;
        this.mouseListener = mouseListener;
    }

    public void setPopUpMenu(Composite parent) {
        this.popUpMenu = new Menu((Decorations)parent.getShell(), 8);
        this.canvas.setMenu(this.popUpMenu);
        MenuItem menuItemLoad = new MenuItem(this.popUpMenu, 8);
        menuItemLoad.setText(LOAD_MENU);
        menuItemLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeMapViewPopUpMenu.this.loadNodeMap();
            }
        });
        MenuItem menuItemSave = new MenuItem(this.popUpMenu, 8);
        menuItemSave.setText(SAVE_MENU);
        menuItemSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeMapViewPopUpMenu.this.saveNodeMap();
            }
        });
        MenuItem menuItemLink = new MenuItem(this.popUpMenu, 32);
        menuItemLink.setText(LINK_MENU);
        if (this.mouseListener.isLineSelected()) {
            menuItemLink.setSelection(true);
        } else {
            menuItemLink.setSelection(false);
        }
        menuItemLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NodeMapViewPopUpMenu.this.mouseListener.isLineSelected()) {
                    NodeMapViewPopUpMenu.this.mouseListener.setLineSelected(false);
                } else {
                    NodeMapViewPopUpMenu.this.mouseListener.setLineSelected(true);
                }
            }
        });
    }

    public void loadNodeMap() {
        this.getNodeMapLink(true);
        ArrayList nodeList = this.getNodeInfoListMapView(true);
        this.createNodeMapInfo(nodeList);
        this.mapDraw.redraw(this.nodeMapNodeInfoList, this.nodMapLinkInformationList);
        this.setStatusLine();
    }

    private void saveNodeMap() {
        int i = 0;
        while (i < this.nodeMapNodeInfoList.size()) {
            NodeMapInfo nodeMapInfo = this.nodeMapNodeInfoList.get(i);
            NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();
            NodeEdit editNodeInstance = NodeEdit.getInstance();
            try {
                editNodeInstance.editNodeInfo(nodeInfo);
            }
            catch (DatabaseConnectionException e1) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Abort Node Map save error", (String)e1.getMessage());
                logger.warning("Abort Node Map save error " + e1.getMessage());
                shell.dispose();
                return;
            }
            catch (SQLException e1) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                logger.warning("Node List import error " + e1.getMessage());
                shell.dispose();
                return;
            }
            ++i;
        }
        if (this.nodMapLinkInformationList == null) {
            return;
        }
        DBTableMapLink nodeMapLinkDBTable = new DBTableMapLink();
        try {
            nodeMapLinkDBTable.updateNodeMapLink(this.nodMapLinkInformationList, true);
        }
        catch (SQLException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (DatabaseConnectionException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
    }

    protected void createNodeMapInfo(ArrayList nodeList) {
        this.nodeImage = new Image[nodeList.size()];
        this.nodeMapNodeInfoList.clear();
        int i = 0;
        while (i < nodeList.size()) {
            NodeInformation nodeInfo = (NodeInformation)nodeList.get(i);
            this.nodeImage[i] = this.createNodeIconImage(nodeInfo.getNodeKind());
            NodeMapInfo nodeMapinfo = new NodeMapInfo();
            int x = 0;
            int y = 0;
            x = (int)Float.parseFloat(nodeInfo.getNodeX());
            y = (int)Float.parseFloat(nodeInfo.getNodeY());
            nodeMapinfo.setNodeIconImage(this.nodeImage[i]);
            nodeMapinfo.setX(x);
            nodeMapinfo.setY(y);
            nodeMapinfo.setNodeInfo(nodeInfo);
            nodeMapinfo.setHeight(this.nodeImage[i].getBounds().height);
            nodeMapinfo.setWidth(this.nodeImage[i].getBounds().width);
            this.nodeMapNodeInfoList.add(nodeMapinfo);
            ++i;
        }
    }

    protected Image createNodeIconImage(String nodeKind) {
        String nodeIconFileName = MediaResource.getInstance().getNodeIconFullFileName(nodeKind);
        Image nodeIconImage = null;
        if (!this.nodeIconImageMap.containsKey(nodeIconFileName)) {
            URL url = null;
            url = this.bundle.getEntry(nodeIconFileName);
            if (url == null) {
                logger.severe("Not found icon file : " + nodeIconFileName);
            } else {
                try {
                    nodeIconImage = new Image((Device)this.display, url.openStream());
                    this.nodeIconImageMap.put(nodeIconFileName, nodeIconImage);
                }
                catch (IOException e) {
                    logger.warning("Abort create image " + e.getMessage() + " for " + nodeIconFileName);
                    e.printStackTrace();
                }
            }
        } else {
            nodeIconImage = (Image)this.nodeIconImageMap.get(nodeIconFileName);
        }
        return nodeIconImage;
    }

    protected void setNodeMenu(NodeInformation nodeI) {
        this.nodeViewMenuItem = new MenuItem(this.popUpMenu, 8);
        this.nodeViewMenuItem.setText("Node Config");
        NodeMapMenuNodeConfig nodeConfig = new NodeMapMenuNodeConfig(nodeI, false);
        this.nodeViewMenuItem.addSelectionListener((SelectionListener)nodeConfig);
        this.nodeAlarmMenuItem = new MenuItem(this.popUpMenu, 8);
        this.nodeAlarmMenuItem.setText("Node Alarm");
        NodeMapMenuNodeAlarm nodeAlarm = new NodeMapMenuNodeAlarm(nodeI, false);
        this.nodeAlarmMenuItem.addSelectionListener((SelectionListener)nodeAlarm);
        this.nodeSnmpMenuItem = new MenuItem(this.popUpMenu, 8);
        this.nodeSnmpMenuItem.setText("Node Snmp");
        NodeMapMenuNodeSnmp nodeSnmp = new NodeMapMenuNodeSnmp(nodeI, false);
        this.nodeSnmpMenuItem.addSelectionListener((SelectionListener)nodeSnmp);
        NodePingMenu menuPing = new NodePingMenu();
        menuPing.createPingMenu(this.popUpMenu, nodeI, false);
        NodeSnmpStatisticsMenu menuSnmpStatistics = new NodeSnmpStatisticsMenu();
        menuSnmpStatistics.createSnmpStatisticsMenu(this.popUpMenu, nodeI, false);
        this.nodeSnmpStatisticsSetMenuItem = new MenuItem(this.popUpMenu, 8);
        this.nodeSnmpStatisticsSetMenuItem.setText("Node Snmp Statistics Set");
        NodeMapMenuNodeSnmpStatisticsSet nodeSnmpStatisticsSet = new NodeMapMenuNodeSnmpStatisticsSet(nodeI, false);
        this.nodeSnmpStatisticsSetMenuItem.addSelectionListener((SelectionListener)nodeSnmpStatisticsSet);
        this.nodeViewMenuItem = new MenuItem(this.popUpMenu, 8);
        this.nodeViewMenuItem.setText("Node Add/Edit/Delete");
        NodeMapMenuNodeOperation nodeOperaqtion = new NodeMapMenuNodeOperation(nodeI, false);
        this.nodeViewMenuItem.addSelectionListener((SelectionListener)nodeOperaqtion);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ArrayList getNodeInfoListMapView(boolean isNodeInfo) {
        if (!isNodeInfo) {
            return new ArrayList();
        }
        DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
        ArrayList nodeList = null;
        try {
            try {
                nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
                return nodeList;
            }
            catch (SQLException e1) {
                block7: {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                    logger.warning("Node List import error" + e1.getMessage());
                    shell.dispose();
                    e1.printStackTrace();
                    break block7;
                    catch (Exception e12) {
                        shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e12.getMessage());
                        logger.warning("Node List import error" + e12.getMessage());
                        shell.dispose();
                        e12.printStackTrace();
                    }
                }
                nodeRegisterDBTable = null;
                return null;
            }
        }
        finally {
            nodeRegisterDBTable = null;
        }
    }

    private void getNodeMapLink(boolean isGetDatabase) {
        if (isGetDatabase) {
            DBTableMapLink nodeMapLinkDBTable = new DBTableMapLink();
            try {
                this.nodMapLinkInformationList = nodeMapLinkDBTable.findAll();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (DatabaseConnectionException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected void setStatusLine() {
        if (this.nodeMapNodeInfoList != null) {
            this.statusLineManager.setVisible(true);
            this.statusLineManager.setMessage("Node Map View Node count = " + this.nodeMapNodeInfoList.size());
        } else {
            this.statusLineManager.setVisible(false);
        }
    }

    public ArrayList getNodeMapNodeInfoList() {
        return this.nodeMapNodeInfoList;
    }

    public NodeMapLinkInformation getNodMapLinkInformationList() {
        return this.nodMapLinkInformationList;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        HashMap list = this.nodeIconImageMap;
        Iterator it = null;
        for (String key : list.keySet()) {
            Image nodeIconImage = (Image)list.get(key);
            if (nodeIconImage == null) continue;
            nodeIconImage.dispose();
        }
        if (this.popUpMenu != null) {
            this.popUpMenu.dispose();
        }
        if (this.nodeImage != null) {
            int i = 0;
            while (i < this.nodeImage.length) {
                if (this.nodeImage[i] != null) {
                    this.nodeImage[i].dispose();
                }
                ++i;
            }
        }
    }
}

