/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.command.model;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Logger;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.MailProperty;
import netjfwatcher.engine.socket.info.ResourceInfo;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class CommandResourceSet
extends TemplateCommandImpl {
    private static Logger logger;

    public void doInvoke(CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());
        Document dom = null;
        BufferedWriter bufWriter = null;
        ResourceInfo updateResourceInfo = com.getResourceInfo();
        dom = this.updateSNMPV3Resource(updateResourceInfo);
        bufWriter = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getResourceFileWriter();
        this.outputXMLFile(bufWriter, dom);
        dom = this.updateSystemResource(updateResourceInfo);
        bufWriter = SystemResourceConfig.getInstance().getResourceFileParse().getResourceFileWriter();
        this.outputXMLFile(bufWriter, dom);
        SnmpV3ManagerConfig.getInstance().updateResourceset();
        SystemResourceConfig.getInstance().updateResourceset();
        ResourceInfo resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        this.sendResponse(resourceInfo, ois, oos);
    }

    private Document updateSNMPV3Resource(ResourceInfo updateResourceInfo) {
        Document dom = SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateDocument(updateResourceInfo);
        return dom;
    }

    private Document updateSystemResource(ResourceInfo updateResourceInfo) {
        MailProperty[] mailPoro = updateResourceInfo.getMailPropertyList();
        System.out.println("mailPoro.length : " + mailPoro.length);
        int i = 0;
        while (i < mailPoro.length) {
            System.out.println("getSmtp_Host : " + mailPoro[i].getSmtpHost());
            System.out.println("getMail_SendFlag : " + mailPoro[i].getMailSendFlag());
            System.out.println("getFrom : " + mailPoro[i].getFrom());
            String[] to = mailPoro[i].getTo();
            int j = 0;
            while (j < to.length) {
                System.out.println("Mail to : " + to[j]);
                ++j;
            }
            ++i;
        }
        Document dom = SystemResourceConfig.getInstance().getResourceFileParse().updateDocument(updateResourceInfo);
        return dom;
    }

    private void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        XMLOutputter outputter = XMLOutputterFormat.getInstance().getXMLOutputterFormat();
        OutputStreamWriter writer = null;
        try {
            try {
                outputter.output(dom, (OutputStream)System.out);
                outputter.output(dom, (Writer)bufWriter);
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }
}

