/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;

public class MySQLDatabaseInit {
    public static final String CREATE = "CREATE DATABASE nodewatch";
    public static final String DROP = "DROP DATABASE IF EXISTS nodewatch";
    private static Logger logger = null;

    public void createDatabase() throws IllegalAccessException, InstantiationException, ClassNotFoundException, SQLException {
        logger = Logger.getLogger(this.getClass().getName());
        AbstractDataAccessObject databaseProp = DatabaseAccessControlKind.getInstance().getDataAccessObject();
        String jdbcdriver = databaseProp.getDriver();
        String url = databaseProp.getDatabaseurl();
        String username = databaseProp.getUser();
        String password = databaseProp.getPassword();
        Statement stmt = null;
        Connection con = null;
        try {
            try {
                Class.forName(jdbcdriver).newInstance();
                con = DriverManager.getConnection(url, username, password);
                stmt = con.createStatement();
                logger.info("Database Kind : " + DatabaseAccessControlKind.getInstance().getDatabaseName());
                stmt.executeUpdate(DROP);
                stmt.executeUpdate(CREATE);
            }
            catch (SQLException e) {
                logger.warning("URL = " + url + " : User = " + username + " : Password = " + password);
                logger.severe(e.getMessage());
                e.printStackTrace();
                throw e;
            }
            catch (IllegalAccessException e) {
                logger.severe("IllegalAccessException " + jdbcdriver + " " + e.getMessage());
                throw e;
            }
            catch (InstantiationException e) {
                logger.severe("InstantiationException " + jdbcdriver + " " + e.getMessage());
                throw e;
            }
            catch (ClassNotFoundException e) {
                logger.severe("ClassNotFoundException " + jdbcdriver + " " + e.getMessage());
                throw e;
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e1) {
                    logger.severe(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e1) {
                    logger.severe(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }
}

