/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.authentication;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class AuthenticationConfigFileParse {
    private static final String CONF_TAG = "conf";
    private static final String USER_TAG = "user";
    private static final String USER_NAME_TAG = "user_name";
    private static final String PASSWORD_TAG = "password";
    private static final String ATTRIBUTE_VALUE = "value";
    private Map<String, String> userMap = Collections.synchronizedMap(new HashMap());
    private List<String> userNameList = Collections.synchronizedList(new LinkedList());
    private String userName;
    private String passwrod;
    private static Logger logger = null;

    public AuthenticationConfigFileParse() {
        logger = Logger.getLogger(this.getClass().getName());
        this.userMap.clear();
        this.userNameList.clear();
        Document doc = null;
        BufferedReader d = null;
        try {
            FileReader fi = new FileReader("resources/authentication.xml");
            d = new BufferedReader(fi);
        }
        catch (FileNotFoundException e1) {
            logger.warning("FileNotFoundException " + e1.getMessage());
            return;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            if (builder == null) {
                return;
            }
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            logger.warning("JDOMException " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning("IOException " + e.getMessage());
            e.printStackTrace();
        }
        try {
            Element root = doc.getRootElement();
            List userList = root.getChildren(USER_TAG);
            for (Element userListEl : userList) {
                this.userName = userListEl.getChild(USER_NAME_TAG).getAttributeValue(ATTRIBUTE_VALUE);
                this.passwrod = userListEl.getChild(PASSWORD_TAG).getAttributeValue(ATTRIBUTE_VALUE);
                this.userMap.put(this.userName, this.passwrod);
                this.userNameList.add(this.userName);
            }
        }
        catch (NullPointerException e) {
            logger.warning("NullPointerException " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean checkUser(String userName, String password) {
        return this.userMap.containsKey(userName) && this.userMap.get(userName).equals(password);
    }

    public BufferedWriter getResourceFileWriter() {
        File f = new File("resources/authentication.xml");
        if (f == null) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fi = new FileWriter("resources/authentication.xml");
            bufferedWriter = new BufferedWriter(fi);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return bufferedWriter;
    }

    public Document updateDocument(Map userInfoMap) {
        logger = Logger.getLogger(this.getClass().getName());
        Element confElement = new Element(CONF_TAG);
        Document doc = new Document(confElement);
        Element[] userEl = new Element[userInfoMap.size()];
        Element[] userNameEl = new Element[userInfoMap.size()];
        Element[] passwordEl = new Element[userInfoMap.size()];
        Iterator it = null;
        int i = 0;
        for (String userNameData : userInfoMap.keySet()) {
            String passwordData = (String)userInfoMap.get(userNameData);
            userEl[i] = new Element(USER_TAG);
            userNameEl[i] = new Element(USER_NAME_TAG);
            passwordEl[i] = new Element(PASSWORD_TAG);
            confElement.addContent((Content)userEl[i]);
            userEl[i].addContent((Content)userNameEl[i]);
            userEl[i].addContent((Content)passwordEl[i]);
            userNameEl[i].setAttribute(new Attribute(ATTRIBUTE_VALUE, userNameData));
            passwordEl[i].setAttribute(new Attribute(ATTRIBUTE_VALUE, passwordData));
            ++i;
        }
        return doc;
    }

    public Map getUserMap() {
        return this.userMap;
    }

    public List getUserNameList() {
        return this.userNameList;
    }
}

