/*
 * Created on 2005/02/07
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.snmp.snmpv3.UsmUserManager;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.jdom.Document;



/**
 * SNMP V3ɊւvtFXy[WNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpV3PreferencePage extends AbstractSnmpPreferencePage {
    /* eLXg\ */
    private static final int TEXT_WIDTH = 200;

    /* Agent Discovery eLXg\ */
    private static final int DISCOVERY_TEXT_WIDTH = 120;

    /* ComboBox\ */
    private static final int COMBO_WIDTH = 120;

    /* SNMP V3 AgentXgXp */
    private static final int AGENT_LIST_VERTICAL_SPAN = 11;

    /* SNMP V3 AgentXgheightHint */
    private static final int AGENT_LIST_HEIGHT_HINT = 5;

    /* SNMP V3 AgentwKDiscoveryText  */
    private static final String DISCOVERY = "Discovery";

    /* SNMP V3 AgentwKUndiscoveryText */
    private static final String UNDISCOVERY = "Undiscovery";

    /* MO */
    private static Logger logger;

    /* AgentǗo^AhXXg */
    private List snmpV3AgentAddressList = null;

    /* AgentAhX\eLXg */
    private Text selectV3AgentAddressText;

    /* EngineID\eLXg */
    private Text engineIDText;

    /* EngineBoots\eLXg */
    private Text engineBootText;

    /* Engine Sysuptime\eLXg */
    private Text engineSysUpTimeText;

    /* User name\eLXg */
    private Text userNameText;

    /* AuthPriv\ComboBox */
    private Combo authPrivCombo;

    /* AuthProtocol\ComboBox */
    private Combo authProtocolCombo;

    /* AuthPassPhrasa\eLXg  */
    private Text authPassPhrasaText;

    /* PrivProtocol\eLXg */
    private Text privProtocolText;

    /* PrivPassPhrasa\eLXg */
    private Text privPassPhrasaText;

    /* AgentwKԕ\eLXg */
    private Text agentLearnedText;

    /* AgentǉAhX\eLXg */
    private Text addAgentAddressText;

    /* Agent폜AhX\eLXg */
    private Text removeAgentAddressText;

    /* AgentwKԃZbg{^ */
    private Button discoveryResetButton;

    /* Agentǉ{^ */
    private Button addAgentButton;

    /* Agent폜{^ */
    private Button removeAgentButton;

    /**
     * Snmp V3vtFXy[W̏s܂B
     *
     * @param workbench IWorkbench
     */
    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(this.getClass().getName());

        // Initialize the preference store we wish to use
        setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());

        /* Snmp V3G[WFgXg擾 */
        /* snmpV3InfoHashMap =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3ConfigAddresssMapList();
        */
    }

    /**
     * Rec𐶐܂B
     *
     * @param parent Composite
     * @return Control
     */
    protected Control createContents(Composite parent) {
        /* TextwiFZbg */
        textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridData gridData = null;

        /*
         * Snmp V3 AgentAhXXgAgentAhXɑΉ
         * vpeB\
         */
        Composite compositeSnmpV3AgentProperty =
            new Composite(parent, SWT.NONE);

        /* ep[c3Ŕzu */
        GridLayout gridLayoutV3AgentProp = new GridLayout(3, false);
        compositeSnmpV3AgentProperty.setLayout(gridLayoutV3AgentProp);
        compositeSnmpV3AgentProperty.setLayoutData(
            new GridData(GridData.HORIZONTAL_ALIGN_FILL));

        /* Snmp V3G[WFgXgCAEg */
        snmpV3AgentAddressList =
            new List(compositeSnmpV3AgentProperty, SWT.MULTI | SWT.BORDER);

        GridData data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1; // XgXpZbg
        data.verticalSpan = AGENT_LIST_VERTICAL_SPAN; // XgXpZbg
        data.widthHint = TEXT_WIDTH;
        data.heightHint =
            snmpV3AgentAddressList.getItemHeight() * AGENT_LIST_HEIGHT_HINT;
        snmpV3AgentAddressList.setLayoutData(data);

        /*
         * Snmp V3 }l[WŊǗAgentvpeB擾
         */
        Iterator iterator = null;

        for (
            iterator =
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                   .getSnmpV3ConfigAddresssMapList().keySet()
                                   .iterator(); iterator.hasNext();) {
            String ipAddress = (String) iterator.next();
            SnmpV3ManagerConfigInfo info =
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                   .getSnmpV3AgentInfo(ipAddress);
            snmpV3AgentAddressList.add(info.getIpAddress());
        }

        // snmpV3AgentAddressList.select(0);
        snmpV3AgentAddressList.setLayoutData(data);

        Label label = new Label(compositeSnmpV3AgentProperty, SWT.NONE);
        label.setText("Select Agent Address");
        label.setLayoutData(new GridData());
        selectV3AgentAddressText =
            new Text(compositeSnmpV3AgentProperty, SWT.BORDER);
        selectV3AgentAddressText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1; // TextXpZbg
        gridData.verticalSpan = 1; // TextXpZbg
        gridData.widthHint = TEXT_WIDTH;
        selectV3AgentAddressText.setLayoutData(gridData);

        label = new Label(compositeSnmpV3AgentProperty, SWT.NONE);
        label.setText("EngineID");
        label.setLayoutData(new GridData());
        engineIDText =
            new Text(compositeSnmpV3AgentProperty, SWT.BORDER | SWT.READ_ONLY);

        engineIDText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineIDText.setLayoutData(gridData);
        engineIDText.setEditable(false);
        engineIDText.setEnabled(false);
        engineIDText.setBackground(textBackColor);

        label = new Label(compositeSnmpV3AgentProperty, SWT.NONE);
        label.setText("EngineBoots");
        label.setLayoutData(new GridData());
        engineBootText =
            new Text(compositeSnmpV3AgentProperty, SWT.BORDER | SWT.READ_ONLY);
        engineBootText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineBootText.setLayoutData(gridData);
        engineBootText.setEditable(false);
        engineBootText.setEnabled(false);
        engineBootText.setBackground(textBackColor);

        label = new Label(compositeSnmpV3AgentProperty, SWT.NONE);
        label.setText("EngineSysUpTime");
        label.setLayoutData(new GridData());
        engineSysUpTimeText =
            new Text(compositeSnmpV3AgentProperty, SWT.BORDER | SWT.READ_ONLY);
        engineSysUpTimeText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineSysUpTimeText.setLayoutData(gridData);
        engineSysUpTimeText.setEditable(false);
        engineSysUpTimeText.setEnabled(false);
        engineSysUpTimeText.setBackground(textBackColor);

        agentLearnedText =
            new Text(compositeSnmpV3AgentProperty, SWT.BORDER | SWT.READ_ONLY);
        agentLearnedText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = DISCOVERY_TEXT_WIDTH;
        agentLearnedText.setLayoutData(gridData);
        agentLearnedText.setEnabled(false);
        agentLearnedText.setBackground(textBackColor);

        discoveryResetButton =
            new Button(compositeSnmpV3AgentProperty, SWT.NONE);
        discoveryResetButton.setText("Discovery Reset");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        discoveryResetButton.setLayoutData(gridData);

        label = new Label(compositeSnmpV3AgentProperty, SWT.NONE);
        label.setText("User Name");
        label.setLayoutData(new GridData());
        userNameText = new Text(compositeSnmpV3AgentProperty, SWT.BORDER);
        userNameText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        userNameText.setLayoutData(gridData);

        label = new Label(compositeSnmpV3AgentProperty, SWT.NONE);
        label.setText("AuthPriv");
        label.setLayoutData(new GridData());
        authPrivCombo =
            new Combo(
                compositeSnmpV3AgentProperty, SWT.DROP_DOWN | SWT.READ_ONLY);
        authPrivCombo.add(UsmUserManager.AUTHPRIV_NOAUTH);
        authPrivCombo.add(UsmUserManager.AUTHPRIV_AUTH);
        authPrivCombo.add(UsmUserManager.AUTHPRIV_PRIV);
        authPrivCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COMBO_WIDTH;
        authPrivCombo.setLayoutData(gridData);

        label = new Label(compositeSnmpV3AgentProperty, SWT.NONE);
        label.setText("AuthProtocol");
        label.setLayoutData(new GridData());
        authProtocolCombo =
            new Combo(
                compositeSnmpV3AgentProperty, SWT.DROP_DOWN | SWT.READ_ONLY);
        authProtocolCombo.add(UsmUserManager.AUTH_PROTOCOL_MD5);
        authProtocolCombo.add(UsmUserManager.AUTH_PROTOCOL_SHA);
        authProtocolCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COMBO_WIDTH;
        authProtocolCombo.setLayoutData(gridData);

        label = new Label(compositeSnmpV3AgentProperty, SWT.NONE);
        label.setText("AuthPassPhrase");
        label.setLayoutData(new GridData());
        authPassPhrasaText = new Text(compositeSnmpV3AgentProperty, SWT.BORDER);
        authPassPhrasaText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        authPassPhrasaText.setLayoutData(gridData);

        label = new Label(compositeSnmpV3AgentProperty, SWT.NONE);
        label.setText("PrivProtocol");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        privProtocolText = new Text(compositeSnmpV3AgentProperty, SWT.BORDER);
        privProtocolText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        privProtocolText.setLayoutData(gridData);

        label = new Label(compositeSnmpV3AgentProperty, SWT.NONE);
        label.setText("PrivPassPhrase");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
        privPassPhrasaText = new Text(compositeSnmpV3AgentProperty, SWT.BORDER);
        privPassPhrasaText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        privPassPhrasaText.setLayoutData(gridData);

        addAgentAddressText =
            new Text(compositeSnmpV3AgentProperty, SWT.BORDER);
        addAgentAddressText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        addAgentAddressText.setLayoutData(gridData);
        addAgentButton = new Button(compositeSnmpV3AgentProperty, SWT.NONE);
        addAgentButton.setText("Add Agent");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        addAgentButton.setLayoutData(gridData);

        removeAgentAddressText =
            new Text(compositeSnmpV3AgentProperty, SWT.BORDER);
        removeAgentAddressText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        removeAgentAddressText.setLayoutData(gridData);

        removeAgentButton = new Button(compositeSnmpV3AgentProperty, SWT.NONE);
        removeAgentButton.setText("Remove Agent");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        removeAgentButton.setLayoutData(gridData);

        /*
         * SNMP AgentǉButtonAgentǉ܂B
         */
        addAgentButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    addAgent();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * Snmp Agent폜ButtonɂAAgent폜܂B
         */
        removeAgentButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    removeAgent();
                }

                public void widgetDefaultSelected(SelectionEvent ev) {
                }
            });

        /*
         * Snmp V3 Agent AddressXgIXi[łB
         * IꂽAgentAhXɑΉSnmp Agent
         * View Textɕ\܂B
         */
        snmpV3AgentAddressList.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    selectSnmpV3AgentAddressList();
                }
            });

        /*
         * G[WFgDiscovery Rest{^
         *
         */
        discoveryResetButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    logger = Logger.getLogger(this.getClass().getName());

                    /* IG[WFgAhXo */
                    int index = snmpV3AgentAddressList.getSelectionIndex();
                    String addAgentAddress =
                        snmpV3AgentAddressList.getItem(index);

                    SnmpV3ManagerConfigInfo info =
                        SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                           .getSnmpV3AgentInfo(addAgentAddress);

                    if (addAgentAddress.equals("")) {
                        return;
                    }

                    /* G[WFg񏉊 */
                    engineIDText.setText("");
                    engineBootText.setText("");
                    engineSysUpTimeText.setText("");
                    agentLearnedText.setText(UNDISCOVERY);
                    info.setLearned(false);
                    SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                       .updateSnmpV3ManagerConfigInfo(
                        addAgentAddress, info);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        Composite entryTable = new Composite(parent, SWT.NULL);
        entryTable.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

        return entryTable;
    }

    /*
     * Agentǉ܂B
     *
     */
    private void addAgent() {
        String addAgentAddress = addAgentAddressText.getText();

        if (addAgentAddress.equals("")) {
            return;
        }

        try {
            InetAddress host = InetAddress.getByName(addAgentAddress);
            addAgentAddress = host.getHostAddress();
        } catch (UnknownHostException e2) {
            MessageDialog.openError(
                getShell().getShell(), "Error",
                "UnknownHostException" + " IP Address = " + addAgentAddress);
            addAgentAddressText.setFocus();

            return;
        }

        /*
         * ǉAgentAhXɑ݂ꍇ́AReturn
         */
        if (
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                   .getSnmpV3AgentInfo(addAgentAddress) != null) {
            MessageDialog.openError(
                getShell(), "Error",
                "Already Agent IP = " + addAgentAddress + " !");

            return;
        }

        /* ǉAgent𐶐 */
        snmpV3AgentAddressList.add(addAgentAddress);
        addAgentAddressText.setText("");

        SnmpV3ManagerConfigInfo info = new SnmpV3ManagerConfigInfo();
        SnmpV3ManagerUserConfigInfo userInfo =
            new SnmpV3ManagerUserConfigInfo();

        userInfo.setUsername(userNameText.getText());
        userInfo.setAuthPriv(authPrivCombo.getText());
        userInfo.setAuthProtocol(authProtocolCombo.getText());
        userInfo.setAuthPassPhrase(authPassPhrasaText.getText());
        userInfo.setPrivProtocol(privProtocolText.getText());
        userInfo.setPrivPassPhrase(privPassPhrasaText.getText());
        info.addUserList(userInfo);
        info.setIpAddress(addAgentAddress);
        info.setLearned(false);

        SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                           .updateSnmpV3ManagerConfigInfo(
            addAgentAddress, info);
    }

    /*
     * Agent폜܂B
     *
     */
    private void removeAgent() {
        /* 폜AgentAhXo */
        String removeAgentAddress = removeAgentAddressText.getText();

        if (removeAgentAddress.equals("")) {
            return;
        }

        if (
            MessageDialog.openQuestion(
                    getShell(), "Confirm", "Remove " + removeAgentAddress
                    + " ?")) {
            /*
             * SnmpV3 Agent Address݂ĂȂꍇ
             */
            if (
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                       .getSnmpV3AgentInfo(removeAgentAddress) == null) {
                MessageDialog.openError(
                    getShell().getShell(), "Error",
                    "Not Found " + " IP Address = " + removeAgentAddress);
                removeAgentAddressText.setFocus();

                return;
            }

            /*
             * wSnmpV3 Agent AddressXg폜
             */
            removeAgentAddressText.setText("");
            snmpV3AgentAddressList.remove(removeAgentAddress);
            snmpV3AgentAddressList.redraw();
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3ConfigAddresssMapList().remove(
                removeAgentAddress);
        }
    }

    /*
     * AgentXgIłB
     * AgenteLXgɕ\܂B
     *
     */
    private void selectSnmpV3AgentAddressList() {
        int index = snmpV3AgentAddressList.getSelectionIndex();

        SnmpV3ManagerConfigInfo info =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3AgentInfo(
                snmpV3AgentAddressList.getItem(index));

        if (info != null) {
            selectV3AgentAddressText.setText(info.getIpAddress());
            removeAgentAddressText.setText(info.getIpAddress());

            if (
                !(info.getSnmpEngineID() == null)
                    && !(info.getSnmpEngineID().equals(""))) {
                engineIDText.setText("0x" + info.getSnmpEngineID());
            } else {
                engineIDText.setText("");
            }

            if (info.getSnmpEngineBoots() != null) {
                engineBootText.setText(info.getSnmpEngineBoots());
            } else {
                engineBootText.setText("");
            }

            if (info.isLearned()) {
                agentLearnedText.setText(DISCOVERY);
            } else {
                agentLearnedText.setText(UNDISCOVERY);
            }

            long agentSnmpEngineTime = 0;

            try {
                agentSnmpEngineTime = Long.parseLong(info.getSnmpEngineTime());
            } catch (NumberFormatException e1) {
                logger.warning(
                    "NumberFormatException " + "SNMP Agent SnmpEngineTime "
                    + info.getSnmpEngineTime());
            }

            if (agentSnmpEngineTime != 0) {
                Date agentDate = Calendar.getInstance().getTime();
                agentDate.setTime(agentSnmpEngineTime);

                DateFormat dateformat =
                    new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                engineSysUpTimeText.setText(dateformat.format(agentDate));
            } else {
                engineSysUpTimeText.setText("");
            }

            SnmpV3ManagerUserConfigInfo userInfo =
                (SnmpV3ManagerUserConfigInfo) info.getUserList().get(0);

            if (userInfo != null) {
                userNameText.setText(userInfo.getUsername());
                authPrivCombo.setText(userInfo.getAuthPriv());
                authProtocolCombo.setText(userInfo.getAuthProtocol());
                authPassPhrasaText.setText(userInfo.getAuthPassPhrase());
                privProtocolText.setText(userInfo.getPrivProtocol());
                privPassPhrasaText.setText(userInfo.getPrivPassPhrase());
            }
        }
    }

    /**
     * Snmp V3vtFXy[WftHgłB
     * G[WFg܂B
     *
     */
    protected void performDefaults() {
        /* G[WFgAhXXgU폜 */
        snmpV3AgentAddressList.removeAll();

        /* G[WFgēxAǂݍ */
        ArrayList snmpV3InfoList =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getResourceSnmpV3ConfigList();
        String[] snmpV3TargetAddress = new String[snmpV3InfoList.size()];

        /*
         * Snmp V3 AgentvpeB擾
         */
        for (int i = 0; i < snmpV3InfoList.size(); i++) {
            SnmpV3ManagerConfigInfo info =
                (SnmpV3ManagerConfigInfo) snmpV3InfoList.get(i);
            System.out.println("Address : " + info.getIpAddress());
            snmpV3TargetAddress[i] = info.getIpAddress();

            snmpV3AgentAddressList.add(info.getIpAddress());
        }

        selectV3AgentAddressText.setText("");
        addAgentAddressText.setText("");
        removeAgentAddressText.setText("");

        engineIDText.setText("");
        engineBootText.setText("");
        agentLearnedText.setText("");
        engineSysUpTimeText.setText("");
        userNameText.setText("");
        authPrivCombo.select(0);
        authProtocolCombo.select(0);
        authPassPhrasaText.setText("");
        privProtocolText.setText("");
        privPassPhrasaText.setText("");
    }

    /**
     * Snmp V3vtFXy[WOK{^łB
     * eLXg͂ɂƂÂݒf[^i[܂B
     * āAIy[VViewSnmp V3G[WFg
     * XV܂B
     *
     * @return i[
     */
    public boolean performOk() {
        String targetIPAddress = "";

        /*
         * IĂAgentAhX𒊏oB
         * AgentAhXIĂȂꍇ͉return
         */
        if (selectV3AgentAddressText.getText().equals("")) {
            return false;
        }

        targetIPAddress = selectV3AgentAddressText.getText();

        /* IAgentAhXSnmpV3擾AVieweLXg̓͒lɍXV */
        SnmpV3ManagerConfigInfo info =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3AgentInfo(targetIPAddress);

        if (info != null) {
            SnmpV3ManagerUserConfigInfo userInfo =
                (SnmpV3ManagerUserConfigInfo) info.getUserList().get(0);

            if (userInfo != null) {
                userInfo.setUsername(userNameText.getText());
                userInfo.setAuthPriv(authPrivCombo.getText());
                userInfo.setAuthProtocol(authProtocolCombo.getText());
                userInfo.setAuthPassPhrase(authPassPhrasaText.getText());
                userInfo.setPrivProtocol(privProtocolText.getText());
                userInfo.setPrivPassPhrase(privPassPhrasaText.getText());
            }

            info.addUserList(userInfo);
            info.setIpAddress(targetIPAddress);

            if (agentLearnedText.getText().equals(DISCOVERY)) {
                info.setLearned(true);
            } else {
                info.setLearned(false);
            }
        }

        /*
         * AgentView text͒lɍXVAAgentAhXXg
         * AgentAhXAgentZbgāA\`XML
         * t@CXV
         */
        ArrayList<SnmpV3ManagerConfigInfo> saveAgentList = new ArrayList<SnmpV3ManagerConfigInfo>();

        /* AgentAhXǂݏoA`FbN */
        String[] agentListAddress =
            new String[snmpV3AgentAddressList.getItemCount()];

        for (int i = 0; snmpV3AgentAddressList.getItemCount() > i; i++) {
            agentListAddress[i] = snmpV3AgentAddressList.getItem(i);

            if (agentListAddress[i].equals(targetIPAddress)) {
                saveAgentList.add(info);
            } else {
                SnmpV3ManagerConfigInfo workInfo =
                    SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                       .getSnmpV3AgentInfo(agentListAddress[i]);
                saveAgentList.add(workInfo);
            }
        }

        /* \`XMLt@CXV */
        saveSnmpV3XMLInfo(saveAgentList);

        /* Snmp V3Iy[VView̃G[WFgXV */
        if (NetJFWatcherApplication.getSnmpV3OperationView() != null) {
            NetJFWatcherApplication.getSnmpV3OperationView().updateSnmpV3AgentList();
        }

        return super.performOk();
    }

    /*
     * \[XƂĂSNMP V3 AgentXVăt@C
     * Write܂B
     *
     * @param snmpV3List SNMPV3 Agenti[List
     */
    private void saveSnmpV3XMLInfo(ArrayList snmpV3List) {
        // Document
        Document dom = null;

        // t@Co̓obt@
        BufferedWriter bufWriter = null;

        // SNMPV3\`XV
        dom = this.updateSNMPV3Resource(snmpV3List);

        if (dom == null) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Error", "Abort save SNMP V3 config");
            shell.dispose();

            return;
        }

        bufWriter =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getResourceFileWriter();

        // XMLt@Co
        this.outputXMLFile(bufWriter, dom);

        if (bufWriter != null) {
            try {
                bufWriter.close();
            } catch (IOException e) {
                logger.warning(
                    "Abort close BufferedWriter for snmp V3 resource : "
                    + e.getMessage());
                e.printStackTrace();
            }
        }

        // FileɃCgɃCX^XXV
        SnmpV3ManagerConfig.getInstance().updateResourceset();
    }

    /*
     * \[XƂĂSNMP V3 AgentXVADocumentԂ܂B
     *
     * @param snmpV3List SNMP V3 Agenti[List
     * @return dom \[XƂĂSNMP V3 AgentXVDocument
     */
    private Document updateSNMPV3Resource(ArrayList snmpV3List) {
        /*
         * \[XƂĂSNMP V3 AgentXVDocument擾
         */
        Document dom =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .updateDocument(snmpV3List);

        return dom;
    }
}
