/*
 * Created on 2004/12/07
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpv3;

import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;


/**
 * AgentUSM(User based Security Model)ǗNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class UsmUserAgentManager {
    /* MO */
    private static Logger logger;

    /*
     * userName@snmpEngineID L[Ƃ UsmUserEntry MapXg
     */
    private Map userEntryMapList = Collections.synchronizedMap(new Hashtable());

    /* UsmUserEntry ̃Xg */
    private List usmUserEntryList =
        Collections.synchronizedList(new LinkedList());

    /*
     * UsmUserManager ̃CX^X𐶐܂B
     */
    private UsmUserAgentManager() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ̃NX̃CX^XԂ܂B
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static UsmUserAgentManager getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * SNMP Agentɂ郆[UAuthɊւvgRA
     * KeyPrivɊւvgRAKeyo^܂B
     *
     * @param snmpEngineID SnmpEngineID
     * @param info SNMP V3G[WFg\
     * @throws SnmpV3ConfigurationException SNMP V3G[WFg\
     * ُȏꍇ
     */
    public void registAgentList(
        SnmpEngineID snmpEngineID, SnmpV3AgentConfigInfo info)
        throws SnmpV3ConfigurationException {
        String userName = null;
        String authPriv = null;
        String authProtocol = null;
        String authPassPhrase = null;
        String privProtocol = null;
        String privPassPhrase = null;

        userName = info.getUserName();
        authPriv = info.getAuthPriv();
        authProtocol = info.getAuthProtocol();
        authPassPhrase = info.getAuthPassPhrase();
        privProtocol = info.getPrivProtocol();
        privPassPhrase = info.getPrivPassPhrase();

        if (authPriv == null) {
            throw new SnmpV3ConfigurationException("");
        }

        /*
        logger.info("userName : " + userName);
        logger.info("authPriv : " + authPriv);
        logger.info("authProtocol : " + authProtocol);
        logger.info("authPassPhrase : " + authPassPhrase);
        logger.info("privProtocol : " + privProtocol);
        logger.info("privPassPhrase : " + privPassPhrase);
        */
        boolean error = false;

        if ((userName == null) || (authPriv == null)) {
            error = true;
        }

        if (authPriv.equals(UsmUserManager.AUTHPRIV_NOAUTH)) {
            authProtocol = null;
            privProtocol = null;
        } else if (authPriv.equals(UsmUserManager.AUTHPRIV_AUTH)) {
            privProtocol = null;

            if (
                (authProtocol == null)
                    || !(authProtocol.equals(UsmUserManager.AUTH_PROTOCOL_MD5)
                    || authProtocol.equals(UsmUserManager.AUTH_PROTOCOL_SHA))) {
                error = true;
            }

            if (authPassPhrase == null) {
                error = true;
            }
        } else if (authPriv.equals(UsmUserManager.AUTHPRIV_PRIV)) {
            if (
                (privProtocol == null)
                    || !privProtocol.equals(UsmUserManager.PRIV_PROTOCOL_DES)) {
                error = true;
            }

            if (privPassPhrase == null) {
                error = true;
            }
        } else {
            error = true;
        }

        if (error) {
            throw new SnmpV3ConfigurationException("");
        }

        // UsmUserEntry 𐶐
        UsmUserEntry usmUserEntry = new UsmUserEntry();
        usmUserEntry.setUsmUserEngineID(snmpEngineID);
        usmUserEntry.setUsmUserName(userName);
        usmUserEntry.setUsmUserSecurityName(userName);
        usmUserEntry.setUsmUserCloneFrom(SnmpV3OID.ZERO_DOT_ZERO);

        /* FؗpAuthvgRyKeyZbg */
        try {
            if (authProtocol == null) {
                usmUserEntry.setUsmUserAuthProtocol(
                    UsmUserEntry.USM_NO_AUTH_PROTOCOL);
            } else if (authProtocol.equals(UsmUserManager.MSG_DIGEST_MD5)) {
                usmUserEntry.setUsmUserAuthProtocol(
                    UsmUserEntry.USM_HMAC_MD5_AUTH_PROTOCOL);
                usmUserEntry.setUsmUserAuthKey(
                    new UsmLocalizeKey(
                        authPassPhrase, snmpEngineID, UsmLocalizeKey.KEY_GEN_ALGO_HMAC_MD5));
            } else if (authProtocol.equals(UsmUserManager.AUTH_PROTOCOL_SHA)) {
                usmUserEntry.setUsmUserAuthProtocol(
                    UsmUserEntry.USM_HMAC_SHA_AUTH_PROTOCOL);
                usmUserEntry.setUsmUserAuthKey(
                    new UsmLocalizeKey(
                        authPassPhrase, snmpEngineID, UsmLocalizeKey.KEY_GEN_ALGO_HMAC_SHA));
            }
        } catch (NoSuchAlgorithmException e) {
            throw new SnmpV3ConfigurationException(e.toString());
        }

        usmUserEntry.setUsmUserAuthKeyChange("");
        usmUserEntry.setUsmUserOwnAuthKeyChange("");

        /*
        logger.info("userName : " + userName);
        logger.info("authPriv : " + authPriv);
        logger.info("privProtocol : " + privProtocol);
        logger.info("authProtocol : " + authProtocol);
        logger.info("privPassPhrase : " + privPassPhrase);
        logger.info("snmpEngineID : " + snmpEngineID);
        */
        /* ÍpPrivvgRyKeyZbg */
        try {
            if (privProtocol == null) {
                usmUserEntry.setUsmUserPrivProtocol(
                    UsmUserEntry.USM_NO_PRIV_PROTOCOL);
            } else if (privProtocol.equals(UsmUserManager.PRIV_PROTOCOL_DES)) {
                usmUserEntry.setUsmUserPrivProtocol(
                    UsmUserEntry.USM_DES_PRIV_PROTOCOL);

                if (authProtocol.equals(UsmUserManager.MSG_DIGEST_MD5)) {
                    usmUserEntry.setUsmUserPrivKey(
                        new UsmLocalizeKey(
                            privPassPhrase, snmpEngineID, UsmLocalizeKey.KEY_GEN_ALGO_HMAC_MD5));
                } else if (
                    authProtocol.equals(UsmUserManager.AUTH_PROTOCOL_SHA)) {
                    usmUserEntry.setUsmUserPrivKey(
                        new UsmLocalizeKey(
                            privPassPhrase, snmpEngineID, UsmLocalizeKey.KEY_GEN_ALGO_HMAC_SHA));
                }
            }
        } catch (NoSuchAlgorithmException e) {
            throw new SnmpV3ConfigurationException(e.toString());
        }

        usmUserEntry.setUsmUserPrivKeyChange("");
        usmUserEntry.setUsmUserOwnPrivKeyChange("");
        usmUserEntry.setUsmUserPublic("");
        usmUserEntry.setUsmUserStorageType(UsmUserEntry.VOLATILE);
        usmUserEntry.setUsmUserStatus(UsmUserEntry.ACTIVE);

        // o^
        StringBuffer sb = new StringBuffer();
        sb.append(userName).append("@");
        sb.append(snmpEngineID.toString());
        logger.info(sb.toString() + " USM register");
        userEntryMapList.put(sb.toString(), usmUserEntry);
        usmUserEntryList.add(usmUserEntry);
    }

    /**
     * w肳ꂽ snmpEngineID  userName  UsmUserEntry Ԃ܂B
     * vȂꍇ null Ԃ܂B
     *
     * @param snmpEngineID SnmpEngineID
     * @param userName@[U
     * @return UsmUserEntry
     */
    public UsmUserEntry getUsmUserEntry(
        SnmpEngineID snmpEngineID, String userName) {
        StringBuffer sb = new StringBuffer();
        sb.append(userName).append("@");
        sb.append(snmpEngineID.toString());

        return (UsmUserEntry) userEntryMapList.get(sb.toString());
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final UsmUserAgentManager RESOURCE = new UsmUserAgentManager();
    }
}
