/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.message;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;



/**
 * ASN.1 Type(^O)ɂNULL(^O)ɑΉSNMPIuWFNg
 * 삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpNull extends AbstractSnmpObject {
    /**
     * ASN.1 Type(^O)ɂNULL(^O)ɑΉSNMP
     * IuWFNg𐶐܂B
     */
    public SnmpNull() {
        tag = SnmpBERCodec.SNMPNULL_TAG;
        tagDescription = SnmpBERCodec.SNMPNULL;
    }

    /**
     * SNMP NullIuWFNgŕێlԂ܂B
     *
     * @return SNMP NULLIuWFNgŕێl
     */
    public Object getValue() {
        return null;
    }

    /**
     * SNMP NullIuWFNg̒lZbg܂B
     *
     * @param object SNMP NullIuWFNgɃZbgl
     * @throws SnmpBadValueException ̃\bhĂ΂ꂽ
     */
    public void setValue(Object object) throws SnmpBadValueException {
        throw new SnmpBadValueException(" Null: attempt to set value ");
    }

    /**
     * SNMP NullIuWFNg̒lBERGR[fBOoCgz
     * Ԃ܂B
     * 2oCgō\ATAGR[hƃf[^0ƂȂ܂B
     *
     * @return encodingDataArray f[^oCgz
     */
    public byte[] getBEREncoding() {
        byte[] encodingDataArray = new byte[2];

        // set tag byte
        encodingDataArray[0] = SnmpBERCodec.SNMPNULL_TAG;

        // len = 0 since no payload!
        encodingDataArray[1] = 0;

        return encodingDataArray;
    }

    /**
     * SNMP NullIuWFNg̒l𕶎ɕϊĕԂ܂B
     *
     * @return SNMP NullIuWFNg̒l𕶎
     */
    public String toString() {
        return "Null";
    }

    /**
     * ASN.1 BERGR[fBOTAGʂԂ܂B
     *
     * @return returnString ASN.1 BERGR[fBOTAG
     */
    public String getTagCode() {
        String returnString = tagDescription + "(" + hexByte(tag) + ")";

        return returnString;
    }
}
