/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.messageformat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;


/**
 * The SNMPVariablePair class implements the VarBind specification
 * detailed below from RFC 1157.
 * It is a specialization of SNMPSequence, defining a 2-element
 * sequence containing a single
 * (object identifier, value) pair. Note that the values are
 * themselves SNMPObjects.
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpVariablePair extends SnmpSequence {
    private List contents;

    /**
     *
     *
     */
    public SnmpVariablePair() {
        super();
        contents = Collections.synchronizedList(new ArrayList());
    }

    /**
     * Create a new variable pair having the supplied object identifier and vale.
     *
     * @param objectID OID
     * @param value SNMPIuWFNg
     * @throws SnmpBadValueException SNMPIuWFNgZbgɎsꍇ
     */
    public SnmpVariablePair(
        SnmpObjectIdentifier objectID, AbstractSnmpObject value)
        throws SnmpBadValueException {
        super();
        contents = Collections.synchronizedList(new ArrayList());
        contents.add(0, objectID);
        contents.add(1, value);
        this.setValue(contents);
    }

    /**
     * wOIDSNMPIuWFNg̃yAZbg܂B
     *
     * @param objectID OID
     * @param value SNMPIuWFNg
     * @throws SnmpBadValueException SNMPIuWFNgZbgɎsꍇ
     */
    public void setSNMPVariablePair(
        SnmpObjectIdentifier objectID, AbstractSnmpObject value)
        throws SnmpBadValueException {
        contents.clear();
        contents.add(0, objectID);
        contents.add(1, value);
        this.setValue(contents);
    }
}
