/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.alarm;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;



/**
 * A[XgIɊĎ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmTableTimerProcessor implements Runnable {
    /** A[Ď(ms) */
    public static final int TIMER = 5000;

    /* MO */
    private static Logger logger = null;

    private static Color whiteColor = new Color(null, 255, 255, 255);

    private static Color alarmBackColor = new Color(null, 0xFF, 0x99, 0xFF);

    /* Display */
    private Display display;

    /** A[\Text  */
    private Text alarmCountText;

    /**
     * TrapMf[^i[L[IɊĎAe[u\
     * NXCX^X𐶐܂B
     */
    public AlarmTableTimerProcessor() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * A[\eLXgZbg܂B
     *
     * @param alarmCountText A[\eLXg
     */
    public void setAlarmCountText(final Text alarmCountText) {
        this.alarmCountText = alarmCountText;
    }

    /**
     * TrapML[IɊĎAL[Ƀf[^ꍇɂ
     * f[^PopTrapMe[uɕ\܂B
     *
     */
    public void run() {
        /*
         * TrapML[Ď
         */
        ArrayList alarmInfoList = getAlarmList();

        if (alarmCountText.isDisposed()) {
            return;
        }

        if ((alarmInfoList != null) && (alarmInfoList.size() > 0)) {
            long showCount = Long.parseLong(alarmCountText.getText());

            if (alarmInfoList.size() > showCount) {
                /* AlarmobNJ[Zbg */
                alarmCountText.setBackground(alarmBackColor);
            } else {
                alarmCountText.setBackground(whiteColor);
            }
        } else {
            alarmCountText.setBackground(whiteColor);
        }

        // ^C}[p
        display.timerExec(TIMER, this);
    }

    /*
     * f[^x[XA[擾ĕԂ܂B
     *
     */
    private ArrayList getAlarmList() {
        /* A[񃊃Xg */
        ArrayList alarmInfoList = null;

        DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();

        try {
            /* A[擾 */
            alarmInfoList = alarmDBTable.findAllAlarm(0, "all", null, null);
        } catch (SQLException e) {
            logger.warning("Alarm List import error " + e.getMessage());
        } catch (DatabaseConnectionException e) {
            logger.warning("Alarm List import error " + e.getMessage());
        }

        return alarmInfoList;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static AlarmTableTimerProcessor getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * TimersDisplayZbg܂B
     *
     * @param display TimersDisplay
     */
    public void setDisplay(Display display) {
        this.display = display;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final AlarmTableTimerProcessor RESOURCE =
            new AlarmTableTimerProcessor();
    }
}
