/*
 * Created on 2003/08/02
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.statistics;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;


/**
 * vMIB̎悵Af[^x[Xe[uɊi[ɂāA
 * e[ũJm肷邽߂ɁA^[QbgIPAhXɑ
 * 铝vWݒf[^x[Xɓo^܂B
 *
 * vi[pTable쐬 : (IP addressa)_oid_(oid) table
 * 쐬
 *
 * ip127_0_0_1_oid_1_3_6_1_2_1_2_2_1_16_instance
 * OID̃CX^Xi[
 *
 *
 * OID̃CX^XJƂāAvi[
 * ip127_0_0_1_oid_1_3_6_1_2_1_2_2_1_16
@* CX^XJƂēvi[
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class StatisticsMibDBRegister {
    /** 臒lĎȂ */
    public static final String STATISTICS_MIB_NO_THRESHOLD = "0";

    /** 臒lĎ^Cv */
    public static final String STATISTICS_MIB_NO_TYPE = "";

    /* MO */
    private static Logger logger = null;

    /* m[hIPAhX */
    private String targetip;

    /* SNMPo[W */
    private int version;

    /* R~jeB */
    private String community;

    /* SNMPvMIB̎f[^Xg */
    private ArrayList statisList;

    /**
     * OIDMIB̎悵CX^X̗f[^x[X
     * e[u𐶐CX^X𐶐܂B
     *
     * @param targetIP m[hIPAhX
     * @param version o[W
     * @param community R~jeB
     */
    public StatisticsMibDBRegister(
        final String targetIP, final int version, final String community) {
        this.targetip = targetIP;
        this.version = version;
        this.community = community;

        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * vMIB̎悵e[uɊi[܂B
     *
     * @param getOid OID
     * @param period ̎
     * @param threshHold 臒l
     * @param type Ď^Cv
     */
    public void setDatabaseStatisMibInfomation(
        final String getOid, final String period, final String threshHold,
        final String type) {
        statisList = null;

        MibGetNextInfo mibGetInstance = null;

        try {
            // wOID̎
            int checkCount = 0;

            while (mibGetInstance == null) {
                mibGetInstance =
                    MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(
                        targetip, Thread.currentThread().getName());

                try {
                    Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
                } catch (InterruptedException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }

                checkCount++;
                MibGetNextInfoQueue.getInstance().checkTimeout(
                    targetip, getOid, checkCount, version);
            }

            mibGetInstance.setMibGetNext(targetip, version, community);

            // statisList = mibGetInstance.getNextMib(getoid);
            statisList = mibGetInstance.getNextMibValueList(getOid);

            if (statisList != null) {
                // f[^x[Xe[uɃf[^i[
                this.setMibSstatisticsDB(
                    getOid, period, threshHold, type, statisList);
            }
        } catch (UnknownHostException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + getOid + " Period="
                + period + " Threshold=" + threshHold + " Type=" + type);
            e.printStackTrace();
        } catch (SocketException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + getOid + " Period="
                + period + " Threshold=" + threshHold + " Type=" + type);
            e.printStackTrace();
        } catch (SnmpMIBGetException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + getOid + " Period="
                + period + " Threshold=" + threshHold + " Type=" + type);
            e.printStackTrace();
        } finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
                    targetip, Thread.currentThread().getName());
            }
        }
    }

    /**
     * vMIB̎ɂAȉ̃f[^x[Xe[uɏi[܂B
     * EOIDPʂ̃f[^x[Xe[uɃCX^Xi[(IP Address_instance)
     * E̎f[^x[Xe[uɊi[
     *
     * @param oid OID
     * @param period ̎
     * @param threshHold 臒l
     * @param type 臒lĎ^Cvi/ώZj
     * @param statisItemList vf[^i[Xg
     */
    private void setMibSstatisticsDB(
        final String oid, final String period, final String threshHold,
        final String type, final ArrayList statisItemList) {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            DBTableStatisticsMIBControl statisticsMib =
                DBTableStatisticsMIBControl.getInstance();

            for (int j = 0; j < statisItemList.size(); j++) {
                // OIDPʂ̃e[u(IP Address_instance)ɃCX^Xi[
                statisticsMib.putInstanceTable(
                    targetip, oid,
                    ((MibValue) (statisItemList.get(j))).getMibName());

                // IP Address_statisData
                statisticsMib.addStatisticsMibDataColumn(
                    targetip,
                    ((MibValue) (statisItemList.get(j))).getMibName().replace(
                        '.', '_'));
            }

            // vf[^e[ui[
            statisticsMib.putStatisticsTable(
                targetip, oid, period, threshHold, type, statisItemList.size());

            NodeWatchInfo nodeInfo =
                BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(targetip);
            nodeInfo.setStatisticsMIBStatus(NodeWatchInfo.STATISTICS_MIB_OK);
            BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodeInfo);
        } catch (DatabaseConnectionException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + oid + " Period="
                + period + " Threshold=" + threshHold + " Type=" + type);
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + oid + " Period="
                + period + " Threshold=" + threshHold + " Type=" + type);
            e.printStackTrace();
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * vMIB̎XV܂B
     *
     * @param oid ̎OID
     * @param period ̎
     * @param threshHold 臒l
     * @param type Ďʁi/ώZj
     */
    public void updateMibStatisticsSetDatabase(
        final String oid, final String period, final String threshHold,
        final String type) {
        try {
            DBTableStatisticsMIBControl statisticsMib =
                DBTableStatisticsMIBControl.getInstance();
            statisticsMib.updateStatisticsTable(
                targetip, oid, period, threshHold, type);
        } catch (DatabaseConnectionException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + oid + " Period="
                + period + " Threshold=" + threshHold + " Type=" + type);
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community + " OID=" + oid + " Period="
                + period + " Threshold=" + threshHold + " Type=" + type);
            e.printStackTrace();
        }
    }
}
