/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 * SNMP RequestIDێEǗNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class SnmpRequestIDManager {
    /* requestID */
    private static int requestID = 1;

    /* requestIDl */
    private static final int REQUEST_ID_LIMIT = 1000;

    /*
     * NGXgIDL[ƂđMThreadAOIDێCX^X
     * ێMap
     */
    private static Map requestIDMap =
        Collections.synchronizedMap(new HashMap());

    // RXgN^privateɂĕspӂɒڃRXgN^Ăяoh~
    private SnmpRequestIDManager() {
        // nothing
    }

    /**
     * NGXgIDɑΉ郊NGXgIDCX^XԂ܂B
     *
     * @param checkID NGXgID
     * @return NGXgIDCX^X
     */
    public synchronized SnmpRequestID getMsgIDInstance(String checkID) {
        return (SnmpRequestID) requestIDMap.get(checkID);
    }

    /**
     * SNMPNGXgIDԂ܂B
     * ̎AێĂSNMPNGXgJEgAbv܂B
     * ܂ANGXgIDvThreadƃNGXgIDMapɊi[
     * ێ܂B
     * ́ANGXgIDҒlƈvȂꍇ̊Ғl{ɐ
     * ł邩ThreadyїvOIDłmFł悤ɂ邽߂łB
     *
     * @param theadName Thread
     * @param oid OID
     * @return requestID SNMPNGXgID
     */
    public synchronized int getRequestID(String theadName, String oid) {
        requestID++;

        if (requestID > REQUEST_ID_LIMIT) {
            requestID = 1;
        }

        SnmpRequestID requestIDInstance = new SnmpRequestID();
        requestIDInstance.setThreadName(theadName);
        requestIDInstance.setOid(oid);

        requestIDMap.put(Integer.toString(requestID), requestIDInstance);

        return requestID;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static SnmpRequestIDManager getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final SnmpRequestIDManager RESOURCE = new SnmpRequestIDManager();
    }
}
