/*
 * Created on 2004/09/30
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 *
 */
package netjfwatcher.engine.resource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.filepreference.FilePreference;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;


/**
 * SNMP V3p̃\[Xt@C͂NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpV3ManagerConfigFileParse {
    /** XML File Conf ^O */
    public static final String CONF = "conf";

    /** XML target Tag */
    public static final String TARGET = "target";

    /** XML target address Tag */
    public static final String TARGET_ADDRESS = "target_address";

    /** XML Context Tag */
    public static final String CONTEXT_NAME = "contextName";

    /* Logging */
    private static Logger logger = null;

    /* AgentAhXKeyƂSnmpǗێMap */
    private final HashMap<String, SnmpV3ManagerConfigInfo> snmpV3ConfigAddressMapList = new HashMap<String, SnmpV3ManagerConfigInfo>();

    /* Agent SnmpEngineIDKeyƂSnmpǗێMap */
    private final HashMap snmpV3ConfigEngineIDMapList = new HashMap();

    /* AgentAhX */
    private String targetAddress;

    /* Snmp V3 Agnet EngineID */
    private String snmpEngineID;

    /* Snmp V3}l[WƂĊeSnmp V3 AgentǗێ郊Xg */
    private final ArrayList<SnmpV3ManagerConfigInfo> resourceSnmpV3ConfigList = new ArrayList<SnmpV3ManagerConfigInfo>();

    /**
     *
     * ŏɎwfBNgt@C͂邩GW
     * \[X擾܂B
     * wfBNg擾łȂꍇ́AGW
     * \[X擾܂B
     *
     * @throws Exception \[X͂ňُ킪ꍇ
     */
    public SnmpV3ManagerConfigFileParse() throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        logger.info(
            "SNMPV3 Config File Parse : "
            + FilePreference.SNMPV3_MANAGER_RESOURCE_XML_FILE);

        Document doc = null;

        // jart@C邩fBNgwt@C擾邩
        // doc = getDocument(RESOURCE_SNMPV3_XML_FILE);
        doc = getResourceFileDocumentPath(
                FilePreference.SNMPV3_MANAGER_RESOURCE_XML_FILE);

        if (doc == null) {
            logger.severe("Resource File Doc null ");

            return;
        }

        try {
            // rootvfo
            Element root = doc.getRootElement();

            List targetList = root.getChildren(TARGET);

            /* Snmp V3}l[WƂSnmp V3 AgentǗێ */
            SnmpV3ManagerConfigInfo snmpV3ManagerConfigInfo;

            int targetCount = 0;
            Iterator iterator0 = targetList.iterator();

            while (iterator0.hasNext()) {
                try {
                    snmpV3ManagerConfigInfo = new SnmpV3ManagerConfigInfo();
                    targetCount++;

                    Element targetListEl = (Element) iterator0.next();

                    // target_address
                    targetAddress =
                        (targetListEl.getChild(TARGET_ADDRESS))
                        .getAttributeValue(
                            SnmpV3AgentConfigFileParse.XML_FILE_VALUE);
                    snmpV3ManagerConfigInfo.setIpAddress(targetAddress);

                    // snmpEngineID
                    if (
                        (targetListEl.getChild(
                                SnmpV3AgentConfigFileParse.SNMP_ENGINE_ID) != null)
                            && ((targetListEl.getChild(
                                SnmpV3AgentConfigFileParse.SNMP_ENGINE_ID))
                            .getAttributeValue(
                                SnmpV3AgentConfigFileParse.XML_FILE_VALUE) != null)) {
                        snmpEngineID =
                            (targetListEl.getChild(
                                SnmpV3AgentConfigFileParse.SNMP_ENGINE_ID))
                            .getAttributeValue(
                                SnmpV3AgentConfigFileParse.XML_FILE_VALUE);
                        snmpV3ManagerConfigInfo.setSnmpEngineID(snmpEngineID);
                    } else {
                        snmpV3ManagerConfigInfo.setSnmpEngineID("");
                    }

                    if (
                        (targetListEl.getChild(CONTEXT_NAME) != null)
                            && ((targetListEl.getChild(CONTEXT_NAME))
                            .getAttributeValue(
                                SnmpV3AgentConfigFileParse.XML_FILE_VALUE) != null)) {
                        snmpV3ManagerConfigInfo.setContextName(
                            (targetListEl.getChild(CONTEXT_NAME))
                            .getAttributeValue(
                                SnmpV3AgentConfigFileParse.XML_FILE_VALUE));
                    } else {
                        snmpV3ManagerConfigInfo.setContextName("");
                    }

                    if (
                        (targetListEl.getChild("asn1_ber_zero_padding") != null)
                            && ((targetListEl.getChild("asn1_ber_zero_padding"))
                            .getAttributeValue("value") != null)) {
                        snmpV3ManagerConfigInfo.setAsn1BerZeroPadding(
                            (targetListEl.getChild("asn1_ber_zero_padding"))
                            .getAttributeValue("value"));
                    } else {
                        snmpV3ManagerConfigInfo.setAsn1BerZeroPadding("no");
                    }

                    List userList = targetListEl.getChildren("user");
                    Iterator iterator = userList.iterator();

                    while (iterator.hasNext()) {
                        SnmpV3ManagerUserConfigInfo userProperty =
                            new SnmpV3ManagerUserConfigInfo();
                        Element userListEl = (Element) iterator.next();

                        userProperty.setUsername(
                            userListEl.getChild(
                                SnmpV3AgentConfigFileParse.USER_NAME)
                                      .getAttributeValue(
                                SnmpV3AgentConfigFileParse.XML_FILE_VALUE));
                        userProperty.setAuthPriv(
                            userListEl.getChild(
                                SnmpV3AgentConfigFileParse.AUTH_PRIV)
                                      .getAttributeValue(
                                SnmpV3AgentConfigFileParse.XML_FILE_VALUE));
                        userProperty.setAuthProtocol(
                            userListEl.getChild(
                                SnmpV3AgentConfigFileParse.AUTH_PROTOCOL)
                                      .getAttributeValue(
                                SnmpV3AgentConfigFileParse.XML_FILE_VALUE));
                        userProperty.setAuthPassPhrase(
                            userListEl.getChild(
                                SnmpV3AgentConfigFileParse.AUTH_PASSPHRSE)
                                      .getAttributeValue(
                                SnmpV3AgentConfigFileParse.XML_FILE_VALUE));
                        userProperty.setPrivProtocol(
                            userListEl.getChild(
                                SnmpV3AgentConfigFileParse.PRIV_PROTOCOL)
                                      .getAttributeValue(
                                SnmpV3AgentConfigFileParse.XML_FILE_VALUE));
                        userProperty.setPrivPassPhrase(
                            userListEl.getChild(
                                SnmpV3AgentConfigFileParse.PRIV_PASSPHRSE)
                                      .getAttributeValue(
                                SnmpV3AgentConfigFileParse.XML_FILE_VALUE));

                        /* [U[Xgɒǉ */
                        snmpV3ManagerConfigInfo.addUserList(userProperty);
                    }

                    if (!snmpV3ConfigAddressMapList.containsKey(targetAddress)) {
                        snmpV3ConfigAddressMapList.put(
                            targetAddress, snmpV3ManagerConfigInfo);
                        resourceSnmpV3ConfigList.add(snmpV3ManagerConfigInfo);
                    } else {
                        logger.warning("Duplicate Address=" + targetAddress);
                    }
                } catch (NullPointerException e) {
                    e.printStackTrace();
                    logger.warning(
                        "Abort SNMPV3 XML File parse at target No."
                        + targetCount);
                }
            }
        } catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    /**
     * Snmp}l[WŊǗĂSnmp V3 AgentAhX
     * Ԃ܂B
     *
     * @return agentAddressList Snmp V3 AgentAhX
     */
    public String[] getSNMPV3TargetAddress() {
        Map snmpV3ManagerInfoMap =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3ConfigAddresssMapList();

        String[] agentAddressList = new String[snmpV3ManagerInfoMap.size()];

        Iterator it = null;
        int i = 0;

        for (it = snmpV3ManagerInfoMap.entrySet().iterator(); it.hasNext();) {
            Map.Entry ent = (Map.Entry) it.next();
            String snmpV3TargetAddress = (String) ent.getKey();
            SnmpV3ManagerConfigInfo snmpV3ConfigInfo =
                (SnmpV3ManagerConfigInfo) snmpV3ManagerInfoMap.get(
                    snmpV3TargetAddress);

            if (snmpV3ConfigInfo == null) {
                continue;
            }

            agentAddressList[i] = snmpV3TargetAddress;
            i++;
        }

        return agentAddressList;
    }

    /**
     * SNMP V3}l[WBufferedWriterԂ܂B
     *
     * @return bufferedWriter BufferedWriter
     */
    public BufferedWriter getResourceFileWriter() {
        File f = new File(FilePreference.SNMPV3_MANAGER_RESOURCE_XML_FILE);
        logger.info("Path : " + f.getAbsolutePath());

        if (f == null) {
            return null;
        }

        BufferedWriter bufferedWriter = null;

        try {
            FileWriter fi =
                new FileWriter(FilePreference.SNMPV3_MANAGER_RESOURCE_XML_FILE);
            bufferedWriter = new BufferedWriter(fi);
        } catch (IOException e1) {
            e1.printStackTrace();

            return null;
        }

        return bufferedWriter;
    }

    /**
     * wfBNgXMLt@C͂DocumentԂ܂B
     * ijart@ČȂj
     *
     * @param file XMLt@C
     * @return doc Document
     */
    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;

        File f = new File(file);
        logger.info("Path : " + f.getAbsolutePath());

        if (f == null) {
            return null;
        }

        BufferedReader d = null;

        try {
            FileReader fi = new FileReader(file);
            d = new BufferedReader(fi);
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();

            return null;
        }

        try {
            // FileInputStream stream = new FileInputStream(f);
            SAXBuilder builder = new SAXBuilder();

            if (builder == null) {
                return null;
            }

            doc = builder.build(d);
        } catch (JDOMException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return doc;
    }

    /**
     * jart@CXMLt@CE͂DocumentԂ܂B
     *
     * @param file XMLt@C
     * @return doc Document
     */
    protected Document getDocument(String file) {
        Document doc = null;

        URL url = null;

        try {
            /* 摜肷邽߂PluginResource bundle */
            Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
            url = bundle.getEntry(file);

            if (url == null) {
                /* bZ[W\[Xt@CȂꍇMO̎ */
                logger.severe("Resource XML file url : " + url);

                return null;
            }

            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        } catch (JDOMException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        } catch (NullPointerException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        } catch (IOException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        }

        return doc;
    }

    /**
     * \[X񂩂Document𐶐AԂ܂B
     *
     * @param snmpV3List SNMP V3}l[W񃊃Xg
     * @return Document
     */
    public Document updateDocument(ArrayList snmpV3List) {
        logger = Logger.getLogger(this.getClass().getName());

        Element confElement = new Element(CONF);
        Document doc = new Document(confElement);

        if (snmpV3List == null) {
            return null;
        }

        for (int i = 0; snmpV3List.size() > i; i++) {
            // ^[QbgiAgentjSNMPV3Zbg
            SnmpV3ManagerConfigInfo snmpV3Configinf = null;
            snmpV3Configinf = (SnmpV3ManagerConfigInfo) snmpV3List.get(i);

            if (snmpV3Configinf == null) {
                logger.warning("Not found SNMP Config at index=" + i);

                break;
            }

            String targetIPAddress = snmpV3Configinf.getIpAddress();

            SnmpV3ManagerUserConfigInfo snmpV3UserInfo = null;
            snmpV3UserInfo =
                (SnmpV3ManagerUserConfigInfo) snmpV3Configinf.getUserList().get(
                    0);

            if (snmpV3UserInfo == null) {
                logger.warning(
                    "Not found user info at IP="
                    + snmpV3Configinf.getIpAddress());

                break;
            }

            Element target = new Element(TARGET);
            confElement.addContent(target);

            Element targetAddress = new Element(TARGET_ADDRESS);
            target.addContent(targetAddress);

            Element user = new Element("user");
            target.addContent(user);

            if (targetIPAddress != null) {
                targetAddress.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        targetIPAddress));
            } else {
                logger.warning("Not found IP Address");
            }

            Element snmpEngineID =
                new Element(SnmpV3AgentConfigFileParse.SNMP_ENGINE_ID);

            if (snmpV3Configinf.getSnmpEngineID() != null) {
                target.addContent(snmpEngineID);
                snmpEngineID.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3Configinf.getSnmpEngineID()));
            }

            Element contextName = new Element(CONTEXT_NAME);

            if (snmpV3Configinf.getContextName() != null) {
                target.addContent(contextName);
                contextName.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3Configinf.getContextName()));
            } else {
                target.addContent(contextName);
                contextName.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            Element asn1BerZeroPadding = new Element("asn1_ber_zero_padding");

            if (snmpV3Configinf.getAsn1BerZeroPadding() != null) {
                target.addContent(asn1BerZeroPadding);
                asn1BerZeroPadding.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3Configinf.getAsn1BerZeroPadding()));
            }

            // [UZbg
            Element userName =
                new Element(SnmpV3AgentConfigFileParse.USER_NAME);
            Element authPriv =
                new Element(SnmpV3AgentConfigFileParse.AUTH_PRIV);
            Element authProtocol =
                new Element(SnmpV3AgentConfigFileParse.AUTH_PROTOCOL);
            Element authPassPhrase =
                new Element(SnmpV3AgentConfigFileParse.AUTH_PASSPHRSE);
            Element privProtocol =
                new Element(SnmpV3AgentConfigFileParse.PRIV_PROTOCOL);
            Element privPassPhrase =
                new Element(SnmpV3AgentConfigFileParse.PRIV_PASSPHRSE);
            user.addContent(userName);
            user.addContent(authPriv);
            user.addContent(authProtocol);
            user.addContent(authPassPhrase);
            user.addContent(privProtocol);
            user.addContent(privPassPhrase);

            //@AuthPriv Rg
            user.addContent(new Comment("AuthPriv NOAUTH/AUTH/PRIV"));

            //@AuthProtocol Rg
            user.addContent(new Comment("AuthProtocol MD5/SHA"));

            if (snmpV3UserInfo.getUsername() != null) {
                userName.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getUsername()));
            } else {
                userName.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            if (snmpV3UserInfo.getAuthPriv() != null) {
                authPriv.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getAuthPriv()));
            } else {
                authPriv.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            if (snmpV3UserInfo.getAuthProtocol() != null) {
                authProtocol.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getAuthProtocol()));
            } else {
                authProtocol.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            if (snmpV3UserInfo.getAuthPassPhrase() != null) {
                authPassPhrase.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getAuthPassPhrase()));
            } else {
                authPassPhrase.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            if (snmpV3UserInfo.getPrivProtocol() != null) {
                privProtocol.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getPrivProtocol()));
            } else {
                privProtocol.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            if (snmpV3UserInfo.getPrivPassPhrase() != null) {
                privPassPhrase.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getPrivPassPhrase()));
            } else {
                privPassPhrase.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }
        }

        return doc;
    }

    /**
     * SNMP V3\[XXVpDocumentԂ܂B
     *
     * @param resourceInfo  \[X
     * @return Document
     */
    public Document updateDocument(ResourceInfo resourceInfo) {
        logger = Logger.getLogger(this.getClass().getName());

        Element confElement = new Element(CONF);
        Document doc = new Document(confElement);

        // XVSNMPV3\[X񃊃Xgǂݍ
        ArrayList snmpV3List = resourceInfo.getSnmpV3ConfigList();

        if (snmpV3List == null) {
            snmpV3List =
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                   .getResourceSnmpV3ConfigList();
        }

        for (int i = 0; snmpV3List.size() > i; i++) {
            // ^[QbgiAgentjSNMPV3Zbg
            SnmpV3ManagerConfigInfo snmpV3Configinf = null;
            snmpV3Configinf = (SnmpV3ManagerConfigInfo) snmpV3List.get(i);

            String targetIPAddress = snmpV3Configinf.getIpAddress();

            if (snmpV3Configinf == null) {
                logger.warning("Not found SNMP Config at index=" + i);

                break;
            }

            SnmpV3ManagerUserConfigInfo snmpV3UserInfo = null;
            snmpV3UserInfo =
                (SnmpV3ManagerUserConfigInfo) snmpV3Configinf.getUserList().get(
                    0);

            if (snmpV3UserInfo == null) {
                logger.warning("Not found user info at IP=" + targetIPAddress);

                break;
            }

            Element target = new Element(TARGET);
            confElement.addContent(target);

            Element targetAddress = new Element(TARGET_ADDRESS);
            target.addContent(targetAddress);

            Element user = new Element("user");
            target.addContent(user);

            if (targetIPAddress != null) {
                targetAddress.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        targetIPAddress));
            } else {
                logger.warning("Not found IP Address");
            }

            Element snmpEngineID =
                new Element(SnmpV3AgentConfigFileParse.SNMP_ENGINE_ID);

            if (snmpV3Configinf.getSnmpEngineID() != null) {
                target.addContent(snmpEngineID);
                snmpEngineID.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3Configinf.getSnmpEngineID()));
            }

            Element contextName =
                new Element(SnmpV3AgentConfigFileParse.CONTEXT_NAME);

            if (snmpV3Configinf.getContextName() != null) {
                target.addContent(contextName);
                contextName.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3Configinf.getContextName()));
            } else {
                target.addContent(contextName);
                contextName.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            Element asn1BerZeroPadding = new Element("asn1_ber_zero_padding");

            if (snmpV3Configinf.getAsn1BerZeroPadding() != null) {
                target.addContent(asn1BerZeroPadding);
                asn1BerZeroPadding.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3Configinf.getAsn1BerZeroPadding()));
            }

            // [UZbg
            Element userName =
                new Element(SnmpV3AgentConfigFileParse.USER_NAME);
            Element authPriv =
                new Element(SnmpV3AgentConfigFileParse.AUTH_PRIV);
            Element authProtocol =
                new Element(SnmpV3AgentConfigFileParse.AUTH_PROTOCOL);
            Element authPassPhrase =
                new Element(SnmpV3AgentConfigFileParse.AUTH_PASSPHRSE);
            Element privProtocol =
                new Element(SnmpV3AgentConfigFileParse.PRIV_PROTOCOL);
            Element privPassPhrase =
                new Element(SnmpV3AgentConfigFileParse.PRIV_PASSPHRSE);
            user.addContent(userName);
            user.addContent(authPriv);
            user.addContent(authProtocol);
            user.addContent(authPassPhrase);
            user.addContent(privProtocol);
            user.addContent(privPassPhrase);

            //@AuthPriv Rg
            user.addContent(new Comment("AuthPriv NOAUTH/AUTH/PRIV"));

            //@AuthProtocol Rg
            user.addContent(new Comment("AuthProtocol MD5/SHA"));

            if (snmpV3UserInfo.getUsername() != null) {
                userName.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getUsername()));
            } else {
                userName.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            if (snmpV3UserInfo.getAuthPriv() != null) {
                authPriv.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getAuthPriv()));
            } else {
                authPriv.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            if (snmpV3UserInfo.getAuthProtocol() != null) {
                authProtocol.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getAuthProtocol()));
            } else {
                authProtocol.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            if (snmpV3UserInfo.getAuthPassPhrase() != null) {
                authPassPhrase.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getAuthPassPhrase()));
            } else {
                authPassPhrase.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            if (snmpV3UserInfo.getPrivProtocol() != null) {
                privProtocol.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getPrivProtocol()));
            } else {
                privProtocol.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }

            if (snmpV3UserInfo.getPrivPassPhrase() != null) {
                privPassPhrase.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE,
                        snmpV3UserInfo.getPrivPassPhrase()));
            } else {
                privPassPhrase.setAttribute(
                    new Attribute(
                        SnmpV3AgentConfigFileParse.XML_FILE_VALUE, ""));
            }
        }

        return doc;
    }

    /**
     * EngineIDL[ƂSNMP V3G[WFgǗ\[X
     * ێSNMP V3 EngineID MapԂ܂B
     *
     * @return snmpV3ConfigEngineIDMapList
     */
    public HashMap getSnmpV3ConfigEngineIDMapList() {
        return snmpV3ConfigEngineIDMapList;
    }

    /**
     * SNMP V3G[WFgǗ\[Xێ郊Xg
     * Ԃ܂B
     *
     * @return resourceSnmpV3ConfigList SNMP V3G[WFg
     * Ǘ\[Xێ郊Xg
     */
    public ArrayList getResourceSnmpV3ConfigList() {
        return resourceSnmpV3ConfigList;
    }

    /**
     * SNMP V3Ǘ\[Xm[hIPKeyƂĕێMap
     * Ԃ܂B
     *
     * @return snmpV3ConfigAddressMapList SNMP V3Ǘ\[X
     * m[hIPKeyƂĕێMap
     */
    public HashMap getSnmpV3ConfigAddresssMapList() {
        return snmpV3ConfigAddressMapList;
    }

    /**
     * SNMP V3Ǘ\[XXV܂B
     *
     * @param ipAddress m[hIpAhX
     * @param snmpV3ManagerConfInfo SNMP V3Ǘ\[X
     */
    public void updateSnmpV3ManagerConfigInfo(
        String ipAddress, SnmpV3ManagerConfigInfo snmpV3ManagerConfInfo) {
        snmpV3ConfigAddressMapList.put(ipAddress, snmpV3ManagerConfInfo);
    }

    /**
     * SNMP V3Ǘ\[XԂ܂B
     *
     * @param ipAddress m[hIPAhX
     * @return snmpV3ManagerConfInfo SNMP V3Ǘ\[X
     */
    public SnmpV3ManagerConfigInfo getSnmpV3AgentInfo(String ipAddress) {
        SnmpV3ManagerConfigInfo snmpV3ManagerConfInfo = null;

        if (snmpV3ConfigAddressMapList.size() > 0) {
            snmpV3ManagerConfInfo =
                (SnmpV3ManagerConfigInfo) snmpV3ConfigAddressMapList.get(
                    ipAddress);

            if (snmpV3ManagerConfInfo == null) {
                String searchIPAddress = ipAddress;
                String searchHostName = ipAddress;

                try {
                    InetAddress host = InetAddress.getByName(ipAddress);
                    searchIPAddress = host.getHostAddress();
                    searchHostName = host.getHostName();
                } catch (UnknownHostException e2) {
                    logger.warning(
                        "UnknownHostException " + e2.getMessage() + " IP = "
                        + ipAddress);
                }

                snmpV3ManagerConfInfo =
                    (SnmpV3ManagerConfigInfo) snmpV3ConfigAddressMapList.get(
                        searchIPAddress);

                if (snmpV3ManagerConfInfo == null) {
                    snmpV3ManagerConfInfo =
                        (SnmpV3ManagerConfigInfo) snmpV3ConfigAddressMapList
                        .get(searchHostName);
                }
            }
        } else {
            logger.warning("Agent Address List size=0");
        }

        return snmpV3ManagerConfInfo;
    }
}
