/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.CalendarComposite;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarmFilter;
import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.engine.socket.info.AlarmViewFilter;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * Alarm Filter vtFXy[WNXłB Alarm\FilterZbg܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmFilterPreferencePage extends AbstractEnginePreferancePage
		implements IWorkbenchPreferencePage {
	/* eLXg */
	private static final int TEXT_WIDTH = 120;

	/* AlarmtB^[ChJ[h */
	private static final String WILD = "*";
	public static final String ALARM_LEVEL_ERROR = "ERROR";
	public static final String ALARM_LEVEL_WARNING = "WARNING";
	public static final String ALARM_LEVEL_INFO = "INFO";
		
	/* MO */
	private static Logger logger;

	/* Alarm Filter m[h */
	private Text nodeNameText;

	/* Alarm Filter m[h IP Address */
	private Text nodeIPAddressText;

	/* Alarm Filter Alarmx */
	private Combo alarmLevelCombo;

	/* Alarm Filter JnN */
	private Text alarmStartYearText;

	/* Alarm Filter Jn */
	private Text alarmStartMonthText;

	/* Alarm Filter Jn */
	private Text alarmStartDateText;

	/* Alarm Filter IN */
	private Text alarmEndYearText;

	/* Alarm Filter I */
	private Text alarmEndMonthText;

	/* Alarm Filter I */
	private Text alarmEndDateText;

	/* Alarm Filter */
	private Combo confirmCombo;

	/* Alarm Filter */
	private Combo startHourCombo;

	/* Alarm Filter */
	private Combo startMinuteCombo;

	/* Alarm Filter */
	private Combo endHourCombo;

	/* Alarm Filter */
	private Combo endMinuteCombo;

	/* Alarm Filter */
	private CalendarComposite calendarComposite;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
		logger = Logger.getLogger(this.getClass().getName());

		// Initialize the preference store we wish to use
		setPreferenceStore(NetJFWatcherPlugin.getInstance()
				.getPreferenceStore());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		/*
		 * ScrolledComposite scrollComposite = new ScrolledComposite(parent,
		 * SWT.H_SCROLL | SWT.V_SCROLL);
		 * 
		 * GridLayout layout = new GridLayout(1, false);
		 * scrollComposite.setLayout(layout);
		 */
		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, false);
		Composite composite0 = new Composite(parent, SWT.LEFT);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData());

		GridLayout gridLayout = new GridLayout(4, false);
		Composite composite1 = new Composite(composite0, SWT.LEFT);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData());

		gridData = new GridData();

		Label label;
		label = new Label(composite1, SWT.NONE);
		label.setText("Node Name");
		label.setLayoutData(new GridData());

		nodeNameText = new Text(composite1, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		nodeNameText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Node IP Address");
		label.setLayoutData(new GridData());

		nodeIPAddressText = new Text(composite1, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		nodeIPAddressText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Confirm/Unconfirm");
		label.setLayoutData(new GridData());

		confirmCombo = new Combo(composite1, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		confirmCombo.setLayoutData(gridData);
		confirmCombo.add(WILD);
		confirmCombo.add("Unconfirm");
		confirmCombo.add("Confirm");
		confirmCombo.select(0);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Alarm Level");
		label.setLayoutData(new GridData());

		alarmLevelCombo = new Combo(composite1, SWT.BORDER | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		alarmLevelCombo.setLayoutData(gridData);
		alarmLevelCombo.add(WILD);
		alarmLevelCombo.add(ALARM_LEVEL_ERROR);
		alarmLevelCombo.add(ALARM_LEVEL_WARNING);
		alarmLevelCombo.add(ALARM_LEVEL_INFO);
		alarmLevelCombo.select(0);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		GridLayout gridLayout3 = new GridLayout(10, false);
		Composite composite3 = new Composite(composite0, SWT.NONE);
		composite3.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite3.setLayout(gridLayout3);

		Button startDateRadio = new Button(composite3, SWT.RADIO);
		startDateRadio.setText("Start date");
		startDateRadio.setSelection(true);
		startDateRadio.setLayoutData(new GridData());

		alarmStartYearText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 40;
		alarmStartYearText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmStartMonthText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		alarmStartMonthText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText("/");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmStartDateText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		alarmStartDateText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		startHourCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		startHourCombo.setLayoutData(gridData);
		setHourCombo(startHourCombo);
		startHourCombo.select(0);

		label = new Label(composite3, SWT.NONE);
		label.setText(":");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		startMinuteCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		// startMinuteCombo.setLayoutData(gridData);
		setMinuteCombo(startMinuteCombo);
		startMinuteCombo.select(0);

		Button endDateRadio = new Button(composite3, SWT.RADIO);
		endDateRadio.setText("End date");

		// but.setBounds(10,10,120,24);
		endDateRadio.setSelection(false);
		endDateRadio.setLayoutData(new GridData());

		alarmEndYearText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 40;
		alarmEndYearText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmEndMonthText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		alarmEndMonthText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText("/");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmEndDateText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		alarmEndDateText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		endHourCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		endHourCombo.setLayoutData(gridData);
		setHourCombo(endHourCombo);
		endHourCombo.select(0);

		label = new Label(composite3, SWT.NONE);
		label.setText(":");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		endMinuteCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		endMinuteCombo.setLayoutData(gridData);
		setMinuteCombo(endMinuteCombo);
		endMinuteCombo.select(0);

		GridLayout gridLayout2 = new GridLayout(1, false);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite2.setLayout(gridLayout2);

		calendarComposite = new CalendarComposite();
		calendarComposite.setYearText(alarmStartYearText);
		calendarComposite.setMonthText(alarmStartMonthText);
		calendarComposite.setDateText(alarmStartDateText);

		calendarComposite.createCalendarView(composite2);

		try {
			setShowAlarmFilterInfo();
		} catch (DatabaseConnectionException e1) {
			logger.warning(e1.getMessage());
		} catch (SQLException e1) {
			logger.warning(e1.getMessage());
		}

		/*
		 * FilterLԓ̊JnRdio{^IXi[
		 */
		startDateRadio.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				calendarComposite.setYearText(alarmStartYearText);
				calendarComposite.setMonthText(alarmStartMonthText);
				calendarComposite.setDateText(alarmStartDateText);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * FilterLԓ̏IRdio{^IXi[
		 */
		endDateRadio.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				calendarComposite.setYearText(alarmEndYearText);
				calendarComposite.setMonthText(alarmEndMonthText);
				calendarComposite.setDateText(alarmEndDateText);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		return parent;
	}

	/*
	 * Hour Combo Boxݒ肵܂B
	 * 
	 * @param combo Hour Combo Box
	 */
	private void setHourCombo(Combo combo) {
		for (int i = 0; i < 24; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	/*
	 * Minute Combo Boxݒ肵܂B
	 * 
	 * @param combo Minute Combo Box
	 */
	private void setMinuteCombo(Combo combo) {
		for (int i = 0; i < 60; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	/*
	 * A[tB^[\܂B
	 * 
	 */
	private void setShowAlarmFilterInfo() throws DatabaseConnectionException,
			SQLException {

		if (!DatabaseControl.getInstance().isDatabaseStart()) {
			logger.warning("Not running Database.");
			return;
		}
		/*
		 * f[^x[XAlarmtB^[擾
		 */
		AlarmViewFilter alarmViewFilter = null;
		alarmViewFilter = getAlarmFilterFromDatabase();

		if (alarmViewFilter == null) {
			return;
		}

		nodeNameText.setText(alarmViewFilter.getNodename());

		nodeIPAddressText.setText(alarmViewFilter.getIpaddress());

		alarmLevelCombo.setText(alarmViewFilter.getAlarmLevel());

		confirmCombo.setText(alarmViewFilter.getAlarmConfirm());

		/*
		 * LԃZbg
		 */
		String startDateString = "";
		String endDateString = "";
		startDateString = alarmViewFilter.getAlarmStartDate();
		endDateString = alarmViewFilter.getAlarmEndDate();

		if (!startDateString.equals(WILD)) {
			try {
				long startDateLong = Long.parseLong(startDateString);

				Date startDate = new Date(startDateLong);

				Calendar cal = Calendar.getInstance();
				cal.setTime(startDate);

				alarmStartYearText.setText(Integer.toString(cal
						.get(Calendar.YEAR)));
				alarmStartMonthText.setText(Integer.toString((cal
						.get(Calendar.MONTH) + 1)));
				alarmStartDateText.setText(Integer.toString(cal
						.get(Calendar.DATE)));

				String work = Integer.toString(cal.get(Calendar.HOUR_OF_DAY));

				if (work.length() == 1) {
					work = "0" + work;
				}

				startHourCombo.setText(work);
				work = Integer.toString(cal.get(Calendar.MINUTE));

				if (work.length() == 1) {
					work = "0" + work;
				}

				startMinuteCombo.setText(work);
			} catch (NumberFormatException e) {
				// nothing
			}
		} else {
			startHourCombo.select(0);
			startMinuteCombo.select(0);
		}

		if (!endDateString.equals(WILD)) {
			try {
				Date endDate = new Date(Long.parseLong(endDateString));

				Calendar cal = Calendar.getInstance();
				cal.setTime(endDate);

				alarmEndYearText.setText(Integer.toString(cal
						.get(Calendar.YEAR)));
				alarmEndMonthText.setText(Integer.toString((cal
						.get(Calendar.MONTH) + 1)));
				alarmEndDateText.setText(Integer.toString(cal
						.get(Calendar.DATE)));

				String work = Integer.toString(cal.get(Calendar.HOUR_OF_DAY));

				if (work.length() == 1) {
					work = "0" + work;
				}

				endHourCombo.setText(work);
				work = Integer.toString(cal.get(Calendar.MINUTE));

				if (work.length() == 1) {
					work = "0" + work;
				}

				endMinuteCombo.setText(work);
			} catch (NumberFormatException e) {
				// nothing
			}
		}
	}

	private AlarmViewFilter getAlarmFilterFromDatabase()
			throws DatabaseConnectionException, SQLException {

		AlarmViewFilter alarmViewFilter = null;
		DBTableAlarmFilter alarmFilterDBTable = new DBTableAlarmFilter();

		ArrayList alarmFilterList = null;

		/* A[Filter擾 */
		alarmFilterList = alarmFilterDBTable.findAll();

		for (int i = 0; i < alarmFilterList.size(); i++) {
			alarmViewFilter = (AlarmViewFilter) alarmFilterList.get(i);
		}

		return alarmViewFilter;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
	 */
	protected void performDefaults() {

		try {
			setShowAlarmFilterInfo();
		} catch (DatabaseConnectionException e1) {
			logger.warning(e1.getMessage());
		} catch (SQLException e1) {
			logger.warning(e1.getMessage());
		}

		nodeNameText.setText(WILD);
		nodeIPAddressText.setText(WILD);
		alarmLevelCombo.select(0);
		alarmStartYearText.setText("");
		alarmStartMonthText.setText("");
		alarmStartDateText.setText("");
		alarmEndYearText.setText("");
		alarmEndMonthText.setText("");
		alarmEndDateText.setText("");
		confirmCombo.select(0);
		startHourCombo.select(0);
		startMinuteCombo.select(0);
		endHourCombo.select(0);
		endMinuteCombo.select(0);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	public boolean performOk() {
		if (!DatabaseControl.getInstance().isDatabaseStart()) {
			logger.warning("Not running Database.");
			MessageDialog.openError(getShell(), "Error",
					"Not running Database.");
			return false;
		}
		try {
			AlarmViewFilter alarmFilterInfo = null;
			alarmFilterInfo = getAlarmFilterFromDatabase();

			alarmFilterInfo = createAlarmFilterDate(alarmFilterInfo);

			String nodeName = nodeNameText.getText();
			String ipAddress = nodeIPAddressText.getText();
			String alarmLevel = alarmLevelCombo.getText();
			String alarmConfirm = confirmCombo.getText();

			alarmFilterInfo.setNodename(nodeName);

			alarmFilterInfo.setIpaddress(ipAddress);

			alarmFilterInfo.setAlarmConfirm(alarmConfirm);

			alarmFilterInfo.setAlarmLevel(alarmLevel);

			DBTableAlarmFilter alarmFilterDBTable = new DBTableAlarmFilter();
			alarmFilterDBTable.updateAlarmFilter(alarmFilterInfo);
		} catch (DatabaseConnectionException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
			MessageDialog.openError(getShell(), "Error", e.getMessage());

		} catch (SQLException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
			MessageDialog.openError(getShell(), "Error", e.getMessage());

		}

		return super.performOk();
	}

	/*
	 * Textɕ\ĂԎwA[tB^[ ĕԂ܂B
	 * 
	 * @return alarmFilterInfo AlarmViewFilter
	 */
	private AlarmViewFilter createAlarmFilterDate(
			AlarmViewFilter alarmFilterInfo) {
		int year = 0;
		int month = 0;
		int date = 0;
		int hour = 0;
		int minute = 0;

		if ((alarmStartYearText.getText() != null)
				&& !alarmStartYearText.getText().equals("")) {
			String startYearString = alarmStartYearText.getText();
			String startMonthString = alarmStartMonthText.getText();
			String startDateString = alarmStartDateText.getText();

			String startHourString = startHourCombo.getText();
			String startMinuteString = startMinuteCombo.getText();

			try {
				year = Integer.parseInt(startYearString);
				month = Integer.parseInt(startMonthString);
				date = Integer.parseInt(startDateString);
				hour = Integer.parseInt(startHourString);
				minute = Integer.parseInt(startMinuteString);

				Calendar cal = Calendar.getInstance();
				cal.set(year, month - 1, date, hour, minute);

				String startDate = Long.toString(cal.getTimeInMillis());
				alarmFilterInfo.setAlarmStartDate(startDate);
			} catch (NumberFormatException e) {
				e.printStackTrace();
			}
		} else {
			alarmFilterInfo.setAlarmStartDate(WILD);
		}

		if ((alarmEndYearText.getText() != null)
				&& !alarmEndYearText.getText().equals("")) {
			String endYearString = alarmEndYearText.getText();
			String endMonthString = alarmEndMonthText.getText();
			String endDateString = alarmEndDateText.getText();

			String endHourString = endHourCombo.getText();
			String endMinuteString = endMinuteCombo.getText();

			try {
				year = Integer.parseInt(endYearString);
				month = Integer.parseInt(endMonthString);
				date = Integer.parseInt(endDateString);
				hour = Integer.parseInt(endHourString);
				minute = Integer.parseInt(endMinuteString);

				Calendar cal = Calendar.getInstance();
				cal.set(year, month - 1, date, hour, minute);

				String endDate = Long.toString(cal.getTimeInMillis());
				alarmFilterInfo.setAlarmEndDate(endDate);
			} catch (NumberFormatException e) {
				e.printStackTrace();
			}
		} else {
			alarmFilterInfo.setAlarmEndDate(WILD);
		}

		return alarmFilterInfo;
	}
}
