/*
 * Created on 2007/02/04
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm.trap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class AlarmTrapResourceFileParse {

	private static final String XML_FILE_VALUE = "value";

	private static final String ROOT = "root";

	private static final String ALARM_TRAP_FLAG = "alarm_trap_flag";

	private static final String TRAP_SEND_ADDRESS = "alarm_trap_send_address";

	private static final String ALARM_TRAP_LEVEL = "alarm_trap_level";

	private String alarmTrapFlag;

	private String serverAddress;

	private String alarmTrapLevel;

	/* Logging */
	private static Logger logger = null;

	/**
	 * 
	 * wfBNgt@C͂ă\[Xێ܂B
	 * 
	 * @throws Exception
	 *             \[X͂Ɏsꍇ
	 */
	public AlarmTrapResourceFileParse() {
		logger = Logger.getLogger(this.getClass().getName());
		setTrapForwardInfo();
	}

	public void setTrapForwardInfo() {

		Document doc = null;

		// jart@C邩fBNgwt@C擾邩
		// doc = getDocument(TrapPreference.TRAP_FORWARD_CONF_FILE);
		doc = getResourceFileDocumentPath(AlarmTrapPreference.ALARM_TRAP_CONF_FILE);

		if (doc == null) {
			logger.severe("Resource File Doc null ");

			return;
		}

		try {

			// rootvfo
			Element root = doc.getRootElement();
			Element alarmTrapFlagEl = root.getChild(ALARM_TRAP_FLAG);
			Element alarmSendAddressEl = root.getChild(TRAP_SEND_ADDRESS);
			Element alarmTrapLevelEl = root.getChild(ALARM_TRAP_LEVEL);

			alarmTrapFlag = alarmTrapFlagEl.getAttributeValue(XML_FILE_VALUE);
			serverAddress = alarmSendAddressEl
					.getAttributeValue(XML_FILE_VALUE);
			alarmTrapLevel = alarmTrapLevelEl.getAttributeValue(XML_FILE_VALUE);

		} catch (NullPointerException e) {
			e.printStackTrace();
		}
	}

	/**
	 * \[XBufferedWriterԂ܂B
	 * 
	 * @return bufferedWriter \[XBufferedWriter
	 */
	public BufferedWriter getResourceFileWriter() {
		File f = new File(AlarmTrapPreference.ALARM_TRAP_CONF_FILE);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			return null;
		}

		BufferedWriter bufferedWriter = null;

		try {
			FileWriter fi = new FileWriter(
					AlarmTrapPreference.ALARM_TRAP_CONF_FILE);
			bufferedWriter = new BufferedWriter(fi);
		} catch (IOException e1) {
			e1.printStackTrace();

			return null;
		}

		return bufferedWriter;
	}

	/**
	 * wfBNgXMLt@C͂DocumentԂ܂B ijart@ČȂj
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	public Document getResourceFileDocumentPath(String file) {
		Document doc = null;

		File f = new File(file);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			logger.warning("Abort create File : " + f.getAbsolutePath());

			return null;
		}

		BufferedReader d = null;

		try {
			FileReader fi = new FileReader(file);
			d = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			logger.warning("FileNotFoundException : " + f.getPath() + " : "
					+ e1.getMessage());
			logger.warning("FileNotFoundException : " + f.getAbsolutePath()
					+ " : " + e1.getMessage());
			e1.printStackTrace();

			return null;
		}

		try {
			// FileInputStream stream = new FileInputStream(f);
			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(d);
		} catch (JDOMException e) {
			logger.warning("JDOMException : " + e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.warning("NullPointerException : " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.warning("IOException : " + e.getMessage());
			e.printStackTrace();
		}

		return doc;
	}

	/**
	 * jart@CXMLt@CE͂DocumentԂ܂B
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	protected Document getDocument(String file) {
		Document doc = null;

		URL url = null;

		try {

			Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
			url = bundle.getEntry(file);

			if (url == null) {
				/* bZ[W\[Xt@CȂꍇMO̎ */
				logger.severe("Resource XML file url : " + url);

				return null;
			}

			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(url.openStream());
		} catch (JDOMException e) {
			logger.severe("JDOMException URL= " + url + " " + e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.severe("NullPointerException URL= " + url + " "
					+ e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.severe("IOException URL= " + url + " " + e.getMessage());
			e.printStackTrace();
		}

		return doc;
	}

	/**
	 * \[X񂩂Document𐶐AԂ܂B
	 * 
	 * @param updateResourceInfo
	 *            \[X
	 * @return Document
	 */
	public Document updateDocument(String trapFlag, String trapAddress,
			String trapLevel) {
		logger = Logger.getLogger(this.getClass().getName());

		Element rootElement = new Element(ROOT);
		Document doc = new Document(rootElement);

		Element alarmTrapFlagEl = new Element(ALARM_TRAP_FLAG);
		Element alarmTrapAddressEl = new Element(TRAP_SEND_ADDRESS);
		Element alarmTrapLevelEl = new Element(ALARM_TRAP_LEVEL);

		rootElement.addContent(alarmTrapFlagEl);
		rootElement.addContent(alarmTrapAddressEl);
		rootElement.addContent(alarmTrapLevelEl);

		alarmTrapFlagEl.setAttribute(new Attribute(XML_FILE_VALUE, trapFlag));
		alarmTrapAddressEl.setAttribute(new Attribute(XML_FILE_VALUE,
				trapAddress));
		alarmTrapLevelEl.setAttribute(new Attribute(XML_FILE_VALUE, trapLevel));

		return doc;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static AlarmTrapResourceFileParse getInstance() {
		return SingletonResource.TRAP_FORWARD_DEFINE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final AlarmTrapResourceFileParse TRAP_FORWARD_DEFINE = new AlarmTrapResourceFileParse();
	}

	public String getServerAddress() {
		return serverAddress;
	}

	public String getAlarmTrapFlag() {
		return alarmTrapFlag;
	}

	public String getAlarmTrapLevel() {
		return alarmTrapLevel;
	}

}
