/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;


/**
 * Alarm𒆌pL[ƂȂNXłB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AlarmMessageQueue {
    public static final int LIMIT = 10;

    /* L[郊Xg */
    private static List<AlarmCodeInformation> alarmQueueList;
    private int writePoint = 0;

    /**
     * AlarmL[CX^X𐶐܂B
     *
     */
    private AlarmMessageQueue() {
        alarmQueueList = Collections.synchronizedList(new LinkedList<AlarmCodeInformation>());
    }

    /**
     * AlarmL[Push܂B
     *
     * @param obj Alarmi[ArrayList
     */
    public synchronized void pushAlarmData(final AlarmCodeInformation obj) {
    	alarmQueueList.add(writePoint, obj);
    	writePoint++;
        if (writePoint >= LIMIT) {
            writePoint = 0;
        }

        
    }

    /**
     * L[AlarmPop܂B
     *
     * @param readPoint Alarm擾ʒu
     * @return obj Alarm
     */
    public synchronized AlarmCodeInformation popAlarmData(int readPoint) {
    	AlarmCodeInformation alarmDataObj = null;

        if (alarmQueueList.size() > 0) {
            alarmDataObj = (AlarmCodeInformation)alarmQueueList.get(readPoint);
        }

        return alarmDataObj;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static AlarmMessageQueue getInstance() {
        return SingletonResource.ALARM_MESSAGE_QUEUE;
    }

    public int getWritePoint() {
        return writePoint;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final AlarmMessageQueue ALARM_MESSAGE_QUEUE =
            new AlarmMessageQueue();
    }
}
