/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.common.view;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;


/**
 * J_[Composite𐶐NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CalendarComposite {
    /* J_[̓I̔NZbgTextŁÃNX
     * CX^XgpNXݒ
     */
    private Text yearText;
    private Text endYearText;

    /* J_[̓ǏZbgTextŁÃNX
     * CX^XgpNXݒ
     */
    private Text monthText;
    private Text endMonthText;

    /* J_[̓I̓ZbgTextŁÃNX
     * CX^XgpNXݒ
     */
    private Text dateText;
    private Text endDateText;

	private Combo dayOfMonthCombo;
	private Combo dayOfWeekCombo;
	
    /* \ĂJ_[̔N\Text */
    private Text displayText;

    /* J_[\e[u */
    private CalendarTable calendarTable;

    /* Table */
    private Table table;

    /**
     * J_[View𐶐܂B
     *
     * @param baseComposite CalendarTablezuComposite
     * @return baseComposite CalendarTablezuComposite
     */
    public Composite createCalendarView(Composite baseComposite) {
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite = new Composite(baseComposite, SWT.NULL);
        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));

        // J_[Rg[ Composite̍쐬
        Composite ctlComp = new Composite(baseComposite, SWT.NO_FOCUS);
        ctlComp.setLayout(new GridLayout(2, true));

        GridData compData = new GridData();
        compData.horizontalAlignment = GridData.FILL;
        ctlComp.setLayoutData(compData);

        // TextBox ̍쐬
        displayText = new Text(ctlComp, SWT.SINGLE | SWT.BORDER);

        GridData textData = new GridData(GridData.FILL_HORIZONTAL);
        displayText.setLayoutData(textData);

        // {^ Composite̍쐬
        Composite buttonComp = new Composite(ctlComp, SWT.NO_FOCUS);
        buttonComp.setLayout(new GridLayout(3, true));

        GridData buttonData = new GridData(GridData.FILL);
        buttonData.horizontalAlignment = GridData.END;
        buttonComp.setLayoutData(buttonData);

        // {^̍쐬
        Button buttonPrev = new Button(buttonComp, SWT.PUSH);
        buttonPrev.setText("<<");
        buttonPrev.addListener(
            SWT.Selection,
            new Listener() {
                public void handleEvent(Event e) {
                    displayText.setText(calendarTable.setPrevMonth());
                }
            });

        Button buttonThisMonth = new Button(buttonComp, SWT.PUSH);
        buttonThisMonth.setText("");
        buttonThisMonth.addListener(
            SWT.Selection,
            new Listener() {
                public void handleEvent(Event e) {
                    displayText.setText(calendarTable.setThisMonth());
                }
            });

        Button buttonNext = new Button(buttonComp, SWT.PUSH);
        buttonNext.setText(">>");
        buttonNext.addListener(
            SWT.Selection,
            new Listener() {
                public void handleEvent(Event e) {
                    displayText.setText(calendarTable.setNextMonth());
                }
            });

        // CalendarTable ̍쐬
        calendarTable =
            new CalendarTable(
                baseComposite, SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
        displayText.setText(calendarTable.setThisMonth());

        // ݂̓\Label̍쐬
        Label label = new Label(baseComposite, SWT.NONE);
        label.setText(" Today : " + calendarTable.getTodaysYYMMDD());

        /* J_[IXi[Zbg */
        table = calendarTable.getTable();

        /*
         * Mouse downŃJ_[̑IN擾
         */
        table.addMouseListener(
            new MouseAdapter() {

                public void mouseDown(MouseEvent event) {
                    int index = table.getSelectionIndex();

                    if (index == -1) {
                        return;
                    }

                    /* TableI */
                    table.setSelection(new int[0]);

                    TableItem item = table.getItem(index);
                    Point point = new Point(event.x, event.y);

                    for (int i = 0; i < table.getColumnCount(); i++) {
                        // IꂽWZ̈Ɋ܂܂Ă邩𔻒
                        if (item.getBounds(i).contains(point)) {
                            if (item.getText(i) == null) {
                                // J_[IɂTableItemnullł͉return
                            } else if (item.getText(i).equals("")) {
                                // J_[Ȉꍇreturn
                            } else {
                                // J_[I̔NAAtText\
                                if (yearText != null) {
                                    yearText.setText(
                                        calendarTable.getSelectYear());
                                }

                                if (endYearText != null) {
                                    endYearText.setText(
                                        calendarTable.getSelectYear());
                                }

                                if (monthText != null) {
                                    monthText.setText(
                                        calendarTable.getSelectMonth());
                                }

                                if (endMonthText != null) {
                                    endMonthText.setText(
                                        calendarTable.getSelectMonth());
                                }

                                if (dateText != null) {
                                    dateText.setText(item.getText(i));
                                }

                                if (endDateText != null) {
                                    endDateText.setText(item.getText(i));
                                }
                                
                                if (dayOfMonthCombo != null) {
                                	dayOfMonthCombo.select(Integer.parseInt(item.getText(i)) - 1);
                                }
                            	if (dayOfWeekCombo != null) {
                            		dayOfWeekCombo.select(i);
                            	}
                            }
                        }
                    }
                }
            });

        return baseComposite;
    }

    /**
     * JnTextZbg܂B
     *
     * @param dateText  JnText
     */
    public void setDateText(Text dateText) {
        this.dateText = dateText;
    }

    /**
     * JnTextZbg܂B
     *
     * @param monthText  JnText
     */
    public void setMonthText(Text monthText) {
        this.monthText = monthText;
    }

    /**
     * JnNTextZbg܂B
     *
     * @param yearText  JnNText
     */
    public void setYearText(Text yearText) {
        this.yearText = yearText;
    }

    /**
     * ITextZbg܂B
     *
     * @param date2Text IText
     */
    public void setEndDateText(Text date2Text) {
        this.endDateText = date2Text;
    }

    /**
     * ITextZbg܂B
     *
     * @param month2Text IText
     */
    public void setEndMonthText(Text month2Text) {
        this.endMonthText = month2Text;
    }

    /**
     * INTextZbg܂B
     *
     * @param year2Text INText
     */
    public void setEndYearText(Text year2Text) {
        this.endYearText = year2Text;
    }

    /**
     * CalendarTableԂ܂B
     *
     * @return calendarTable CalendarTable
     */
    public CalendarTable getCalendarTable() {
        return calendarTable;
    }

	public void setDayOfMonthCombo(Combo dayOfMonthCombo) {
		this.dayOfMonthCombo = dayOfMonthCombo;
	}

	public void setDayOfWeekCombo(Combo dayOfWeekCombo) {
		this.dayOfWeekCombo = dayOfWeekCombo;
	}
}
