/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.common;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;


/**
 * TableōsNbNꂽꍇ̃Xi[NXłB
 * Jɕ\郁bZ[WJ𒴂ꍇɃJg
 * \bh܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TableColumnControlTableListener extends SelectionAdapter {
    /* Table */
    private Table table;

    /* Jԍ */
    private int controlColumn;

    /* J */
    private int initWidth;

    /**
     * TableōsNbNꂽꍇ̃Xi[NXCX^X𐶐܂B
     *
     * @param table Table
     * @param controlColumn Jԍ
     */
    public TableColumnControlTableListener(Table table, int controlColumn) {
        this.table = table;
        this.controlColumn = controlColumn;
    }

    /**
     * TableJIłB
     *
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {
        /* e[uIs(Row)o */
        int index = table.getSelectionIndex();

        if (index == -1) {
            return;
        }

        TableColumn column = table.getColumn(controlColumn);

        /* Iꂽs(Row)TableItem擾 */
        TableItem item = table.getItem(index);

        /*
         * IꂽRow̃bZ[WƃtHgZbgׂJ
         * 擾
         */
        String message = item.getText(controlColumn);
        FontData[] data = item.getFont().getFontData();
        int setWidth = message.length() * ((data[0].height * 2) / 3);

        /*
         * JZbg
         */
        if (initWidth == 0) {
            initWidth = column.getWidth();
        }

        /*
         * ZoJƌ̃Jr
         */
        if (column.getWidth() == setWidth) {
            column.setWidth(initWidth);
        } else {
            if (initWidth < setWidth) {
                /*
                     * ZoJ̕傫ꍇ́A
                     * ̃JZbg
                     */
                column.setWidth(setWidth);
            } else {
                /*
                     * ̃J傫ꍇɂ͂̃J
                     * Zbg
                     */
                column.setWidth(initWidth);
            }
        }
    }
}
