/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import netjfwatcher.engine.common.model.NodeInformationXMLTag;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.node.NodeOperationView;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.webbrowser.model.DocumentParseErrorHandler;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;


/**
 * m[hꊇo^s\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeUploadFile {
    /*
     * m[hĎzɊi[邽߂̔z̃|WV
     */

    /** m[h̊i[ʒu */
    public static final int NODENAME_NUMBER = 0;

    /** m[hIPAhX̊i[ʒu */
    public static final int IPADDRESS_NUMBER = 1;

    /** m[hO[v̊i[ʒu */
    public static final int GROUP_NUMBER = 2;

    /** GWAhX̊i[ʒu */
    public static final int ENGINE_ADDRESS_NUMBER = 3;

    /** m[hIcon XW̊i[ʒu */
    public static final int NODE_X_NUMBER = 4;

    /** m[hIcon YW̊i[ʒu */
    public static final int NODE_Y_NUMBER = 5;

    /** m[hʂ̊i[ʒu */
    public static final int NODEKIND_NUMBER = 6;

    /** PingĎ̊i[ʒu */
    public static final int PING_PERIOD_NUMBER = 7;

    /** PingĎ臒l̊i[ʒu */
    public static final int PING_THRESHHOLD_NUMBER = 8;

    /** SNMPo[W̊i[ʒu */
    public static final int SNMP_VERSION_NUMBER = 9;

    /** SNMPĎx̊i[ʒu */
    public static final int SNMP_LEVEL_NUMBER = 10;

    /** SNMPĎ̊i[ʒu */
    public static final int SNMP_PERIOD_NUMBER = 11;

    /** SNMP ReadR~jeB̊i[ʒu */
    public static final int SNMP_ROCOMMUNITY_NUMBER = 12;

    /** SNMp WriteR~jeB̊i[ʒu */
    public static final int SNMP_RWCOMMUNITY_NUMBER = 13;

    /** SNMPĎ^CAEgl̊i[ʒu */
    public static final int SNMP_TIMEOUT_NUMBER = 14;

    /** HTTPĎ̊i[ʒu */
    public static final int HTTP_PERIOD_NUMBER = 15;

    /** HTTPĎ|[g̊i[ʒu */
    public static final int HTTP_PORT_NUMBER = 16;

    /** HTTPĎ^CAEgl̊i[ʒu */
    public static final int HTTP_TIMEOUT_NUMBER = 17;

    /** HTTPĎURL̊i[ʒu */
    public static final int HTTP_URL_NUMBER = 18;

    /** PopĎ̊i[ʒu */
    public static final int POP3_PERIOD_NUMBER = 19;

    /** PopĎ|[g̊i[ʒu */
    public static final int POP3_PORT_NUMBER = 20;

    /** PopĎ^CAEgl̊i[ʒu */
    public static final int POP3_TIMEOUT_NUMBER = 21;

    /** PopĎ[Ůi[ʒu */
    public static final int POP3_USER_NUMBER = 22;

    /** PopĎpX[h̊i[ʒu */
    public static final int POP3_PASSWORD_NUMBER = 23;

    /** SMTPĎ̊i[ʒu */
    public static final int SMTP_PERIOD_NUMBER = 24;

    /** SMTPĎ|[g̊i[ʒu */
    public static final int SMTP_PORT_NUMBER = 25;

    /** SMTPĎ^CAEgl̊i[ʒu */
    public static final int SMTP_TIMEOUT_NUMBER = 26;

    /** SMTPĎMAhX̊i[ʒu */
    public static final int SMTP_SEND_ADDRESS_NUMBER = 27;

    /** SMTPĎmFpPopzXg̊i[ʒu */
    public static final int SMTP_CHECK_POP_HOST_NUMBER = 28;

    /** SMTPĎmFpPop|[g̊i[ʒu */
    public static final int SMTP_CHECK_POP_PORT_NUMBER = 29;

    /** SMTPĎmFpPop^CAEgl̊i[ʒu */
    public static final int SMTP_CHECK_POP_TIMEOUT_NUMBER = 30;

    /** SMTPĎmFpPop[Ůi[ʒu */
    public static final int SMTP_CHECK_POP_USER_NUMBER = 31;

    /** SMTPĎmFpPoppX[h̊i[ʒu */
    public static final int SMTP_CHECK_POP_PASSWORD_NUMBER = 32;

    /** m[hĎ^OiXMLt@CGNX|[g/C|[gpjLqz */
    public static final String[] NODE_INFO_DESCRIBE_ARRAY =
        {
            NodeInformationXMLTag.NODENAME, NodeInformationXMLTag.IPADDRESS,
            NodeInformationXMLTag.GROUP, NodeInformationXMLTag.ENGINE_ADDRESS,
            NodeInformationXMLTag.NODE_X, NodeInformationXMLTag.NODE_Y,
            NodeInformationXMLTag.NODEKIND, NodeInformationXMLTag.PING_PERIOD,
            NodeInformationXMLTag.PING_THRESHHOLD,
            NodeInformationXMLTag.SNMP_VERSION, NodeInformationXMLTag.SNMP_LEVEL,
            NodeInformationXMLTag.SNMP_PERIOD,
            NodeInformationXMLTag.SNMP_ROCOMMUNITY,
            NodeInformationXMLTag.SNMP_RWCOMMUNITY,
            NodeInformationXMLTag.SNMP_TIMEOUT,
            
            NodeInformationXMLTag.HTTP_PERIOD, NodeInformationXMLTag.HTTP_PORT,
            NodeInformationXMLTag.HTTP_TIMEOUT, NodeInformationXMLTag.HTTP_URL,
            
            NodeInformationXMLTag.POP3_PERIOD, NodeInformationXMLTag.POP3_PORT,
            NodeInformationXMLTag.POP3_TIMEOUT, NodeInformationXMLTag.POP3_USER,
            NodeInformationXMLTag.POP3_PASSWORD,
            
            NodeInformationXMLTag.SMTP_PERIOD, NodeInformationXMLTag.SMTP_PORT,
            NodeInformationXMLTag.SMTP_TIMEOUT,
            NodeInformationXMLTag.SMTP_SEND_ADDRESS,
            NodeInformationXMLTag.SMTP_CHECK_POP3_HOST,
            NodeInformationXMLTag.SMTP_CHECK_POP3_PORT,
            NodeInformationXMLTag.SMTP_CHECK_POP3_TIMEOUT,
            NodeInformationXMLTag.SMTP_CHECK_POP3_USER,
            NodeInformationXMLTag.SMTP_CHECK_POP3_PASSWORD
        };

    /** obt@TCY */
    public static final int BUFF_SIZE = 512 * 1000;

    /** m[ho^ő吔 */
    public static final int NODE_MAX = 500;

    /** m[hNő吔 */
    public static final int NODE_LINK_MAX = 500;

    /* MO */
    private static Logger logger = null;

    /* m[hĎ񃊃Xg */
    private ArrayList nodeInfoList = null;

    /* m[hNXg */
    private ArrayList linkList = null;

    /**
     * Abv[hꂽt@C񂩂m[ḧꊇo^s܂B
     *
     * @param file m[hꊇo^Abv[ht@C
     * @throws FileNotFoundException t@CȂꍇ
     * @throws Exception t@C͂Ɏsꍇ
     */
    public void upload(String file) throws FileNotFoundException, Exception {
        logger = Logger.getLogger(this.getClass().getName());

        File f = new File(file);

        FileInputStream stream = null;

        /* XMLt@C͗p Document */
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;

        try {
            stream = new FileInputStream(f);

            /* XMLt@Ć@*/
            /* DOMp[Tpt@Ng̐ */
            dbfactory = DocumentBuilderFactory.newInstance();

            /* Ó؂s */
            dbfactory.setValidating(true);

            /* DOM DocumentCX^Xpt@Ng̐ */
            builder = dbfactory.newDocumentBuilder();

            /* G[nh̓o^ */
            builder.setErrorHandler(new DocumentParseErrorHandler());

            /* XMLt@C */
            dom = builder.parse(stream);

            if (dom != null) {
                Element root = dom.getDocumentElement();
                Node firstChildNode = root.getFirstChild();

                /* XMLt@C͂ăm[h擾
                 */
                nodeInfoList = this.parseNode(firstChildNode);

                /*
                 * XMLt@C͂ăN擾
                 */
                linkList = this.parseLink(firstChildNode);
            }
        } catch (FileNotFoundException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        } catch (Exception e) {
            /* ȉ̗Ocatch
             * EDocumentBuilderŗO
             * iParserConfigurationExceptionj
             * EXMLt@C͂ō\̓G[iSAXExceptionj
             * EXMLt@C͂œo̓G[iIOExceptionj
             */
            logger.warning(e.getMessage());
            throw e;
        } finally {
            if (stream != null) {
                try {
                    stream.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    /**
     * m[hXML͂āAm[h񃊃XgԂ܂B
     *
     * @param firstChildNode rootNode
     * @return m[hi[ArrayList
     */
    private ArrayList parseNode(final Node firstChildNode) {
        Node childNode = firstChildNode;

        // XMLNODE_INFO_ROOT_TAG = "Node"Fm[hĎ^O܂Ō
        while (childNode != null) {
            try {
                if (
                    (childNode != null)
                        && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                    if (
                        childNode.getNodeName().equals(
                                NodeInformationXMLTag.NODE_INFO_ROOT_TAG)) {
                        // XMLNODE_INFO_ROOT_TAG = "Node"Fm[hĎ^Obreak
                        childNode = childNode.getFirstChild();

                        break;
                    }
                }

                childNode = childNode.getNextSibling();
            } catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        ArrayList<String[]> nodeList = new ArrayList<String[]>();

        while (childNode != null) {
            try {
                System.out.println("getNodeName0 : " + childNode.getNodeName());
                System.out.println("getNodeType0 : " + childNode.getNodeType());
                System.out.println(
                    "getNodeValue0 : " + childNode.getNodeValue());

                /* X̃m[hĎ^ONODE_INFO_TAG = "Node_Property"o
                 * m[hĎ𒊏oĔzɊi[AzXgɒǉ
                 *
                 */
                if (
                    (childNode != null)
                        && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                    if (
                        childNode.getNodeName().equals(
                                NodeInformationXMLTag.NODE_INFO_TAG)) {
                        Node nodeInfoChildNodeLeaf = childNode.getFirstChild();

                        // Lȃm[hĎ񌟍tO
                        boolean hit = false;
                        String[] nodeInfo =
                            new String[NODE_INFO_DESCRIBE_ARRAY.length];

                        while (nodeInfoChildNodeLeaf != null) {
                            /* System.out.println(
                                "getNodeName1 : "
                                + nodeInfoChildNodeLeaf.getNodeName());
                            System.out.println(
                                "getNodeType1 : "
                                + nodeInfoChildNodeLeaf.getNodeType());
                            System.out.println(
                                "getNodeValue1 : "
                                + nodeInfoChildNodeLeaf.getNodeValue());
                            */

                            if (
                                nodeInfoChildNodeLeaf.getNodeType() == Node.ELEMENT_NODE) {
                                // Node TypeElementł΁ANodeĎ񑮐ƈv邩`FbN
                                for (
                                    int i = 0;
                                        i < NODE_INFO_DESCRIBE_ARRAY.length;
                                        i++) {
                                    // NodeĎ񑮐ƈvAElement TypełΒlzɊi[
                                    if (
                                        nodeInfoChildNodeLeaf.getNodeName()
                                                                 .equals(
                                                NODE_INFO_DESCRIBE_ARRAY[i])) {
                                        Node firstNodeText = null;
                                        String leafItemValue = null;

                                        if (nodeInfoChildNodeLeaf != null) {
                                            firstNodeText =
                                                nodeInfoChildNodeLeaf
                                                .getFirstChild();

                                            if (firstNodeText != null) {
                                                leafItemValue =
                                                    firstNodeText.getNodeValue();
                                            }
                                        }

                                        // id=m[h̘AԁAi=m[hĎԍ
                                        nodeInfo[i] = leafItemValue;
                                        hit = true;

                                        break;
                                    }
                                }
                            }

                            nodeInfoChildNodeLeaf =
                                nodeInfoChildNodeLeaf.getNextSibling();
                        }

                        if (hit) {
                            nodeList.add(nodeInfo);
                        }
                    }

                    childNode = childNode.getNextSibling();
                }

                childNode = childNode.getNextSibling();
            } catch (DOMException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        // o^m[hIPAhXo
        for (int j = 0; j < nodeList.size(); j++) {
            for (int l = 0; l < NODE_INFO_DESCRIBE_ARRAY.length; l++) {
                System.out.println(
                    j + " : " + NODE_INFO_DESCRIBE_ARRAY[l] + " : "
                    + ((String[]) nodeList.get(j))[l]);
            }
        }

        return nodeList;
    }

    /**
     * NXML͂ăXgƂĕԂ܂B
     *
     * @param firstChildNode rootNode
     * @return Ni[ArrayList
     */
    private ArrayList parseLink(final Node firstChildNode) {
        ArrayList<String[]> linkList = new ArrayList<String[]>();

        String[] nodeLinkInfo = null;
        Node childNode = firstChildNode;

        while (childNode != null) {
        	/*
            System.out.println("getNodeName : " + childNode.getNodeName());
            System.out.println("getNodeType : " + childNode.getNodeType());
            System.out.println("getNodeValue : " + childNode.getNodeValue());
        	 */
            if (
                (childNode != null)
                    && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                // m[hN^O
                if (
                    childNode.getNodeName().equals(
                            NodeInformationXMLTag.LIN_INFO_ROOT_TAG)) {
                    childNode = childNode.getFirstChild();

                    break;
                }
            }

            childNode = childNode.getNextSibling();
        }

        while (childNode != null) {
            /* System.out.println("getNodeName0 : " + childNode.getNodeName());
            System.out.println("getNodeType0 : " + childNode.getNodeType());
            System.out.println("getNodeValue0 : " + childNode.getNodeValue());
            */

            // Node Info TAG
            if (
                (childNode != null)
                    && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                if (
                    childNode.getNodeName().equals(
                            NodeInformationXMLTag.LIN_INFO_TAG)) {
                    Node nodeInfoChildNodeLeaf = childNode.getFirstChild();

                    boolean hit = false;
                    nodeLinkInfo = new String[2];

                    while (nodeInfoChildNodeLeaf != null) {
                        /* System.out.println(
                            "getNodeName2 : "
                            + nodeInfoChildNodeLeaf.getNodeName());
                        System.out.println(
                            "getNodeType2 : "
                            + nodeInfoChildNodeLeaf.getNodeType());
                        System.out.println(
                            "getNodeValue2 : "
                            + nodeInfoChildNodeLeaf.getNodeValue());
                        */
                        if (
                            nodeInfoChildNodeLeaf.getNodeType() == Node.ELEMENT_NODE) {
                            // Node TypeElementł΁ANodeNLqƈv邩`FbN
                            if (
                                nodeInfoChildNodeLeaf.getNodeName().equals(
                                        NodeInformationXMLTag.LINK_X)) {
                                // NodeNLqƈvAElement TypełΒlzɊi[
                                Node firstNodeText =
                                    nodeInfoChildNodeLeaf.getFirstChild();
                                String leafItemValue =
                                    firstNodeText.getNodeValue();
                                nodeLinkInfo[0] = leafItemValue;
                                hit = true;
                                System.out.println(
                                    "Link Node X : " + leafItemValue);
                            }

                            if (
                                nodeInfoChildNodeLeaf.getNodeName().equals(
                                        NodeInformationXMLTag.LINK_Y)) {
                                // NodeNLqƈvAElement TypełΒlzɊi[
                                Node firstNodeText =
                                    nodeInfoChildNodeLeaf.getFirstChild();
                                String leafItemValue =
                                    firstNodeText.getNodeValue();
                                nodeLinkInfo[1] = leafItemValue;
                                hit = true;
                                System.out.println(
                                    "Link Node Y : " + leafItemValue);
                            }
                        }

                        nodeInfoChildNodeLeaf =
                            nodeInfoChildNodeLeaf.getNextSibling();
                    }

                    if (hit) {
                        linkList.add(nodeLinkInfo);
                    }
                }

                childNode = childNode.getNextSibling();
            }

            childNode = childNode.getNextSibling();
        }

        // o^m[hIPAhXo
        for (int j = 0; j < linkList.size(); j++) {
            for (int l = 0; l < 2; l++) {
                System.out.println(
                    j + " : Link " + " : " + ((String[]) linkList.get(j))[l]);
            }
        }

        return linkList;
    }

    /**
     * XML͂č쐬m[hĎ񕶎z񂩂
     * m[hĎCX^X𐶐ĕԂ܂B
     * LłȂm[hĎp[^ɂ́AftHgf[^
     * ݒ肵܂B
     *
     * @param nodeInfoArray m[hĎ񕶎z
     * @param  isLocalHostAddoress GWAhXlocalhostAhXƂ邩̃tO
     * @return nodeInformation m[hĎ
     */
    public NodeInformation createNodeInfo(
        String[] nodeInfoArray, boolean isLocalHostAddoress) {
        String nodename = "";
        String ipaddress = "";
        String engineAddress = NodeOperationView.INITIAL_ENGINE_ADDRESS;

        try {
            engineAddress = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            logger.warning(e.getMessage());
        }

        /* ftHgm[hĎ */
        String group = NodeOperationView.INITIAL_NODE_GROUP;
        String nodeX = "";
        String nodeY = "";
        String nodeKind = "";
        String pingPeriod = NodeOperationView.INITIAL_NODE_PING_PERIOD;
        String pingThreshhold = NodeOperationView.INITIAL_NODE_PING_THRESHOLD;
        String snmpVersion = SnmpPreference.SNMPV1_DESCRIPTION;
        String snmpPeriod = NodeOperationView.INITIAL_NODE_SNMP_PERIOD;
        String snmpLevel = NodeOperationView.INITIAL_NODE_SNMP_LEVEL;
        String roCommunity = NodeOperationView.INITIAL_NODE_SNMP_ROCOMMUNITY;
        String rwCommunity = NodeOperationView.INITIAL_NODE_SNMP_RWCOMMUNITY;
        String httpUrl = "";
        String httpPeriod = "";
        String httpPort = "";
        String httpTimeout = "";

        String popPeriod = "";
        String popPort = "";
        String popTimeout = "";
        String popUser = "";
        String popPassword = "";

        String smtpPeriod = "";
        String smtpPort = "";
        String smtpTimeout = "";
        String smtpSendAddress = "";
        String smtpCheckPop3Host = "";
        String smtpCheckPop3Port = "";
        String smtpCheckPop3Timeout = "";
        String smtpCheckPop3User = "";
        String smtpCheckPop3Password = "";

        nodename = nodeInfoArray[NODENAME_NUMBER];
        ipaddress = nodeInfoArray[IPADDRESS_NUMBER];

        /*
         * ȃm[hĎɂ́AftHgf[^Zbg
         */
        if (
            ((nodeInfoArray[ENGINE_ADDRESS_NUMBER] != null)
                && !nodeInfoArray[ENGINE_ADDRESS_NUMBER].equals(""))
                && !isLocalHostAddoress) {
            engineAddress = nodeInfoArray[ENGINE_ADDRESS_NUMBER];
        }

        if (
            (nodeInfoArray[GROUP_NUMBER] != null)
                && !nodeInfoArray[GROUP_NUMBER].equals("")) {
            group = nodeInfoArray[GROUP_NUMBER];
        }

        if (
            (nodeInfoArray[NODE_X_NUMBER] != null)
                && !nodeInfoArray[NODE_X_NUMBER].equals("")) {
            nodeX = nodeInfoArray[NODE_X_NUMBER];
        }

        if (
            (nodeInfoArray[NODE_Y_NUMBER] != null)
                && !nodeInfoArray[NODE_Y_NUMBER].equals("")) {
            nodeY = nodeInfoArray[NODE_Y_NUMBER];
        }

        if (
            (nodeInfoArray[NODEKIND_NUMBER] != null)
                && !nodeInfoArray[NODEKIND_NUMBER].equals("")) {
            nodeKind = nodeInfoArray[NODEKIND_NUMBER];
        }

        if (
            (nodeInfoArray[PING_PERIOD_NUMBER] != null)
                && !nodeInfoArray[PING_PERIOD_NUMBER].equals("")) {
            pingPeriod = nodeInfoArray[PING_PERIOD_NUMBER];
        }

        if (
            (nodeInfoArray[PING_THRESHHOLD_NUMBER] != null)
                && !nodeInfoArray[PING_THRESHHOLD_NUMBER].equals("")) {
            pingThreshhold = nodeInfoArray[PING_THRESHHOLD_NUMBER];
        }

        if (
            (nodeInfoArray[SNMP_VERSION_NUMBER] != null)
                && !nodeInfoArray[SNMP_VERSION_NUMBER].equals("")) {
            snmpVersion = nodeInfoArray[SNMP_VERSION_NUMBER];
        }

        if (
            (nodeInfoArray[SNMP_PERIOD_NUMBER] != null)
                && !nodeInfoArray[SNMP_PERIOD_NUMBER].equals("")) {
            snmpPeriod = nodeInfoArray[SNMP_PERIOD_NUMBER];
        }

        if (
            (nodeInfoArray[SNMP_LEVEL_NUMBER] != null)
                && !nodeInfoArray[SNMP_LEVEL_NUMBER].equals("")) {
            snmpLevel = nodeInfoArray[SNMP_LEVEL_NUMBER];
        }

        if (
            (nodeInfoArray[SNMP_ROCOMMUNITY_NUMBER] != null)
                && !nodeInfoArray[SNMP_ROCOMMUNITY_NUMBER].equals("")) {
            roCommunity = nodeInfoArray[SNMP_ROCOMMUNITY_NUMBER];
        }

        if (
            (nodeInfoArray[SNMP_RWCOMMUNITY_NUMBER] != null)
                && !nodeInfoArray[SNMP_RWCOMMUNITY_NUMBER].equals("")) {
            rwCommunity = nodeInfoArray[SNMP_RWCOMMUNITY_NUMBER];
        }

        if (
            (nodeInfoArray[HTTP_PERIOD_NUMBER] != null)
                && !nodeInfoArray[HTTP_PERIOD_NUMBER].equals("")) {
            httpPeriod = nodeInfoArray[HTTP_PERIOD_NUMBER];
        }

        if (
            (nodeInfoArray[HTTP_URL_NUMBER] != null)
                && !nodeInfoArray[HTTP_URL_NUMBER].equals("")) {
            httpUrl = nodeInfoArray[HTTP_URL_NUMBER];
        }

        if (
            (nodeInfoArray[HTTP_PORT_NUMBER] != null)
                && !nodeInfoArray[HTTP_PORT_NUMBER].equals("")) {
            httpPort = nodeInfoArray[HTTP_PORT_NUMBER];
        }

        if (
            (nodeInfoArray[HTTP_TIMEOUT_NUMBER] != null)
                && !nodeInfoArray[HTTP_TIMEOUT_NUMBER].equals("")) {
            httpTimeout = nodeInfoArray[HTTP_TIMEOUT_NUMBER];
        }

        if (
            (nodeInfoArray[POP3_PERIOD_NUMBER] != null)
                && !nodeInfoArray[POP3_PERIOD_NUMBER].equals("")) {
            popPeriod = nodeInfoArray[POP3_PERIOD_NUMBER];
        }

        if (
            (nodeInfoArray[POP3_PORT_NUMBER] != null)
                && !nodeInfoArray[POP3_PORT_NUMBER].equals("")) {
            popPort = nodeInfoArray[POP3_PORT_NUMBER];
        }

        if (
            (nodeInfoArray[POP3_TIMEOUT_NUMBER] != null)
                && !nodeInfoArray[POP3_TIMEOUT_NUMBER].equals("")) {
            popTimeout = nodeInfoArray[POP3_TIMEOUT_NUMBER];
        }

        if (
            (nodeInfoArray[POP3_USER_NUMBER] != null)
                && !nodeInfoArray[POP3_USER_NUMBER].equals("")) {
            popUser = nodeInfoArray[POP3_USER_NUMBER];
        }

        if (
            (nodeInfoArray[POP3_PASSWORD_NUMBER] != null)
                && !nodeInfoArray[POP3_PASSWORD_NUMBER].equals("")) {
            popPassword = nodeInfoArray[POP3_PASSWORD_NUMBER];
        }

        if (
            (nodeInfoArray[SMTP_PERIOD_NUMBER] != null)
                && !nodeInfoArray[SMTP_PERIOD_NUMBER].equals("")) {
            smtpPeriod = nodeInfoArray[SMTP_PERIOD_NUMBER];
        }

        if (
            (nodeInfoArray[SMTP_PORT_NUMBER] != null)
                && !nodeInfoArray[SMTP_PORT_NUMBER].equals("")) {
            smtpPort = nodeInfoArray[SMTP_PORT_NUMBER];
        }

        if (
            (nodeInfoArray[SMTP_TIMEOUT_NUMBER] != null)
                && !nodeInfoArray[SMTP_TIMEOUT_NUMBER].equals("")) {
            smtpTimeout = nodeInfoArray[SMTP_TIMEOUT_NUMBER];
        }

        if (
            (nodeInfoArray[SMTP_SEND_ADDRESS_NUMBER] != null)
                && !nodeInfoArray[SMTP_SEND_ADDRESS_NUMBER].equals("")) {
            smtpSendAddress = nodeInfoArray[SMTP_SEND_ADDRESS_NUMBER];
        }

        if (
            (nodeInfoArray[SMTP_CHECK_POP_HOST_NUMBER] != null)
                && !nodeInfoArray[SMTP_CHECK_POP_HOST_NUMBER].equals("")) {
            smtpCheckPop3Host = nodeInfoArray[SMTP_CHECK_POP_HOST_NUMBER];
        }

        if (
            (nodeInfoArray[SMTP_CHECK_POP_PORT_NUMBER] != null)
                && !nodeInfoArray[SMTP_CHECK_POP_PORT_NUMBER].equals("")) {
            smtpCheckPop3Port = nodeInfoArray[SMTP_CHECK_POP_PORT_NUMBER];
        }

        if (
            (nodeInfoArray[SMTP_CHECK_POP_TIMEOUT_NUMBER] != null)
                && !nodeInfoArray[SMTP_CHECK_POP_TIMEOUT_NUMBER].equals("")) {
            smtpCheckPop3Timeout = nodeInfoArray[SMTP_CHECK_POP_TIMEOUT_NUMBER];
        }

        if (
            (nodeInfoArray[SMTP_CHECK_POP_USER_NUMBER] != null)
                && !nodeInfoArray[SMTP_CHECK_POP_USER_NUMBER].equals("")) {
            smtpCheckPop3User = nodeInfoArray[SMTP_CHECK_POP_USER_NUMBER];
        }

        if (
            (nodeInfoArray[SMTP_CHECK_POP_PASSWORD_NUMBER] != null)
                && !nodeInfoArray[SMTP_CHECK_POP_PASSWORD_NUMBER].equals("")) {
            smtpCheckPop3Password =
                nodeInfoArray[SMTP_CHECK_POP_PASSWORD_NUMBER];
        }

        /* m[hĎCX^X */
        NodeInformation nodeInformation = new NodeInformation();

        nodeInformation.setNodename(nodename);
        nodeInformation.setIpaddress(ipaddress);
        nodeInformation.setEngineAddress(engineAddress);
        nodeInformation.setGroup(group);
        nodeInformation.setNodeKind(nodeKind);
        nodeInformation.setPingPeriod(pingPeriod);
        nodeInformation.setPingThreshold(pingThreshhold);
        nodeInformation.setSnmpVersion(snmpVersion);
        nodeInformation.setSnmpPeriod(snmpPeriod);
        nodeInformation.setSnmpLevel(snmpLevel);
        nodeInformation.setRoCommunity(roCommunity);
        nodeInformation.setRwCommunity(rwCommunity);
        nodeInformation.setNodeX(nodeX);
        nodeInformation.setNodeY(nodeY);

        nodeInformation.setNodeKind(nodeKind);

        nodeInformation.setHttpPeriod(httpPeriod);
        nodeInformation.setHttpUrl(httpUrl);
        nodeInformation.setHttpPort(httpPort);
        nodeInformation.setHttpTimeout(httpTimeout);

        nodeInformation.setPopPeriod(popPeriod);
        nodeInformation.setPopPort(popPort);
        nodeInformation.setPopTimeout(popTimeout);
        nodeInformation.setPopUser(popUser);
        nodeInformation.setPopPassword(popPassword);

        nodeInformation.setSmtpPeriod(smtpPeriod);
        nodeInformation.setSmtpPort(smtpPort);
        nodeInformation.setSmtpTimeout(smtpTimeout);
        nodeInformation.setSmtpSendAddress(smtpSendAddress);

        nodeInformation.setSmtpCheckHost(smtpCheckPop3Host);
        nodeInformation.setSmtpCheckPort(smtpCheckPop3Port);
        nodeInformation.setSmtpCheckTimeout(smtpCheckPop3Timeout);
        nodeInformation.setSmtpCheckUser(smtpCheckPop3User);
        nodeInformation.setSmtpCheckPassword(smtpCheckPop3Password);

        return nodeInformation;
    }

    /**
     * m[hLink񃊃XgԂ܂B
     *
     * @return linkList m[hLink񃊃Xg
     */
    public ArrayList getLinkList() {
        return linkList;
    }

    /**
     * m[hĎ񃊃XgԂ܂
     *
     * @return nodeInfoList  m[hĎ񃊃Xg
     */
    public ArrayList getNodeInfoList() {
        return nodeInfoList;
    }
}
