/*
 * Created on 2004/04/28
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.AlarmViewFilter;


/**
 * f[^x[X̃A[e[u𑀍삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DBTableAlarm extends DBTableBase {
    /** A[e[u */
    public static final String ALARM_TABLE = "alarm_table";

    /**
     * ftHgŃA[mFJɊi[A[
     * mFԋLq
     */
    public static final String UNCONFIRM = "unconfirm";

    /** A[ID J */
    public static final String ALARM_ID = "id";

    /** m[h J */
    public static final String NODENAME = "nodename";

    /** m[hO[v J */
    public static final String GROUP = "node_group";

    /** m[hIP AhX J */
    public static final String IPADDRESS = "ipaddress";

    /** A[R[h J */
    public static final String ALARM_CODE = "alarm_code";

    /** A[x J */
    public static final String ALARM_LEVEL = "alarm_level";

    /** A[bZ[W J */
    public static final String ALARM_MESSAGE = "alarm_message";

    /** A[mF J */
    public static final String ALARM_CONFIRM = "alarm_confirm";

    /** A[o J */
    public static final String ALARM_DATE = "alarm_date";

    /**
     * Alarm擾ɑSm[hΏۂƂꍇIP Address
     * 镶
     */
    public static final String ALL_NODE = "all";

    /* Alarm List\[gΏۗ񏉊l */
    public static final String INIT_SORT_COLUMN = ALARM_ID;

    /* Alarm List\[gl */
    public static final String INIT_SORT_DIRECTION = "desc";

    /* MO */
    private static Logger logger = null;

    /* tH[}bg */
    private final DateFormat simpleDateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * A[e[u𐧌䂷CX^X𐶐܂B
     *
     */
    private DBTableAlarm() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * A[e[uCX^XԂ܂B
     *
     * @return SingletonResource.RESOURCE A[e[uCX^X
     */
    public static DBTableAlarm getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * Alarme[u𐶐܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void createTable()
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        AbstractDataAccessObject dataaccessobject =
            DatabaseAccessControlKind.getInstance().getDataAccessObject();

        // A[e[u폜
        try {
            this.deleteTable(databaseAccess, ALARM_TABLE);
        } catch (SQLException e) {
            logger.info(
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                + " : " + e.getMessage());
        }

        try {
            // A[e[ũV[PXe[u폜iPostgreSQLpj
            this.dropSequence(
                databaseAccess, dataaccessobject.getDropAlarmTableSequenceSQL());

            // A[e[u
            databaseAccess.executeUpdate(
                dataaccessobject.getCreateAlarmTable());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * Alarme[u폜܂B
     * ܂Af[^x[XPostgreSQL̏ꍇ́AV[PXe[u폜܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void dropTable()
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            AbstractDataAccessObject dataaccessobject =
                DatabaseAccessControlKind.getInstance().getDataAccessObject();

            this.deleteTable(databaseAccess, ALARM_TABLE);
            this.dropSequence(
                databaseAccess, dataaccessobject.getDropAlarmTableSequenceSQL());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * A[e[uɃA[i[܂B
     *
     * @param ipaddress m[hIP Address
     * @param nodename m[h
     * @param group m[hO[v
     * @param alarminfo A[
     * @param message A[bZ[W
     * @return i[
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized boolean putAlarm(
        final String ipaddress, final String nodename, final String group,
        final AlarmCodeInformation alarminfo, final String message)
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // Timestamp format for HSQLDB
            Date date = Calendar.getInstance().getTime();

            String alarmLevel = alarminfo.getLevel();
            String alarmCode = alarminfo.getCode();
            String alarmMessage = message;
            String alarmConfirm = UNCONFIRM;

            SystemResourceFileParse resourceset =
                (SystemResourceConfig.getInstance()).getResourceFileParse();
            String databaseKind =
                resourceset.getResourceInfo().getDatabaseName();

            String checkAlarmMessage;

            if (
                databaseKind.equals(AbstractDataAccessObject.HSQLDB)
                    || databaseKind.equals(AbstractDataAccessObject.POSTGRESQL)
                    || databaseKind.equals(AbstractDataAccessObject.DERBY)
                    || databaseKind.equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                /*
                 * SysDesc'(VONH[e[V)܂܂
                 * ꍇAHSQLDBł̓Xy[XϊDBɊi[)
                 */
                checkAlarmMessage =
                    "'" + alarmMessage.replaceAll("'", " ") + "'";
            } else {
                /*
                 * SysDesc'(VONH[e[V)܂܂
                 * ꍇAHSQLDBȊOł͗["(_uNH[e[
                 * V)ƂDBɊi[)
                 */
                checkAlarmMessage = "\"" + alarmMessage + "\"";
            }

            // alarmDBɊi[
            databaseAccess.executeUpdate(
                "insert into " + ALARM_TABLE + " ( " + NODENAME + ", " + GROUP
                + ", " + IPADDRESS + ", " + ALARM_CODE + ", " + ALARM_LEVEL
                + ", " + ALARM_MESSAGE + ", " + ALARM_CONFIRM + ", "
                + ALARM_DATE + " )" + " VALUES( " + "'" + nodename + "'," + "'"
                + group + "'," + "'" + ipaddress + "'," + "'" + alarmCode
                + "'," + "'" + alarmLevel + "'," + checkAlarmMessage + ","
                + "'" + alarmConfirm + "'," + " '"
                + simpleDateformat.format(date) + "'" + ")");
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }

        return true;
    }

    /**
     * ẅȉ̏ƃA[\tB^[񂩂ỸA[擾ĕԂ܂B
     * EIIPAhX
     * E\[gΏۗ
     * E\[g
     *
     * @param limit A[Xgl
     * @param selectIPAddress m[hIP Address
     * @param paraSortColumn \[gJ
     * @param paraSortDirection \[g
     * @return alarmList A[񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList findAllAlarm(
        final int limit, final String selectIPAddress,
        final String paraSortColumn, final String paraSortDirection)
        throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList alarmList = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // A[\tB^[擾
            DBTableAlarmFilter alarmFilterDBTable = new DBTableAlarmFilter();

            ArrayList filterList = alarmFilterDBTable.findAll();

            /* A[tB^[񂩂A[擾pSQL𐶐 */
            String sql =
                createAlarmFilterSQL(
                    selectIPAddress, paraSortColumn, paraSortDirection,
                    filterList);

            conn = dataaccess.getConnection();

            // SQLXe[ggIuWFNg̍쐬
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            alarmList = new ArrayList();

            // A[\tB^ɍvA[擾
            int alarmCount = 0;

            while (rs.next()) {
                AlarmInformation alarmInfo = new AlarmInformation();

                alarmInfo.setNodename(rs.getObject(NODENAME).toString());
                alarmInfo.setGroup(rs.getObject(GROUP).toString());
                alarmInfo.setIpaddress(rs.getObject(IPADDRESS).toString());
                alarmInfo.setAlarmCode(rs.getObject(ALARM_CODE).toString());
                alarmInfo.setAlarmLevel(rs.getObject(ALARM_LEVEL).toString());
                alarmInfo.setAlarmMessage(
                    rs.getObject(ALARM_MESSAGE).toString());
                alarmInfo.setAlarmConfirm(
                    rs.getObject(ALARM_CONFIRM).toString());
                alarmInfo.setAlarmDate(rs.getObject(ALARM_DATE).toString());
                alarmInfo.setAlarmID(rs.getObject(ALARM_ID).toString());

                alarmList.add(alarmInfo);
                alarmCount++;

                if ((limit != 0) && (alarmCount >= limit)) {
                    break;
                }
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }

            dataaccess = null;
        }

        return alarmList;
    }

    /**
     * A[tB^[񂩂A[擾pSQL𐶐܂B
     *
     * @param selectIPAddress m[hIP Address
     * @param paraSortColumn \[gJ
     * @param paraSortDirection \[g
     * @param filterList A[tB^[񃊃Xg
     * @return SQL
     */
    private String createAlarmFilterSQL(
        final String selectIPAddress, final String paraSortColumn,
        final String paraSortDirection, ArrayList filterList) {
        String sortColumn;
        String sortDirection;

        /* \[gwJȂꍇɂ̓A[ł͂ȂIDw */
        if (paraSortColumn == null) {
            // sortColumn = ALARM_DATE;
            sortColumn = INIT_SORT_COLUMN;
        } else {
            sortColumn = paraSortColumn;
        }

        /* /~\[gw肪Ȃꍇɂ͏\[gw */
        if (paraSortDirection == null) {
            sortDirection = INIT_SORT_DIRECTION;
        } else {
            sortDirection = paraSortDirection;
        }

        //sql̍쐬
        String alarmNodename = "";
        String alarmIPAddress = "";
        String alarmLevel = "";
        String alarmConfirm = "";
        String alarmStartDate = null;
        String alarmEndDate = null;

        String filterIPAddress = "";
        String filterNodename = "";
        String filterLevel = "";
        String filterConfirm = "";
        String filterStartDate = "";
        String filterEndDate = "";

        for (int i = 0; i < filterList.size(); i++) {
            AlarmViewFilter alarmViewFilter =
                (AlarmViewFilter) filterList.get(i);

            // A[\tB^ m[h
            alarmNodename = alarmViewFilter.getNodename();

            alarmIPAddress = alarmViewFilter.getIpaddress();

            alarmLevel = alarmViewFilter.getAlarmLevel();

            // A[\tB^ mF/mF
            alarmConfirm = alarmViewFilter.getAlarmConfirm();

            /*
             *  A[\tB^Ԏw
             *
             */
            Date date;

            // Jn
            if (
                !alarmViewFilter.getAlarmStartDate().equals(
                        DBTableAlarmFilter.ANY)) {
                date = Calendar.getInstance().getTime();
                date.setTime(
                    Long.parseLong(alarmViewFilter.getAlarmStartDate()));
                alarmStartDate = simpleDateformat.format(date);
            } else {
                alarmStartDate = DBTableAlarmFilter.ANY;
            }

            // I
            if (
                !alarmViewFilter.getAlarmEndDate().equals(
                        DBTableAlarmFilter.ANY)) {
                date =
                    new Date(Long.parseLong(alarmViewFilter.getAlarmEndDate()));
                alarmEndDate = simpleDateformat.format(date);
            } else {
                alarmEndDate = DBTableAlarmFilter.ANY;
            }
        }

        // 擾A[\tB^񂩂SQL쐬
        if (alarmConfirm.equals(DBTableAlarmFilter.ANY)) {
            filterConfirm =
                " where " + ALARM_CONFIRM + " != " + "'"
                + DBTableAlarmFilter.ANY + "' ";
        } else {
            filterConfirm =
                " where " + ALARM_CONFIRM + " = " + "'" + alarmConfirm + "' ";
        }

        if (!alarmNodename.equals(DBTableAlarmFilter.ANY)) {
            filterNodename =
                " and " + NODENAME + "=" + "'" + alarmNodename + "' ";
        }

        if (!alarmLevel.equals(DBTableAlarmFilter.ANY)) {
            filterLevel = " and " + ALARM_LEVEL + "=" + "'" + alarmLevel + "' ";
        }

        if (!selectIPAddress.equals(ALL_NODE)) {
            /* m[hʎw莞̓tB^gpAIIPAhX
                 * gp
                 */
            filterIPAddress =
                " and " + IPADDRESS + "=" + "'" + selectIPAddress + "' ";
        } else {
            /* Sm[hIPw莞iSA[\j̎ŃtB^[
                 * IPAhXw肳Ăꍇ͗LƂ
                 * (m[hʎw莞ł̓tB^[IPAhXw͖
                 * Ƃ(wm[hA[\w肵Ă邽))
                 */
            if (!alarmIPAddress.equals(DBTableAlarmFilter.ANY)) {
                filterIPAddress =
                    " and " + IPADDRESS + "=" + "'" + alarmIPAddress + "' ";
            }
        }

        if (!alarmStartDate.equals(DBTableAlarmFilter.ANY)) {
            filterStartDate =
                " and " + ALARM_DATE + " >= '" + alarmStartDate + "' ";
        }

        if (!alarmEndDate.equals(DBTableAlarmFilter.ANY)) {
            filterEndDate =
                " and " + ALARM_DATE + " <= '" + alarmEndDate + "' ";
        }

        // 쐬XSQLA
        String sql;
        sql = "SELECT * from " + ALARM_TABLE + filterConfirm + filterNodename
            + filterIPAddress + filterLevel + filterStartDate + filterEndDate
            + " order by " + sortColumn + " " + sortDirection;

        return sql;
    }

    /**
     * wm[h̃A[擾܂B
     *
     * @param selectIPAddress m[hIP Address
     * @return alarmList A[񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList getNodeAlarm(final String selectIPAddress)
        throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList alarmList = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            //sql̍쐬
            String sql =
                "SELECT * from " + ALARM_TABLE + " where " + ALARM_CONFIRM
                + " = " + "'" + UNCONFIRM + "' " + " and " + IPADDRESS + "="
                + "'" + selectIPAddress + "' " + " order by "
                + INIT_SORT_COLUMN + " " + INIT_SORT_DIRECTION;

            conn = dataaccess.getConnection();

            // SQLXe[ggIuWFNg̍쐬
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            alarmList = new ArrayList();

            // A[\tB^ɍvA[擾
            while (rs.next()) {
                AlarmInformation alarmInfo = new AlarmInformation();

                alarmInfo.setNodename(rs.getObject(NODENAME).toString());
                alarmInfo.setGroup(rs.getObject(GROUP).toString());
                alarmInfo.setIpaddress(rs.getObject(IPADDRESS).toString());
                alarmInfo.setAlarmCode(rs.getObject(ALARM_CODE).toString());
                alarmInfo.setAlarmLevel(rs.getObject(ALARM_LEVEL).toString());
                alarmInfo.setAlarmMessage(
                    rs.getObject(ALARM_MESSAGE).toString());
                alarmInfo.setAlarmConfirm(
                    rs.getObject(ALARM_CONFIRM).toString());
                alarmInfo.setAlarmDate(rs.getObject(ALARM_DATE).toString());
                alarmInfo.setAlarmID(rs.getObject(ALARM_ID).toString());

                alarmList.add(alarmInfo);

                break;
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }

            dataaccess = null;
        }

        return alarmList;
    }

    /**
     * wm[hIP Address̎wAlarm IDmFς݂ɍXV܂B
     *
     * @param ipaddress m[hIP Address
     * @param alarmID A[ID
     * @return Alarm IDmFς݂ɍXVۃtO
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized boolean updateAlarmIDConfirm(
        final String ipaddress, final String alarmID)
        throws SQLException, DatabaseConnectionException {
        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        String sql;

        try {
            SystemResourceFileParse resourceset =
                (SystemResourceConfig.getInstance()).getResourceFileParse();
            String databaseKind =
                resourceset.getResourceInfo().getDatabaseName();

            if (
                databaseKind.equals(AbstractDataAccessObject.DERBY)
                    || databaseKind.equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                sql = "UPDATE " + ALARM_TABLE + " set " + ALARM_CONFIRM + " = "
                    + "'" + "confirm" + "'" + " where " + ALARM_ID + "="
                    + alarmID + " and " + IPADDRESS + "=" + "'" + ipaddress
                    + "'";
            } else {
                sql = "UPDATE " + ALARM_TABLE + " set " + ALARM_CONFIRM + " = "
                    + "'" + "confirm" + "'" + " where " + ALARM_ID + "=" + "'"
                    + alarmID + "'" + " and " + IPADDRESS + "=" + "'"
                    + ipaddress + "'";
            }

            // select̎s
            dataaccess.executeUpdate(sql);

            return true;
        } finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    dataaccess);
            }
        }
    }

    /**
     * w̃m[hIPAhXɊYA[SĖmFmFς݂ɂ܂B
     *
     * @param ipaddress m[hIP Address
     * @return Alarm IDmFς݂ɍXVۃtO
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized boolean updateAllAlarmIDConfirm(final String ipaddress)
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            ArrayList alarmList = null;

            alarmList = findAllAlarm(0, ipaddress, null, null);

            if (alarmList == null) {
                return false;
            }

            AlarmInformation alarmConfirm;
            String alarmID;
            SystemResourceFileParse resourceset =
                (SystemResourceConfig.getInstance()).getResourceFileParse();
            String databaseKind =
                resourceset.getResourceInfo().getDatabaseName();
            String baseSql =
                "UPDATE " + ALARM_TABLE + " set " + ALARM_CONFIRM + "= " + "'"
                + "confirm" + "'" + " where " + ALARM_ID + "=";

            if (
                databaseKind.equals(AbstractDataAccessObject.DERBY)
                    || databaseKind.equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                for (int i = 0; i < alarmList.size(); i++) {
                    alarmConfirm = (AlarmInformation) alarmList.get(i);
                    alarmID = alarmConfirm.getAlarmID();

                    String sql = baseSql + alarmID;

                    // select̎s
                    dataaccess.executeUpdate(sql);
                }
            } else {
                for (int i = 0; i < alarmList.size(); i++) {
                    alarmConfirm = (AlarmInformation) alarmList.get(i);
                    alarmID = alarmConfirm.getAlarmID();

                    String sql = baseSql + "'" + alarmID + "'";

                    // select̎s
                    dataaccess.executeUpdate(sql);
                }
            }

            return true;
        } finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    dataaccess);
                dataaccess = null;
            }
        }
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DBTableAlarm RESOURCE = new DBTableAlarm();
    }
}
