/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableInterfaceMIB;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.database.access.model.DBTableSystemMIB;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.server.protocol.snmp.SnmpInterfacesMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpSystemMibGet;
import netjfwatcher.engine.socket.ConnectionInterfaceMib;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.ConnectionNodeSnmpGet;
import netjfwatcher.engine.socket.ConnectionSystemMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.InterfaceMib;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.SystemMib;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditorNodeSnmp
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = " Snmp View";
    private static final int TEXT_WIDTH = 800;
    private static Logger logger;
    private static final float COLUMN0_IFINDEX_RATIO = 0.04f;
    private static final float COLUMN1_IFDESC_RATIO = 0.1f;
    private static final float COLUMN2_IFTYPE_RATIO = 0.1f;
    private static final float COLUMN3_IFMTU_RATIO = 0.1f;
    private static final float COLUMN4_IFMSPEED_RATIO = 0.1f;
    private static final float COLUMN5_IFPHYSADDRESS_RATIO = 0.1f;
    private static final float COLUMN6_IFSTATUS_RATIO = 0.1f;
    private static Color BLUE_COLOR;
    private NodeInformation targetNodeInfo;
    private Text sysDescrText;
    private Text sysUpTimeText;
    private Text sysNameText;
    private Text sysContactText;
    private Text sysLocationText;
    private Button getMibButton;
    private Button refreshButton;
    private TableViewer viewer;
    private Color textBackColor;

    static {
        BLUE_COLOR = new Color(null, 0, 0, 255);
    }

    public EditorNodeSnmp() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = WHITE_COLOR;
    }

    public void createPartControl(Composite parent) {
        EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView)this.getEditorInput();
        this.targetNodeInfo = nodeViewEditorInput.getNodeInfo();
        this.isSocket = nodeViewEditorInput.isSocket();
        if (this.targetNodeInfo == null) {
            logger.warning("Node Input null");
        }
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        this.refreshButton = new Button(composite, 0);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setLayoutData((Object)new GridData());
        this.getMibButton = new Button(composite, 0);
        this.getMibButton.setText("Node Get");
        this.getMibButton.setLayoutData((Object)new GridData());
        Label label = new Label(composite, 0);
        label.setText("sysDescr");
        label.setLayoutData((Object)new GridData());
        this.sysDescrText = new Text(composite, 8);
        this.sysDescrText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 800;
        this.sysDescrText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("sysUpTime");
        label.setLayoutData((Object)new GridData());
        this.sysUpTimeText = new Text(composite, 8);
        this.sysUpTimeText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 800;
        this.sysUpTimeText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("sysContact");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.sysContactText = new Text(composite, 8);
        this.sysContactText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 800;
        this.sysContactText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("sysName");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.sysNameText = new Text(composite, 8);
        this.sysNameText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 800;
        this.sysNameText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("sysLocation");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.sysLocationText = new Text(composite, 8);
        this.sysLocationText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 800;
        this.sysLocationText.setLayoutData((Object)gridData);
        SystemMib systemMibInfo = null;
        ArrayList interfaceMibList = null;
        systemMibInfo = this.getSystemMib(this.targetNodeInfo, false);
        interfaceMibList = this.getInterfaceMib(this.targetNodeInfo, false);
        this.setTextNodeInfo(systemMibInfo);
        SnmpInterfaceMibTable statisticsTable = new SnmpInterfaceMibTable();
        this.table = statisticsTable.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.setInterfaceMibTable(interfaceMibList);
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorNodeSnmp.this.refreshButton.setEnabled(false);
                SystemMib systemMibInfo = EditorNodeSnmp.this.getSystemMib(EditorNodeSnmp.this.targetNodeInfo, true);
                EditorNodeSnmp.this.setTextNodeInfo(systemMibInfo);
                ArrayList interfaceMibList = EditorNodeSnmp.this.getInterfaceMib(EditorNodeSnmp.this.targetNodeInfo, true);
                EditorNodeSnmp.this.setInterfaceMibTable(interfaceMibList);
                EditorNodeSnmp.this.refreshButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.getMibButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorNodeSnmp.this.getMibButton.setEnabled(false);
                NodeInformation nodeInfo = EditorNodeSnmp.this.getNodeInfo();
                EditorNodeSnmp.this.getNodeSnmp(nodeInfo);
                EditorNodeSnmp.this.getMibButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NodeInformation getNodeInfo() {
        NodeInformation nodeInfo = null;
        if (!this.isSocket) {
            DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
            try {
                ArrayList nodeList = nodeRegisterDBTable.findTarget(this.targetNodeInfo.getIpaddress());
                if (nodeList.size() <= 0) return nodeInfo;
                return (NodeInformation)nodeList.get(0);
            }
            catch (SQLException e1) {
                logger.warning(e1.getMessage());
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                shell.dispose();
                return null;
            }
            catch (Exception e1) {
                logger.warning(e1.getMessage());
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                shell.dispose();
                return null;
            }
        }
        ArrayList nodeList = null;
        String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
        try {
            ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(engineAddress);
            nodeList = connectNodeInfo.getNodeInformationList(null, null);
        }
        catch (EngineConnectException e1) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)(String.valueOf(e1.getMessage()) + " Engine = " + engineAddress));
            logger.warning("Node List import error" + e1.getMessage());
            shell.dispose();
            return null;
        }
        catch (IOException e1) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)(String.valueOf(e1.getMessage()) + " Engine = " + engineAddress));
            logger.warning("Node List import error" + e1.getMessage());
            shell.dispose();
            return null;
        }
        if (nodeList.size() <= 0) return nodeInfo;
        return (NodeInformation)nodeList.get(0);
    }

    private void getNodeSnmp(NodeInformation nodeInfo) {
        String snmpVersion = nodeInfo.getSnmpVersion();
        int version = 0;
        if (snmpVersion.equals("SNMPV1")) {
            version = 0;
        } else if (snmpVersion.equals("SNMPV2C")) {
            version = 1;
        } else if (snmpVersion.equals("SNMPV3")) {
            version = 3;
        } else {
            logger.warning("Bad snmp version : " + snmpVersion);
        }
        if (!this.isSocket) {
            SnmpSystemMibGet systemMibGetInstance = null;
            SnmpInterfacesMibGet interfacesMibGetInstance = null;
            try {
                systemMibGetInstance = new SnmpSystemMibGet();
                systemMibGetInstance.setSnmpSystemMibGet(nodeInfo.getIpaddress(), version, nodeInfo.getRoCommunity());
                systemMibGetInstance.getSystemMIB();
                interfacesMibGetInstance = new SnmpInterfacesMibGet();
                interfacesMibGetInstance.setSnmpInterfacesMibGet(nodeInfo.getIpaddress(), version, nodeInfo.getRoCommunity());
                interfacesMibGetInstance.getInterfacesMIB();
            }
            catch (UnknownHostException e1) {
                logger.warning(e1.getMessage());
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                shell.dispose();
                return;
            }
            catch (SocketException e1) {
                logger.warning(e1.getMessage());
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                shell.dispose();
                return;
            }
            catch (SnmpMIBGetException e1) {
                logger.warning(e1.getMessage());
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                shell.dispose();
                return;
            }
        }
        String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
        ConnectionNodeSnmpGet refreshNodeSnmp = new ConnectionNodeSnmpGet(engineAddress);
        try {
            refreshNodeSnmp.refreshNodeSnmp(nodeInfo.getIpaddress());
        }
        catch (EngineConnectException e) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Engine connect error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
            shell.dispose();
        }
        catch (IOException e) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Engine connect error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
            shell.dispose();
        }
        SystemMib systemMibInfo = this.getSystemMib(this.targetNodeInfo, true);
        this.setTextNodeInfo(systemMibInfo);
        ArrayList interfaceMibList = this.getInterfaceMib(this.targetNodeInfo, true);
        this.setInterfaceMibTable(interfaceMibList);
    }

    private void setTextNodeInfo(SystemMib systemMibInfo) {
        if (systemMibInfo != null) {
            if (systemMibInfo.getSysDescr() != null) {
                this.sysDescrText.setText(systemMibInfo.getSysDescr());
            }
            if (systemMibInfo.getSysUpTime() != null) {
                this.sysUpTimeText.setText(systemMibInfo.getSysUpTime());
            }
            if (systemMibInfo.getSysName() != null) {
                this.sysNameText.setText(systemMibInfo.getSysName());
            }
            if (systemMibInfo.getSysContact() != null) {
                this.sysContactText.setText(systemMibInfo.getSysContact());
            }
            if (systemMibInfo.getSysLocation() != null) {
                this.sysLocationText.setText(systemMibInfo.getSysLocation());
            }
        }
    }

    private void setInterfaceMibTable(ArrayList interfaceMibList) {
        if (interfaceMibList == null) {
            return;
        }
        this.table.removeAll();
        this.viewer.refresh();
        InterfaceMib nodeInterfaceMib = null;
        int i = 0;
        while (i < interfaceMibList.size()) {
            String[] interfaceTableCellArray = new String[7];
            nodeInterfaceMib = (InterfaceMib)interfaceMibList.get(i);
            interfaceTableCellArray[0] = nodeInterfaceMib.getIfIndex();
            interfaceTableCellArray[1] = nodeInterfaceMib.getIfDesc();
            interfaceTableCellArray[2] = nodeInterfaceMib.getIfType();
            interfaceTableCellArray[3] = nodeInterfaceMib.getIfMtu();
            interfaceTableCellArray[4] = nodeInterfaceMib.getIfSpeed();
            interfaceTableCellArray[5] = nodeInterfaceMib.getIfPhysAddress();
            interfaceTableCellArray[6] = nodeInterfaceMib.getIfStatus();
            TableItem item = new TableItem(this.table, 0);
            item.setText(interfaceTableCellArray);
            item.setData((Object)interfaceTableCellArray);
            if (nodeInterfaceMib.getIfStatus().equals("Up")) {
                item.setForeground(BLUE_COLOR);
            }
            ++i;
        }
    }

    private SystemMib getSystemMib(NodeInformation refreshNodeInfo, boolean isShowErrorDialog) {
        SystemMib systemMibInfo;
        block10: {
            if (refreshNodeInfo == null) {
                return null;
            }
            systemMibInfo = null;
            if (!this.isSocket) {
                DBTableSystemMIB systemDBtable = DBTableSystemMIB.getInstance();
                try {
                    systemMibInfo = systemDBtable.findSystemMIBTable(refreshNodeInfo.getIpaddress());
                }
                catch (DatabaseConnectionException e2) {
                    logger.warning(e2.getMessage());
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e2.getMessage());
                    shell.dispose();
                }
                catch (SQLException e2) {
                    logger.warning(e2.getMessage());
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e2.getMessage());
                    shell.dispose();
                }
            } else {
                String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
                ConnectionSystemMibGet connectSystemMibInfo = new ConnectionSystemMibGet(engineAddress);
                try {
                    systemMibInfo = connectSystemMibInfo.getSystemMib(refreshNodeInfo.getIpaddress());
                }
                catch (EngineConnectException e) {
                    logger.warning("Node System MIB import error" + e.getMessage());
                    if (isShowErrorDialog) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Engine connect error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                        shell.dispose();
                    }
                }
                catch (IOException e) {
                    logger.warning("Node System MIB import error" + e.getMessage());
                    if (!isShowErrorDialog) break block10;
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Engine connect error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                }
            }
        }
        return systemMibInfo;
    }

    private ArrayList getInterfaceMib(NodeInformation refreshNodeInfo, boolean isShowErrorDialog) {
        ArrayList interfaceMibList;
        block10: {
            interfaceMibList = null;
            if (!this.isSocket) {
                DBTableInterfaceMIB interfaceMibDBtable = DBTableInterfaceMIB.getInstance();
                try {
                    interfaceMibList = interfaceMibDBtable.findSNMPInterfaces(refreshNodeInfo.getIpaddress(), true);
                }
                catch (DatabaseConnectionException e2) {
                    logger.warning(e2.getMessage());
                    if (isShowErrorDialog) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e2.getMessage());
                        shell.dispose();
                    }
                    break block10;
                }
                catch (SQLException e2) {
                    logger.warning(e2.getMessage());
                    if (isShowErrorDialog) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e2.getMessage());
                        shell.dispose();
                    }
                    break block10;
                }
            }
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionInterfaceMib connectInterfaceMib = new ConnectionInterfaceMib(engineAddress);
            try {
                interfaceMibList = connectInterfaceMib.getInterfaceMib(refreshNodeInfo.getIpaddress());
            }
            catch (EngineConnectException e) {
                logger.warning("Node Interface MIB import error" + e.getMessage());
                if (isShowErrorDialog) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Engine connect error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                }
            }
            catch (IOException e) {
                logger.warning("Node Interface MIB import error" + e.getMessage());
                if (!isShowErrorDialog) break block10;
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Engine connect error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                shell.dispose();
            }
        }
        return interfaceMibList;
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.04f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol3Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol4Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol5Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol6Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.table != null) {
            this.table.dispose();
        }
    }

    private final class SnmpInterfaceMibTable
    extends AbstractTableView {
        private boolean isCol0Direction = true;
        private boolean isCol1Direction = true;
        private boolean isCol2Direction = true;
        private boolean isCol3Direction = true;
        private boolean isCol4Direction = true;
        private boolean isCol5Direction = true;
        private boolean isCol6Direction = true;
        private TableColumn col0;
        private TableColumn col1;
        private TableColumn col2;
        private TableColumn col3;
        private TableColumn col4;
        private TableColumn col5;
        private TableColumn col6;

        private SnmpInterfaceMibTable() {
        }

        private Table createTable(Composite parent) {
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.verticalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            this.table = new Table(parent, 66304);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)data2);
            this.col0 = new TableColumn(this.table, 0x1000000);
            this.col0.setText("ifIndex");
            this.col0.setWidth(EditorNodeSnmp.this.computeCol0Width());
            this.col1 = new TableColumn(this.table, 0x1000000);
            this.col1.setText("ifDesc");
            this.col1.setWidth(EditorNodeSnmp.this.computeCol1Width());
            this.col2 = new TableColumn(this.table, 0x1000000);
            this.col2.setText("ifType");
            this.col2.setWidth(EditorNodeSnmp.this.computeCol2Width());
            this.col3 = new TableColumn(this.table, 0x1000000);
            this.col3.setText("ifMtu");
            this.col3.setWidth(EditorNodeSnmp.this.computeCol3Width());
            this.col4 = new TableColumn(this.table, 0x1000000);
            this.col4.setText("ifSpeed");
            this.col4.setWidth(EditorNodeSnmp.this.computeCol4Width());
            this.col5 = new TableColumn(this.table, 0x1000000);
            this.col5.setText("ifPhysAddress");
            this.col5.setWidth(EditorNodeSnmp.this.computeCol5Width());
            this.col6 = new TableColumn(this.table, 0x1000000);
            this.col6.setText("ifStatus");
            this.col6.setWidth(EditorNodeSnmp.this.computeCol6Width());
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                }

                public void controlResized(ControlEvent event) {
                    SnmpInterfaceMibTable.this.setResizedTableColumnWidth();
                }
            });
            this.col0.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol0Direction = SnmpInterfaceMibTable.this.sortIntegerTable(SnmpInterfaceMibTable.this.table, 0, SnmpInterfaceMibTable.this.isCol0Direction);
                }
            });
            this.col1.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol1Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 1, SnmpInterfaceMibTable.this.isCol1Direction);
                }
            });
            this.col2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol2Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 2, SnmpInterfaceMibTable.this.isCol2Direction);
                }
            });
            this.col3.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol3Direction = SnmpInterfaceMibTable.this.sortIntegerTable(SnmpInterfaceMibTable.this.table, 3, SnmpInterfaceMibTable.this.isCol3Direction);
                }
            });
            this.col4.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol4Direction = SnmpInterfaceMibTable.this.sortIntegerTable(SnmpInterfaceMibTable.this.table, 4, SnmpInterfaceMibTable.this.isCol4Direction);
                }
            });
            this.col5.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol5Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 5, SnmpInterfaceMibTable.this.isCol5Direction);
                }
            });
            this.col6.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol6Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 6, SnmpInterfaceMibTable.this.isCol6Direction);
                }
            });
            return this.table;
        }

        protected void setResizedTableColumnWidth() {
            if (EditorNodeSnmp.this.getEditorSite().getPage().isPartVisible(EditorNodeSnmp.this.getEditorSite().getPart()) && EditorNodeSnmp.this.getEditorSite().getShell() != null && EditorNodeSnmp.this.getEditorSite().getShell().getSize() != null) {
                this.col0.setWidth(EditorNodeSnmp.this.computeCol0Width());
                this.col1.setWidth(EditorNodeSnmp.this.computeCol1Width());
                this.col2.setWidth(EditorNodeSnmp.this.computeCol2Width());
                this.col3.setWidth(EditorNodeSnmp.this.computeCol3Width());
            }
        }

        protected TableItem setTableItem(Table table, TableItem item, String[] strs) {
            Color obj0 = item.getForeground();
            Color obj1 = item.getBackground();
            item.dispose();
            item = new TableItem(table, 0);
            item.setText(strs);
            item.setData((Object)strs);
            item.setForeground(obj0);
            item.setBackground(obj1);
            return item;
        }
    }
}

