/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.canvas;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.view.canvas.CanvasViewInfo;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class CanvasViewConfigFileParse {
    private static final int CHART_VIEW_WIDTH = 1400;
    private static final int CHART_VIEW_HEIGHT = 800;
    private static final int X_POINT_VALUE0 = 1000;
    private static final int Y_POINT_VALUE0 = 450;
    protected static final int MAP_VIEW_WIDTH = 1900;
    protected static final int MAP_VIEW_HEIGHT = 1700;
    private static final String CONF_TAG = "conf";
    private static final String CHART_TAG = "chart";
    private static final String CHART_WIDTH_TAG = "width";
    private static final String CHART_HEIGHT_TAG = "height";
    private static final String CHART_X_SCALL_TAG = "x_scall";
    private static final String CHART_Y_SCALL_TAG = "y_scall";
    private static final String NODE_MAP_TAG = "node_map";
    private static final String NODE_MAP_WIDTH_TAG = "width";
    private static final String NODE_MAP_HEIGHT_TAG = "height";
    private static final String ATTRIBUTE_VALUE = "value";
    private static Logger logger = null;
    private int chartWidth = 1400;
    private int chartHeight = 800;
    private int chartXScall = 1000;
    private int chartYScall = 450;
    private int nodeMapWidth = 1900;
    private int nodeMapHeight = 1700;

    private CanvasViewConfigFileParse() {
        logger = Logger.getLogger(this.getClass().getName());
        this.parseCanvasViewConfigFileParse();
    }

    public void parseCanvasViewConfigFileParse() {
        Document doc = null;
        doc = this.getResourceFileDocumentPath("resources/canvas_view.xml");
        try {
            Element root = doc.getRootElement();
            Element chartEl = root.getChild(CHART_TAG);
            this.chartWidth = Integer.parseInt(chartEl.getChild("width").getAttributeValue(ATTRIBUTE_VALUE));
            this.chartHeight = Integer.parseInt(chartEl.getChild("height").getAttributeValue(ATTRIBUTE_VALUE));
            this.chartXScall = Integer.parseInt(chartEl.getChild(CHART_X_SCALL_TAG).getAttributeValue(ATTRIBUTE_VALUE));
            this.chartYScall = Integer.parseInt(chartEl.getChild(CHART_Y_SCALL_TAG).getAttributeValue(ATTRIBUTE_VALUE));
            Element nodeMapEl = root.getChild(NODE_MAP_TAG);
            this.nodeMapWidth = Integer.parseInt(nodeMapEl.getChild("width").getAttributeValue(ATTRIBUTE_VALUE));
            this.nodeMapHeight = Integer.parseInt(nodeMapEl.getChild("height").getAttributeValue(ATTRIBUTE_VALUE));
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public BufferedWriter getResourceFileWriter() {
        File f = new File("resources/canvas_view.xml");
        if (f == null) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fi = new FileWriter("resources/canvas_view.xml");
            bufferedWriter = new BufferedWriter(fi);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return bufferedWriter;
    }

    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;
        File f = new File(file);
        if (f == null) {
            logger.warning("Abort create File : " + f.getAbsolutePath());
            return null;
        }
        BufferedReader d = null;
        try {
            FileReader fi = new FileReader(file);
            d = new BufferedReader(fi);
        }
        catch (FileNotFoundException e1) {
            logger.warning("FileNotFoundException : " + f.getPath() + " : " + e1.getMessage());
            logger.warning("FileNotFoundException : " + f.getAbsolutePath() + " : " + e1.getMessage());
            e1.printStackTrace();
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            logger.warning("JDOMException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.warning("NullPointerException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning("IOException : " + e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    protected Document getDocument(String file) {
        URL url;
        Document doc;
        block5: {
            doc = null;
            url = null;
            Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
            url = bundle.getEntry(file);
            if (url != null) break block5;
            logger.severe("Resource XML file url : " + url);
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        }
        catch (JDOMException e) {
            logger.severe("JDOMException URL= " + url + " " + e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.severe("NullPointerException URL= " + url + " " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.severe("IOException URL= " + url + " " + e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    public Document updateDocument(CanvasViewInfo canvasViewInfo) {
        logger = Logger.getLogger(this.getClass().getName());
        Element rootElement = new Element(CONF_TAG);
        Document doc = new Document(rootElement);
        Element chartEl = new Element(CHART_TAG);
        Element chartWidthEl = new Element("width");
        Element chartHeightEl = new Element("height");
        Element chartXScallEl = new Element(CHART_X_SCALL_TAG);
        Element chartYScallEl = new Element(CHART_Y_SCALL_TAG);
        rootElement.addContent((Content)chartEl);
        chartEl.addContent((Content)chartWidthEl);
        chartEl.addContent((Content)chartHeightEl);
        chartEl.addContent((Content)chartXScallEl);
        chartEl.addContent((Content)chartYScallEl);
        chartWidthEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getChartWidth())));
        chartHeightEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getChartHeight())));
        chartXScallEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getChartXScall())));
        chartYScallEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getChartYScall())));
        Element nodeMapEl = new Element(NODE_MAP_TAG);
        Element nodeMapWidthEl = new Element("width");
        Element nodeMapHeightEl = new Element("height");
        rootElement.addContent((Content)nodeMapEl);
        nodeMapEl.addContent((Content)nodeMapWidthEl);
        nodeMapEl.addContent((Content)nodeMapHeightEl);
        nodeMapWidthEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getNodeMapWidth())));
        nodeMapHeightEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getNodeMapHeight())));
        return doc;
    }

    public int getChartHeight() {
        return this.chartHeight;
    }

    public int getChartWidth() {
        return this.chartWidth;
    }

    public int getNodeMapHeight() {
        return this.nodeMapHeight;
    }

    public int getNodeMapWidth() {
        return this.nodeMapWidth;
    }

    public int getChartXScall() {
        return this.chartXScall;
    }

    public int getChartYScall() {
        return this.chartYScall;
    }

    public static CanvasViewConfigFileParse getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ CanvasViewConfigFileParse(CanvasViewConfigFileParse canvasViewConfigFileParse) {
        this();
    }

    private static class SingletonResource {
        static final CanvasViewConfigFileParse RESOURCE = new CanvasViewConfigFileParse(null);

        private SingletonResource() {
        }
    }
}

