/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.control.BusyCheckForDatabase;
import netjfwatcher.engine.server.protocol.control.QueueForDatabseWatch;
import netjfwatcher.engine.server.protocol.database.ExecuteDatabaseWatch;

public class ThreadQueueCheckDatabaseWatch
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger = null;

    public ThreadQueueCheckDatabaseWatch() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void run() {
        ExecuteDatabaseWatch execDatabaseWatch = new ExecuteDatabaseWatch();
        while (!Thread.interrupted()) {
            NodeWatchInfo infoDBPopQueue = QueueForDatabseWatch.getInstance().popQueue();
            NodeWatchInfo checkIPAddressNodeWatchInfo = null;
            if (infoDBPopQueue != null) {
                checkIPAddressNodeWatchInfo = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(infoDBPopQueue.getIpaddress());
            }
            if (infoDBPopQueue != null && checkIPAddressNodeWatchInfo != null) {
                if (BusyCheckForDatabase.getInstance().getArbitrationExec(infoDBPopQueue.getIpaddress())) {
                    execDatabaseWatch.checkConnectDatabase(infoDBPopQueue.getIpaddress(), infoDBPopQueue);
                    BusyCheckForDatabase.getInstance().release(infoDBPopQueue.getIpaddress());
                } else {
                    logger.warning("Busy Database IP = " + infoDBPopQueue.getIpaddress());
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

